/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.chargen.Rule;
import de.rpgframework.genericrpg.chargen.RuleConfiguration;
import de.rpgframework.genericrpg.chargen.RuleInterpretation;
import de.rpgframework.genericrpg.chargen.RuleValue;
import de.rpgframework.genericrpg.data.CommonCharacter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RuleController {
    private static final System.Logger logger = System.getLogger(RuleController.class.getName() + ".rules");
    private CommonCharacter<?, ?, ?, ?> model;
    private Rule[] allRules;
    private List<RuleInterpretation> interpretations;
    private Map<Rule, RuleValue> effectiveRules;

    public RuleController(CommonCharacter<?, ?, ?, ?> model, List<RuleInterpretation> interpretations, Rule[] allRules) {
        this.model = model;
        this.allRules = allRules;
        this.interpretations = interpretations;
        this.effectiveRules = new LinkedHashMap<Rule, RuleValue>();
        this.updateEffectiveRules();
    }

    public void setModel(CommonCharacter<?, ?, ?, ?> model) {
        this.model = model;
        this.updateEffectiveRules();
    }

    public void set(Rule rule, String value) {
        RuleValue rVal = this.getRule(rule);
        if (!rVal.isEditable()) {
            throw new IllegalArgumentException("Rule " + rule.getID() + " not editable");
        }
        this.model.addRule(rule, value);
        this.updateEffectiveRules();
    }

    public boolean getRuleValueAsBoolean(Rule rule) {
        if (!this.effectiveRules.containsKey(rule)) {
            return rule.getDefaultAsBooleanValue();
        }
        if (this.effectiveRules.get(rule).getValue() instanceof String) {
            return Boolean.parseBoolean((String)this.effectiveRules.get(rule).getValue());
        }
        return (Boolean)this.effectiveRules.get(rule).getValue();
    }

    public int getRuleValueAsInteger(Rule rule) {
        return (Integer)this.effectiveRules.get(rule).getValue();
    }

    public <E extends Enum> E getRuleValueAsEnum(Rule rule) {
        return (E)((Enum)this.effectiveRules.get(rule).getValue());
    }

    public void setRuleValue(Rule rule, Object value) {
        RuleValue rVal = this.effectiveRules.get(rule);
        if (!rVal.isEditable()) {
            throw new IllegalStateException("Rule " + rule.getID() + " not editable");
        }
        rVal.setValue(value);
        String sVal = rule.encodeString(value);
        this.model.setRuleValue(rule, sVal);
        this.effectiveRules.put(rule, rVal);
        this.model.getCarriedItems().forEach(ci -> ci.setDirty(true));
    }

    private Rule getRule(String id) {
        for (Rule rule : this.allRules) {
            if (!rule.getID().equals(id)) continue;
            return rule;
        }
        return null;
    }

    private RuleInterpretation getRuleInterpretation(String id) {
        for (RuleInterpretation rule : this.interpretations) {
            if (!rule.getId().equals(id)) continue;
            return rule;
        }
        return null;
    }

    public RuleValue getRule(Rule rule) {
        for (Map.Entry<Rule, RuleValue> entry : this.effectiveRules.entrySet()) {
            if (entry.getKey() != rule) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEffectiveRules() {
        logger.log(System.Logger.Level.DEBUG, "ENTER updateEffectiveRules for " + String.valueOf(this));
        try {
            this.effectiveRules.clear();
            for (Rule rule : this.allRules) {
                RuleValue rVal = new RuleValue(rule);
                this.effectiveRules.put(rule, rVal);
                logger.log(System.Logger.Level.DEBUG, "start with {0}", rVal);
            }
            if (this.model != null) {
                for (RuleConfiguration rc : new ArrayList<RuleConfiguration>(this.model.getRuleValues())) {
                    Rule rule = this.getRule(rc.getRuleId());
                    if (rule == null) {
                        this.model.getRuleValues().remove(rc);
                        continue;
                    }
                    RuleValue rv = this.getRule(rule);
                    try {
                        rv.setValue(rule.parseValue(rc.getValueString()));
                        logger.log(System.Logger.Level.DEBUG, "stored in character: " + String.valueOf(rv));
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Cannot parse '" + rc.getValueString() + "' for rule " + String.valueOf(rule), (Throwable)e);
                        this.model.getRuleValues().remove(rc);
                        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{1, "I found an illegal value for rule " + rule.getID() + " in this character and removed it"});
                    }
                }
                if (this.model.getStrictness() != null) {
                    RuleInterpretation inter = this.getRuleInterpretation(this.model.getStrictness());
                    if (inter == null) {
                        logger.log(System.Logger.Level.ERROR, "Character uses an unknown rule interpretation: " + this.model.getStrictness());
                    } else {
                        for (RuleConfiguration set : inter.getRules()) {
                            Rule rule;
                            rule = this.getRule(set.getRuleId());
                            RuleValue rv = this.getRule(rule);
                            rv.setValue(rule.parseValue(set.getValueString()));
                            this.model.clearRuleValue(rule);
                            rv.setEditable(false);
                            logger.log(System.Logger.Level.DEBUG, "by strictness: " + String.valueOf(rv));
                        }
                    }
                }
            }
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE updateEffectiveRules");
        }
    }

    public List<RuleValue> getValues() {
        return new ArrayList<RuleValue>(this.effectiveRules.values());
    }
}

