/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.export;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.genericrpg.export.CharacterExportPlugin;
import de.rpgframework.genericrpg.export.ExportPlugin;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExportPluginRegistry {
    private static final Map<RoleplayingSystem, List<ExportPlugin>> pluginsBySystem = new LinkedHashMap<RoleplayingSystem, List<ExportPlugin>>();

    public static void register(ExportPlugin plugin) {
        List<ExportPlugin> list = pluginsBySystem.get(plugin.getRoleplayingSystem());
        if (list == null) {
            list = new ArrayList<ExportPlugin>();
            pluginsBySystem.put(plugin.getRoleplayingSystem(), list);
        }
        if (!list.contains(plugin)) {
            list.add(plugin);
        }
    }

    public static List<CharacterExportPlugin> getCharacterExportPlugins(RuleSpecificCharacterObject<?, ?, ?, ?> model) {
        ArrayList<CharacterExportPlugin> ret = new ArrayList<CharacterExportPlugin>();
        List<ExportPlugin> list = pluginsBySystem.get(model.getRules());
        if (list != null) {
            for (ExportPlugin plugin : list) {
                if (!(plugin instanceof CharacterExportPlugin)) continue;
                ret.add((CharacterExportPlugin)plugin);
            }
        }
        return ret;
    }
}

