/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.IReferenceResolver;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.AAvailableSlot;
import de.rpgframework.genericrpg.items.AItemEnhancement;
import de.rpgframework.genericrpg.items.CarryMode;
import de.rpgframework.genericrpg.items.GearTool;
import de.rpgframework.genericrpg.items.Hook;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeFloatValue;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.genericrpg.items.ItemAttributeObjectValue;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.items.ItemEnhancementValue;
import de.rpgframework.genericrpg.items.OperationMode;
import de.rpgframework.genericrpg.items.OperationModeOption;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.genericrpg.items.Usage;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ValueModification;
import de.rpgframework.genericrpg.persist.IntegerArrayConverter;
import de.rpgframework.genericrpg.requirements.Requirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.prelle.simplepersist.AttribConvert;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Element;
import org.prelle.simplepersist.ElementList;
import org.prelle.simplepersist.Root;

@Root(name="item")
public class CarriedItem<T extends PieceOfGear>
extends ComplexDataItemValue<T>
implements IReferenceResolver {
    static final System.Logger logger = System.getLogger(CarriedItem.class.getPackageName());
    @Attribute(name="variant", required=false)
    private String variantRef;
    @Attribute(required=false)
    private CarryMode mode = CarryMode.CARRIED;
    @Element
    private String description;
    @Attribute(required=false)
    private int count;
    @Attribute
    private Hook slot;
    @ElementList(type=String.class, entry="set")
    private List<String> equipmentSets;
    @Element
    private String notes;
    @Element
    private byte[] image;
    @Element
    private Boolean primary;
    @Element(name="mode")
    protected String activeMode;
    @Attribute(name="changes")
    @AttribConvert(value=IntegerArrayConverter.class)
    protected int[] modificationSlotChanges;
    private transient PieceOfGearVariant variant;
    private transient List<Usage> allowedHooks;
    private transient Map<IItemAttribute, ItemAttributeValue<IItemAttribute>> attributes;
    protected transient List<Requirement> requirements;
    @ElementList(entry="item", type=CarriedItem.class)
    private List<CarriedItem<T>> accessories;
    @ElementList(entry="enhancement", type=ItemEnhancementValue.class)
    private List<ItemEnhancementValue> enhancements;
    protected transient Lifeform user;
    protected transient boolean isInitialized = false;
    protected transient Map<Hook, AAvailableSlot<? extends Hook, T>> slots;
    protected transient List<ItemEnhancementValue> autoEnhancements;
    protected transient List<CarriedItem<?>> alternates;
    protected transient boolean dirty = true;
    protected transient CarriedItem<T> parent;
    private transient OperationResult<List<Modification>> lastRecalculateResult;

    public CarriedItem() {
        this.attributes = new HashMap<IItemAttribute, ItemAttributeValue<IItemAttribute>>();
        this.requirements = new ArrayList<Requirement>();
        this.decisions = new ArrayList();
        this.accessories = new ArrayList<CarriedItem<T>>();
        this.enhancements = new ArrayList<ItemEnhancementValue>();
        this.autoEnhancements = new ArrayList<ItemEnhancementValue>();
        this.alternates = new ArrayList();
        this.allowedHooks = new ArrayList<Usage>();
        this.isInitialized = true;
        this.slots = new HashMap<Hook, AAvailableSlot<? extends Hook, T>>();
        this.uuid = UUID.randomUUID();
    }

    public CarriedItem(CarriedItem<T> toCopy) {
        super((PieceOfGear)toCopy.getResolved());
        this.attributes = CarriedItem.deepCopy(toCopy.attributes);
        this.requirements = new ArrayList<Requirement>();
        this.decisions = new ArrayList(toCopy.decisions);
        this.accessories = new ArrayList<CarriedItem<T>>();
        this.enhancements = new ArrayList<ItemEnhancementValue>();
        this.autoEnhancements = new ArrayList<ItemEnhancementValue>();
        this.alternates = new ArrayList();
        this.allowedHooks = new ArrayList<Usage>();
        this.isInitialized = true;
        this.slots = new HashMap<Hook, AAvailableSlot<? extends Hook, T>>();
        this.uuid = UUID.randomUUID();
    }

    public static Map<IItemAttribute, ItemAttributeValue<IItemAttribute>> deepCopy(Map<IItemAttribute, ItemAttributeValue<IItemAttribute>> old) {
        HashMap<IItemAttribute, ItemAttributeValue<IItemAttribute>> copy = new HashMap<IItemAttribute, ItemAttributeValue<IItemAttribute>>();
        for (Map.Entry<IItemAttribute, ItemAttributeValue<IItemAttribute>> entry : old.entrySet()) {
            copy.put(entry.getKey(), (ItemAttributeValue)entry.getValue().clone());
        }
        return copy;
    }

    public CarriedItem(T item, PieceOfGearVariant<?> variant, CarryMode mode) {
        super(item);
        this.mode = mode;
        if (variant != null) {
            this.variant = variant;
            this.variantRef = variant.getId();
        }
        this.uuid = UUID.randomUUID();
        this.attributes = new HashMap<IItemAttribute, ItemAttributeValue<IItemAttribute>>();
        this.requirements = new ArrayList<Requirement>();
        this.decisions = new ArrayList();
        this.accessories = new ArrayList<CarriedItem<T>>();
        this.setResolved(item, variant);
        this.enhancements = new ArrayList<ItemEnhancementValue>();
        this.autoEnhancements = new ArrayList<ItemEnhancementValue>();
        this.alternates = new ArrayList();
        this.allowedHooks = new ArrayList<Usage>();
        this.isInitialized = true;
        this.slots = new HashMap<Hook, AAvailableSlot<? extends Hook, T>>();
    }

    public String toString() {
        return "CarriedItem(" + this.getKey() + ")";
    }

    @Override
    public String getNameWithoutRating(Locale loc) {
        if (this.customName != null) {
            return this.customName;
        }
        if (this.resolved == null) {
            return this.ref;
        }
        String baseName = ((PieceOfGear)this.resolved).getName(loc);
        if (this.variant != null) {
            return this.variant.isNoBasename() ? this.variant.getName(loc) : baseName + " (" + this.variant.getName(loc) + ")";
        }
        return baseName;
    }

    @Override
    public String getNameWithoutRating() {
        return this.getNameWithoutRating(Locale.getDefault());
    }

    @Override
    public String getNameWithRating(Locale loc) {
        String baseName = this.getNameWithoutRating(loc);
        if (this.getDecision(UUID.fromString("c2d17c87-1cfe-4355-9877-a20fe09c170d")) != null) {
            return baseName + " " + this.getDecision(UUID.fromString("c2d17c87-1cfe-4355-9877-a20fe09c170d")).getValueAsInt();
        }
        if (this.value == 0) {
            return baseName;
        }
        return baseName + " " + this.value;
    }

    public String getNameWithCount(Locale loc) {
        if (this.count > 1) {
            return this.getNameWithRating(loc) + " (" + this.count + "x)";
        }
        return this.getNameWithRating(loc);
    }

    public String getTemplateID() {
        return this.getKey();
    }

    public void setResolved(T template, PieceOfGearVariant variant) {
        this.resolved = template;
        this.variant = variant;
        if (variant != null) {
            this.variantRef = variant.getId();
        }
        if (this.isInitialized) {
            this.refresh();
        }
    }

    private void refresh() {
        logger.log(System.Logger.Level.TRACE, "START: refresh() " + String.valueOf(this.uuid) + "  " + this.ref);
        try {
            this.attributes.clear();
            this.requirements.clear();
            this.allowedHooks.clear();
            GearTool.recalculate("", ((PieceOfGear)this.getResolved()).getReferenceType(), this.user, this);
        }
        finally {
            logger.log(System.Logger.Level.TRACE, "STOP : refresh() " + String.valueOf(this.uuid) + "  " + this.ref);
        }
    }

    public Collection<ItemAttributeValue<IItemAttribute>> getAttributes() {
        return this.attributes.values();
    }

    public Collection<IItemAttribute> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public <A extends IItemAttribute> ItemAttributeNumericalValue<A> getAsValue(A attrib) {
        if (this.attributes.get(attrib) == null) {
            return null;
        }
        if (this.attributes.get(attrib) instanceof ItemAttributeNumericalValue) {
            return (ItemAttributeNumericalValue)this.attributes.get(attrib);
        }
        throw new ClassCastException("getAsValue() is the wrong method for " + this.attributes.get(attrib).getClass().getSimpleName() + "=" + String.valueOf(this.attributes.get(attrib)));
    }

    public <A extends IItemAttribute> boolean isFloat(A attrib) {
        if (this.attributes.get(attrib) == null) {
            return false;
        }
        return this.attributes.get(attrib) instanceof ItemAttributeFloatValue;
    }

    public <A extends IItemAttribute> ItemAttributeFloatValue<A> getAsFloat(A attrib) {
        if (this.attributes.get(attrib) == null) {
            return null;
        }
        if (this.attributes.get(attrib) instanceof ItemAttributeFloatValue) {
            return (ItemAttributeFloatValue)this.attributes.get(attrib);
        }
        throw new ClassCastException("getAsFloat() is the wrong method for " + this.attributes.get(attrib).getClass().getSimpleName() + "=" + String.valueOf(this.attributes.get(attrib)));
    }

    public <A extends IItemAttribute> ItemAttributeObjectValue<A> getAsObject(A attrib) {
        return (ItemAttributeObjectValue)this.attributes.get(attrib);
    }

    public void setDecisions(List<Decision> val) {
        this.decisions = val;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public void setAttribute(IItemAttribute attrib, ItemAttributeValue val) {
        this.attributes.put(attrib, val);
        if (attrib.name().equals("PRICE") && val instanceof ItemAttributeObjectValue) {
            throw new IllegalArgumentException("Should not be an object");
        }
    }

    public ItemAttributeValue<?> getAttributeRaw(IItemAttribute key) {
        return this.attributes.get(key);
    }

    public String dump() {
        StringBuffer buf = new StringBuffer(String.valueOf(this.uuid));
        for (ItemAttributeValue<IItemAttribute> itemAttributeValue : this.attributes.values()) {
            buf.append("\n  " + String.valueOf(itemAttributeValue.getModifyable()) + " : " + String.valueOf(itemAttributeValue) + " = " + String.valueOf(itemAttributeValue.getClass()));
        }
        buf.append("\nSlots\n");
        for (AAvailableSlot aAvailableSlot : this.slots.values()) {
            buf.append(String.format(" %20s  \t%s\n", aAvailableSlot.getHook(), aAvailableSlot));
        }
        return buf.toString();
    }

    public String getVariantID() {
        return this.variantRef;
    }

    public PieceOfGearVariant getVariant() {
        return this.variant;
    }

    public void setVariant(PieceOfGearVariant variant) {
        this.variant = variant;
    }

    public void addRequirement(Requirement req) {
        this.requirements.add(req);
    }

    public List<Requirement> getRequirements() {
        return new ArrayList<Requirement>(this.requirements);
    }

    public int getCount() {
        if (this.count == 0) {
            return 1;
        }
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Lifeform getUser() {
        return this.user;
    }

    public void setUser(Lifeform user) {
        this.user = user;
    }

    public void addAccessory(CarriedItem<T> val, Hook slot) {
        if (this.getSlot(slot) == null) {
            throw new NullPointerException("No slot " + String.valueOf(slot) + " in item " + this.getKey() + " (from " + String.valueOf(((PieceOfGear)this.getResolved()).getAssignedDataSets()) + ") to add accessory " + String.valueOf(val));
        }
        if (val.getUuid() != null) {
            for (CarriedItem<T> already : this.accessories) {
                if (!val.getUuid().equals(already.getUuid())) continue;
                throw new RuntimeException("Already added");
            }
        }
        logger.log(System.Logger.Level.INFO, "Add accessory ''{0}'' to slot {1}", val.getKey(), slot);
        val.setUsedSlot(slot);
        val.parent = this;
        this.accessories.add(val);
        ((AAvailableSlot)this.getSlot(slot)).addEmbeddedItem(val);
    }

    public boolean removeAccessory(CarriedItem<T> val, Hook slot) {
        boolean notFound = true;
        if (val.getUuid() != null) {
            for (CarriedItem<T> already : this.accessories) {
                if (!val.getUuid().equals(already.getUuid()) && val != already) continue;
                notFound = false;
            }
        }
        if (notFound) {
            for (CarriedItem<T> already : this.accessories) {
                if (val != already) continue;
                notFound = false;
            }
        }
        if (notFound) {
            logger.log(System.Logger.Level.ERROR, "{0}: No item Removed {1} with UUID {3} in {2}", this.getKey(), val, slot, val.getUuid());
            return false;
        }
        val.setUsedSlot(null);
        val.parent = null;
        this.accessories.remove(val);
        this.slots.get(slot).removeEmbeddedItem(val);
        logger.log(System.Logger.Level.DEBUG, "{0}: Removed {1} from {2}", this.getKey(), val, slot);
        return true;
    }

    public List<CarriedItem<T>> getAccessories() {
        return this.accessories;
    }

    public List<CarriedItem<T>> getAccessory(String id, String variant) {
        ArrayList<CarriedItem<T>> ret = new ArrayList<CarriedItem<T>>();
        for (CarriedItem<T> tmp : this.getEffectiveAccessories()) {
            if (!tmp.getKey().equals(id) || variant != null && !variant.equals(tmp.getVariantID())) continue;
            ret.add(tmp);
        }
        return ret;
    }

    public Collection<CarriedItem<T>> getEffectiveAccessories() {
        ArrayList<CarriedItem<T>> ret = new ArrayList<CarriedItem<T>>();
        for (CarriedItem<T> tmp : this.accessories) {
            ret.add(tmp);
            ret.addAll(tmp.getEffectiveAccessories());
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.clearModificationsFromCharacter();
        this.clearOutgoingModifications();
        this.autoEnhancements.clear();
        this.slots.clear();
        for (CarriedItem<T> carriedItem : new ArrayList<CarriedItem<T>>(this.accessories)) {
            if (!"DEFAULT".equals(carriedItem.getInjectedBy())) continue;
            this.accessories.remove(carriedItem);
        }
        for (ItemAttributeValue itemAttributeValue : this.attributes.values()) {
            itemAttributeValue.clearIncomingModifications();
        }
        this.clearIncomingModifications();
        this.autoFlags.clear();
    }

    public <A extends AAvailableSlot<? extends Hook, T>> A getSlot(Hook slot) {
        return (A)this.slots.get(slot);
    }

    public Collection<AAvailableSlot<? extends Hook, T>> getSlots() {
        return this.slots.values();
    }

    public void addSlot(AAvailableSlot slot) {
        if (this.slots.containsKey(slot.getHook())) {
            throw new IllegalStateException("Hook " + String.valueOf(slot) + " already exists");
        }
        this.slots.put((Hook)slot.getHook(), slot);
    }

    public void removeSlot(Hook hook) {
        this.slots.remove(hook);
    }

    public Hook getUsedSlot() {
        return this.slot;
    }

    public void setUsedSlot(Hook slot) {
        this.slot = slot;
    }

    public CarryMode getCarryMode() {
        return this.mode;
    }

    public void setCarryMode(CarryMode mode) {
        this.mode = mode;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public boolean hasAttribute(IItemAttribute key) {
        return this.attributes.containsKey(key);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public CarriedItem<T> getEmbeddedItem(String id) {
        for (CarriedItem<T> tmp : this.getEffectiveAccessories()) {
            if (!tmp.getKey().equals(id)) continue;
            return tmp;
        }
        return null;
    }

    public List<OperationModeOption> getOperationModes(boolean recursive) {
        ArrayList<OperationModeOption> options = new ArrayList<OperationModeOption>();
        List<OperationMode> modes = ((PieceOfGear)this.getResolved()).getOperationModes();
        if (!modes.isEmpty()) {
            OperationModeOption option = new OperationModeOption(this, modes);
            options.add(option);
        }
        if (recursive) {
            for (CarriedItem<T> acc : this.getAccessories()) {
                options.addAll(acc.getOperationModes(true));
            }
        }
        return new ArrayList<OperationModeOption>(options);
    }

    public List<OperationMode> getActiveOperationModes(boolean recursive) {
        ArrayList<OperationMode> ret = new ArrayList<OperationMode>();
        if (this.mode != null) {
            List<OperationMode> modes = ((PieceOfGear)this.getResolved()).getOperationModes();
            for (OperationMode tmp : modes) {
                if (!tmp.id.equals(this.activeMode)) continue;
                ret.add(tmp);
            }
        }
        if (recursive) {
            for (CarriedItem<T> acc : this.getAccessories()) {
                ret.addAll(acc.getActiveOperationModes(true));
            }
        }
        return ret;
    }

    public void setMode(OperationMode mode, boolean active) {
        if (!active) {
            if (mode.getId().equals(this.activeMode)) {
                this.activeMode = null;
                this.dirty = true;
            }
            return;
        }
        List<OperationMode> modes = ((PieceOfGear)this.getResolved()).getOperationModes();
        for (OperationMode tmp : modes) {
            if (tmp != mode) continue;
            this.activeMode = mode.id;
            this.dirty = true;
            break;
        }
    }

    public void addAutoEnhancement(ItemEnhancementValue value) {
        this.autoEnhancements.add(value);
    }

    public <E extends AItemEnhancement> List<ItemEnhancementValue<E>> getEnhancements() {
        ArrayList ret = new ArrayList();
        this.autoEnhancements.forEach(e -> ret.add((ItemEnhancementValue)e));
        this.enhancements.forEach(e -> ret.add((ItemEnhancementValue)e));
        return ret;
    }

    public <E extends AItemEnhancement> ItemEnhancementValue<E> getEnhancement(E data) {
        for (ItemEnhancementValue val : this.enhancements) {
            if (val.getResolved() != data) continue;
            return val;
        }
        return null;
    }

    public boolean hasEnhancement(AItemEnhancement value) {
        return this.getEnhancements().stream().anyMatch(e -> ((AItemEnhancement)e.getResolved()).equals(value));
    }

    public void addEnhancement(ItemEnhancementValue value) {
        this.enhancements.add(value);
        this.dirty = true;
    }

    public void removeEnhancement(ItemEnhancementValue value) {
        this.enhancements.remove(value);
        this.dirty = true;
    }

    public int getModificationSlotsUsed() {
        int capacityUsed = 0;
        for (ItemEnhancementValue tmp : this.getEnhancements()) {
            if (tmp.isAutoAdded()) continue;
            capacityUsed += ((AItemEnhancement)tmp.getResolved()).getSize();
        }
        return capacityUsed;
    }

    public List<CarriedItem<?>> getAlternates() {
        return this.alternates;
    }

    public void addAlternates(CarriedItem<?> alt) {
        this.alternates.add(alt);
    }

    public void clearAlternates() {
        this.alternates.clear();
    }

    @Override
    public <T> T resolveItem(String key) {
        return ((IReferenceResolver)((Object)this.resolved)).resolveItem(key);
    }

    public CarriedItem<T> getParent() {
        return this.parent;
    }

    public void setParent(CarriedItem<T> parent) {
        this.parent = parent;
    }

    public int[] getModificationSlotChanges() {
        return this.modificationSlotChanges;
    }

    public void setModificationSlotChanges(int[] modificationSlotChanges) {
        this.modificationSlotChanges = modificationSlotChanges;
    }

    public void setLastRecalculateResult(OperationResult<List<Modification>> unprocessed) {
        this.lastRecalculateResult = unprocessed;
    }

    public OperationResult<List<Modification>> getLastRecalculateResult() {
        return this.lastRecalculateResult;
    }

    public void clearModificationsFromCharacter() {
        for (ItemAttributeValue<IItemAttribute> val : this.attributes.values()) {
            val.removeIncomingModifications(Modification.Origin.OUTSIDE);
        }
    }

    public void addModificationFromCharacter(ValueModification mod) {
        mod.setOrigin(Modification.Origin.OUTSIDE);
        ItemAttributeValue<?> val = this.getAttributeRaw((IItemAttribute)mod.getResolvedKey());
        if (val == null) {
            logger.log(System.Logger.Level.ERROR, "Trying to add modification to unknown attribute {0} in {1}", mod.getResolvedKey(), this.getKey());
        }
        val.addIncomingModification(mod);
    }

    public List<Usage> getAllowedHooks() {
        return this.allowedHooks;
    }

    public void setAllowedHooks(Collection<Usage> value) {
        this.allowedHooks.clear();
        this.allowedHooks.addAll(value);
    }
}

