/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.ApplyTo;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.requirements.Requirement;
import java.util.List;

public class CopyRequirementsStep
implements CarriedItemProcessor {
    private static final System.Logger logger = CarriedItem.logger;

    @Override
    public OperationResult<List<Modification>> process(boolean strict, ModifiedObjectType refType, Lifeform user, CarriedItem<?> model, List<Modification> unprocessed) {
        OperationResult<List<Modification>> ret = new OperationResult<List<Modification>>(unprocessed);
        PieceOfGear template = (PieceOfGear)model.getResolved();
        for (Requirement req : template.getRequirements()) {
            if (req.getApply() == null || req.getApply() == ApplyTo.CHARACTER || req.getApply() == ApplyTo.DATA_ITEM) {
                model.addRequirement(req);
                logger.log(System.Logger.Level.DEBUG, "Add requirement " + String.valueOf(req));
                continue;
            }
            logger.log(System.Logger.Level.INFO, "Forget requirement " + String.valueOf(req));
        }
        if (model.getVariant() != null) {
            for (Requirement req : model.getVariant().getRequirements()) {
                if (req.getApply() == null || req.getApply() == ApplyTo.CHARACTER || req.getApply() == ApplyTo.DATA_ITEM) {
                    model.addRequirement(req);
                    logger.log(System.Logger.Level.DEBUG, "Add requirement " + String.valueOf(req));
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Forget requirement " + String.valueOf(req));
            }
        }
        return ret;
    }
}

