/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import de.rpgframework.genericrpg.modification.ModifyableImpl;
import de.rpgframework.genericrpg.persist.StringArrayConverter;
import java.util.UUID;
import org.prelle.simplepersist.AttribConvert;
import org.prelle.simplepersist.Attribute;

public class ItemAttributeDefinition
extends ModifyableImpl {
    @Attribute(name="id", required=true)
    private IItemAttribute id;
    @Attribute(name="value")
    private String value;
    private transient Formula parsedValue;
    @Attribute(name="choice", required=false)
    private UUID choice;
    @Attribute(name="table")
    @AttribConvert(value=StringArrayConverter.class)
    private String[] lookupTable;

    public ItemAttributeDefinition() {
    }

    public ItemAttributeDefinition(IItemAttribute key) {
        this.id = key;
    }

    public String toString() {
        return String.valueOf(this.id) + "=" + this.value + "(parsed=" + String.valueOf(this.parsedValue) + ")";
    }

    public ItemAttributeDefinition(IItemAttribute key, Formula distributed) {
        this.id = key;
        this.parsedValue = distributed;
        this.value = String.valueOf(distributed);
        if (distributed.isFloat()) {
            this.value = String.valueOf(distributed.getAsFloat() * 1000.0f);
        }
    }

    public IItemAttribute getModifyable() {
        return this.id;
    }

    public Formula getFormula() {
        if (this.parsedValue == null) {
            this.parsedValue = FormulaTool.tokenize(this.value);
        }
        return this.parsedValue;
    }

    public void setFormula(Formula value) {
        this.parsedValue = value;
    }

    public String getRawValue() {
        return this.value;
    }

    public void setRawValue(String val) {
        this.value = val;
    }

    public int getDistributed() {
        return this.getFormula().getAsInteger();
    }

    public <T> T getValue() {
        return this.getFormula().getAsObject(this.id.getConverter());
    }

    public boolean isInteger() {
        if (this.parsedValue == null) {
            this.getFormula();
        }
        if (this.parsedValue != null) {
            return this.parsedValue.isInteger();
        }
        throw new IllegalStateException("Not resolved yet");
    }

    public String[] getLookupTable() {
        return this.lookupTable;
    }
}

