/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.items.CarryMode;
import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.Hook;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import org.prelle.simplepersist.Attribute;

public class Usage {
    @Attribute
    private CarryMode mode;
    @Attribute
    private Hook slot;
    @Attribute
    private String value;
    @Attribute
    private String type;
    private transient Formula parsedValue;

    public Usage() {
        this.mode = CarryMode.CARRIED;
    }

    public Usage(CarryMode mode) {
        this.mode = mode;
    }

    public Usage(CarryMode mode, Hook slot) {
        this.mode = mode;
        this.slot = slot;
    }

    public String toString() {
        switch (this.mode) {
            case CARRIED: {
                return this.mode.name();
            }
            case EMBEDDED: {
                return this.mode.name() + " into " + String.valueOf(this.slot) + (String)(this.value != null ? " for " + this.value + " capacity" : "");
            }
            case IMPLANTED: {
                return this.mode.name() + (String)(this.value != null ? " for " + this.value + " essence" : "");
            }
        }
        return this.mode.name();
    }

    public CarryMode getMode() {
        return this.mode;
    }

    public <H extends Hook> H getSlot() {
        return (H)this.slot;
    }

    public Formula getFormula() {
        if (this.parsedValue == null && this.value != null) {
            this.parsedValue = FormulaTool.tokenize(this.value);
        }
        return this.parsedValue;
    }

    public void setFormula(Formula value) {
        this.parsedValue = value;
    }

    public String getRawValue() {
        return this.value;
    }

    public void setRawValue(String val) {
        this.value = val;
    }

    public float getSize() {
        if (this.getFormula().isFloat()) {
            return this.getFormula().getAsFloat();
        }
        return (float)this.getFormula().getAsInteger() / 1000.0f;
    }

    public String getType() {
        return this.type;
    }

    public <H extends Hook> void setSlot(H slot) {
        this.slot = slot;
    }
}

