/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.modification;

import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.data.ApplyTo;
import de.rpgframework.genericrpg.data.ApplyWhen;
import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.persist.StringArrayConverter;
import org.prelle.simplepersist.AttribConvert;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Root;

@Root(name="valmod")
public class ValueModification
extends DataItemModification
implements Cloneable {
    @Attribute(name="value", required=true)
    private String value;
    @Attribute(name="absolute", required=false)
    private boolean absolute;
    private transient Formula parsedValue;
    @Attribute(name="set", required=false)
    private ValueType set = ValueType.AUGMENTED;
    @Attribute(name="unlimited", required=false)
    private boolean ignoreLimit;
    @Attribute(name="table")
    @AttribConvert(value=StringArrayConverter.class)
    private String[] lookupTable;
    private transient boolean instantiated;

    public ValueModification() {
    }

    public ValueModification(ModifiedObjectType type, String ref, int val) {
        this(type, ref, String.valueOf(val));
    }

    public ValueModification(ModifiedObjectType type, String ref, int val, Object src) {
        this(type, ref, String.valueOf(val));
        this.source = src;
    }

    public ValueModification(ModifiedObjectType type, String ref, int val, Object src, ValueType set) {
        this(type, ref, String.valueOf(val));
        this.source = src;
        this.set = set;
    }

    public ValueModification(ModifiedObjectType type, String ref, String val, Object src) {
        this(type, ref, val);
        this.source = src;
    }

    public ValueModification(ModifiedObjectType type, String ref, String val) {
        super(type, ref);
        this.value = val;
        this.when = ApplyWhen.ALLCREATE;
    }

    public ValueModification(ModifiedObjectType type, String ref, int val, ApplyWhen when, ValueType set) {
        this(type, ref, String.valueOf(val), when, set);
    }

    public ValueModification(ModifiedObjectType type, String ref, String val, ApplyWhen when, ValueType set) {
        super(type, ref);
        this.value = val;
        this.when = when;
        this.set = set;
    }

    public ValueModification(ModifiedObjectType type, String ref, int val, ApplyTo to, ValueType set) {
        this(type, ref, String.valueOf(val), to, set);
    }

    public ValueModification(ModifiedObjectType type, String ref, String val, ApplyTo to, ValueType set) {
        super(type, ref);
        this.value = val;
        this.apply = to;
        this.set = set;
    }

    @Override
    public ValueModification clone() {
        return (ValueModification)super.clone();
    }

    public boolean hasFormula() {
        return this.value.contains("$") || this.value.contains("&");
    }

    public boolean isModMin() {
        return this.value.contains("|");
    }

    public boolean isDouble() {
        if (this.value == null) {
            return false;
        }
        return this.value.contains(".");
    }

    @Override
    public String toString() {
        String setP = "";
        String setS = "";
        if (this.set != null) {
            switch (this.set) {
                case MAX: {
                    setP = "max.";
                    break;
                }
                case MIN: {
                    setP = "min.";
                }
            }
        }
        return String.valueOf(this.type) + ":" + this.ref + "(val=" + this.value + ",set=" + String.valueOf((Object)this.set) + ",apply=" + String.valueOf((Object)this.apply) + ",src=" + String.valueOf(this.source) + ")";
    }

    public int getValue() {
        if (this.value == null) {
            if (this.parsedValue != null) {
                System.getLogger("rpgframework.rules").log(System.Logger.Level.ERROR, "Value of " + String.valueOf(this) + " is NULL");
            }
            return 0;
        }
        if (this.value.contains(",")) {
            if (this.value.indexOf(",") == 0) {
                return 0;
            }
            return Integer.parseInt(this.value.substring(0, this.value.indexOf(",")));
        }
        if (this.value.contains("$")) {
            System.getLogger("rpgframework.rules").log(System.Logger.Level.WARNING, "Cannot perform getValue() on formula " + this.value + " from " + String.valueOf(this.source));
            return 0;
        }
        if (this.value.contains("/")) {
            return 0;
        }
        return Integer.parseInt(this.value);
    }

    public double getValueAsDouble() {
        if (this.value == null) {
            if (this.parsedValue != null) {
                System.getLogger("rpgframework.rules").log(System.Logger.Level.ERROR, "Value of " + String.valueOf(this) + " is NULL");
            }
            return 0.0;
        }
        if (this.value.contains(",")) {
            return Double.parseDouble(this.value.substring(0, this.value.indexOf(",")));
        }
        return Double.parseDouble(this.value);
    }

    public String[] getValueAsKeys() {
        return this.value.trim().split(",");
    }

    public int[] getModMinValues() {
        String[] tmp = this.value.trim().split("\\|");
        int[] ret = new int[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            ret[i] = Integer.parseInt(tmp[i]);
        }
        return ret;
    }

    public Formula getFormula() {
        if (this.parsedValue == null) {
            this.parsedValue = FormulaTool.tokenize(this.value);
        }
        return this.parsedValue;
    }

    public void setFormula(Formula value) {
        this.parsedValue = value;
    }

    public String getRawValue() {
        return this.value;
    }

    public void setRawValue(String val) {
        this.value = val;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = String.valueOf(value);
    }

    public ValueType getSet() {
        return this.set;
    }

    public void setSet(ValueType val) {
        this.set = val;
    }

    public boolean isIgnoreLimit() {
        return this.ignoreLimit;
    }

    public String[] getLookupTable() {
        return this.lookupTable;
    }

    public void setLookupTable(String[] table) {
        this.lookupTable = table;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public void setInstantiated(boolean instantiated) {
        this.instantiated = instantiated;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }
}

