/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.requirements;

import de.rpgframework.genericrpg.data.ReferenceException;
import de.rpgframework.genericrpg.requirements.ExistenceRequirement;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.genericrpg.requirements.ResolvableRequirement;
import de.rpgframework.genericrpg.requirements.ValueRequirement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.prelle.simplepersist.ElementList;
import org.prelle.simplepersist.ElementListUnion;
import org.prelle.simplepersist.Root;

@Root(name="selreq")
public class AnyRequirement
extends Requirement
implements ResolvableRequirement {
    @ElementListUnion(value={@ElementList(entry="datareq", type=ExistenceRequirement.class), @ElementList(entry="valuereq", type=ValueRequirement.class)})
    protected List<Requirement> optionList;

    public AnyRequirement() {
        this.optionList = new ArrayList<Requirement>();
    }

    public AnyRequirement(List<Requirement> mods) {
        this.optionList = mods;
    }

    public AnyRequirement(Requirement ... mods) {
        this.optionList = new ArrayList<Requirement>();
        for (Requirement tmp : mods) {
            this.optionList.add(tmp);
        }
    }

    public void add(Requirement mod) {
        if (!this.optionList.contains(mod)) {
            this.optionList.add(mod);
        }
    }

    public void add(Object mod) {
        if (!this.optionList.contains(mod) && mod instanceof Requirement) {
            this.optionList.add((Requirement)mod);
        }
    }

    public void remove(Requirement mod) {
        this.optionList.remove(mod);
    }

    public boolean equals(Object o) {
        if (o instanceof AnyRequirement) {
            AnyRequirement mc = (AnyRequirement)o;
            return this.optionList.equals(mc.getOptionList());
        }
        return false;
    }

    public Requirement[] getOptions() {
        Requirement[] modArray = new Requirement[this.optionList.size()];
        modArray = this.optionList.toArray(modArray);
        return modArray;
    }

    public List<Requirement> getOptionList() {
        return new ArrayList<Requirement>(this.optionList);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Require any of (");
        Iterator<Requirement> it = this.optionList.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString());
            if (!it.hasNext()) continue;
            buf.append("|");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public boolean resolve() {
        for (Requirement req : this.optionList) {
            if (!(req instanceof ResolvableRequirement) || ((ResolvableRequirement)((Object)req)).resolve()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate() throws ReferenceException {
        for (Requirement req : this.optionList) {
            req.validate();
        }
    }
}

