/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.worldinfo;

import de.rpgframework.worldinfo.AppliedFilter;
import de.rpgframework.worldinfo.Generator;
import de.rpgframework.worldinfo.WorldInformationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneratorRegistry {
    private static Map<WorldInformationType, List<Generator<?>>> generators = new HashMap();

    public static void register(Generator<?> value) {
        List<Generator<?>> list = generators.get((Object)value.getType());
        if (list == null) {
            list = new ArrayList();
            generators.put(value.getType(), list);
        }
        list.add(value);
    }

    public static List<Generator<?>> getGenerators(WorldInformationType type, final AppliedFilter[] filter) {
        ArrayList ret = new ArrayList();
        if (generators.get((Object)type) != null) {
            for (Generator<?> gen : generators.get((Object)type)) {
                if (!gen.willWork(filter)) continue;
                ret.add(gen);
            }
            Collections.sort(ret, new Comparator<Generator<?>>(){

                @Override
                public int compare(Generator<?> o1, Generator<?> o2) {
                    Long val1 = Arrays.asList(filter).stream().filter(obj -> o1.getSupportedFilter().contains(obj.getFilter())).count();
                    Long val2 = Arrays.asList(filter).stream().filter(obj -> o2.getSupportedFilter().contains(obj.getFilter())).count();
                    return val1.compareTo(val2);
                }
            });
        }
        return ret;
    }
}

