/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.util.List;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.messagestore.HeapMessageStore;
import org.nustaq.kontraktor.remoting.base.messagestore.MessageStore;
import org.nustaq.kontraktor.remoting.websockets.WebObjectSocket;
import org.nustaq.kontraktor.util.Pair;
import org.nustaq.offheap.BinaryQueue;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.nustaq.serialization.util.FSTUtil;

public class HttpObjectSocket
extends WebObjectSocket
implements ObjectSink {
    public static int LP_TIMEOUT = 15000;
    public static int HISTORY_SIZE = 3;
    public static int HTTP_BATCH_SIZE = 500;
    final Runnable closeAction;
    long lastUse;
    long creation;
    String sessionId;
    BinaryQueue queue;
    ObjectSink sink;
    MessageStore store;
    Pair<Runnable, HttpServerExchange> longPollTask;
    Thread myThread;
    long longPollTaskTime;

    public HttpObjectSocket(String sessionId, Runnable closeAction) {
        this.creation = this.lastUse = System.currentTimeMillis();
        this.queue = new BinaryQueue(4096);
        this.store = new HeapMessageStore(HISTORY_SIZE);
        this.sessionId = sessionId;
        this.closeAction = closeAction;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void updateTimeStamp() {
        this.lastUse = System.currentTimeMillis();
    }

    public long getLastUse() {
        return this.lastUse;
    }

    @Override
    public void sendBinary(byte[] message) {
        this.checkThread();
        this.queue.addInt(this.sendSequence.get());
        this.queue.addInt(message.length);
        this.queue.add((ByteSource)new HeapBytez(message));
        this.triggerLongPoll();
    }

    @Override
    public void writeObject(Object toWrite) throws Exception {
        this.checkThread();
        super.writeObject(toWrite);
    }

    public void close() throws IOException {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }

    public void setSink(ObjectSink sink) {
        this.sink = sink;
    }

    public ObjectSink getSink() {
        return this;
    }

    public Pair<byte[], Integer> getNextQueuedMessage() {
        this.checkThread();
        try {
            this.flush();
        }
        catch (Exception e) {
            FSTUtil.rethrow((Throwable)e);
        }
        if (this.queue.available() > 8L) {
            int seq = this.queue.readInt();
            int len = this.queue.readInt();
            if (len > 0 && this.queue.available() >= (long)len) {
                return new Pair((Object)this.queue.readByteArray(len), (Object)seq);
            }
            return new Pair((Object)new byte[0], (Object)0);
        }
        return new Pair((Object)new byte[0], (Object)0);
    }

    protected void checkThread() {
        if (this.myThread == null) {
            this.myThread = Thread.currentThread();
        } else if (this.myThread != Thread.currentThread()) {
            System.out.println("unexpected multithreading detected:" + this.myThread.getName() + " curr:" + Thread.currentThread().getName());
            Thread.dumpStack();
        }
    }

    public Pair<Runnable, HttpServerExchange> getLongPollTask() {
        return this.longPollTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLongPoll() {
        HttpObjectSocket httpObjectSocket = this;
        synchronized (httpObjectSocket) {
            if (this.longPollTask != null) {
                ((HttpServerExchange)this.longPollTask.cdr()).endExchange();
                this.longPollTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerLongPoll() {
        HttpObjectSocket httpObjectSocket = this;
        synchronized (httpObjectSocket) {
            if (this.longPollTask != null) {
                Runnable car = (Runnable)this.longPollTask.car();
                this.longPollTask = null;
                car.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLongPollTask(Pair<Runnable, HttpServerExchange> longPollTask) {
        HttpObjectSocket httpObjectSocket = this;
        synchronized (httpObjectSocket) {
            this.longPollTask = longPollTask;
            this.longPollTaskTime = System.currentTimeMillis();
        }
    }

    public long getLongPollTaskTime() {
        return this.longPollTaskTime;
    }

    public void receiveObject(ObjectSink asink, Object received, List<IPromise> createdFutures) {
        this.sink.receiveObject(asink, received, createdFutures);
    }

    public void sinkClosed() {
        this.sink.sinkClosed();
    }

    public Object takeStoredLPMessage(int seq) {
        return this.store.getMessage((CharSequence)"sen", (long)seq);
    }

    public void storeLPMessage(int inSequence, Object msg) {
        this.store.putMessage((CharSequence)"sen", (long)inSequence, msg);
    }

    @Override
    public void flush() throws Exception {
        if (this.objects.size() == 0) {
            return;
        }
        this.objects.add(this.sendSequence.incrementAndGet());
        Object[] objArr = this.objects.toArray();
        this.objects.clear();
        this.sendBinary(this.conf.asByteArray((Object)objArr));
    }
}

