/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.kontraktor.remoting.http.javascript.DependencyResolver;
import org.nustaq.kontraktor.util.Log;

public class DynamicResourceManager
extends FileResourceManager {
    boolean devMode = false;
    DependencyResolver dependencyResolver;
    String prefix = "";
    String lookupPrefix;
    String mergedPrefix;
    ConcurrentHashMap<String, Resource> lookupCache = new ConcurrentHashMap();

    public DynamicResourceManager(boolean devMode, String prefix, String rootComponent, String ... resourcePath) {
        super(new File("."), 100L);
        this.devMode = devMode;
        this.setPrefix(prefix);
        this.dependencyResolver = new DependencyResolver(prefix + "/" + this.lookupPrefix, prefix + "/" + this.mergedPrefix, rootComponent, resourcePath);
        this.setBase(this.dependencyResolver.locateComponent(rootComponent).get(0));
        if (devMode) {
            Log.Warn((Object)((Object)this), (String)"Dependency resolving is running in *DEVELOPMENT MODE*. Turn off development mode to cache aggregated resources");
        } else {
            Log.Info((Object)((Object)this), (String)"Dependency resolving is running in *PRODUCTION MODE*. Turn on development mode for script-refresh-on-reload and per file javascript debugging");
        }
    }

    public void setPrefix(String prefix) {
        while (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        this.prefix = prefix;
        this.lookupPrefix = "lookup/";
        this.mergedPrefix = "merged/";
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public Resource getResource(String p0) {
        String p = p0;
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        String orgP = p;
        if (!this.isDevMode() && this.lookupCache.get(orgP) != null) {
            return this.lookupCache.get(orgP);
        }
        if (p.startsWith(this.lookupPrefix)) {
            if ((p = p.substring(this.lookupPrefix.length())).startsWith("+")) {
                String[] split = p.substring(1).split("\\+");
                List<String> filesInDirs = this.dependencyResolver.findFilesInDirs((comp, finam) -> {
                    for (int i = 0; i < split.length; ++i) {
                        String s = split[i];
                        if (!finam.equals(s)) continue;
                        return true;
                    }
                    return false;
                });
                byte[] bytes = this.dependencyResolver.mergeBinary(filesInDirs);
                return this.mightCache(orgP, new MyResource(p0, p, bytes, "text/html"));
            }
            File file = this.dependencyResolver.locateResource(p);
            if (file != null) {
                return this.mightCache(orgP, (Resource)new FileResource(file, (FileResourceManager)this, p0));
            }
            return null;
        }
        if (p.startsWith(this.mergedPrefix)) {
            String finalP = p = p.substring(this.mergedPrefix.length());
            List<String> filesInDirs = this.dependencyResolver.findFilesInDirs((comp, finam) -> finam.endsWith(finalP));
            byte[] bytes = finalP.endsWith(".css") ? this.dependencyResolver.mergeBinary(filesInDirs) : this.dependencyResolver.mergeTextSnippets(filesInDirs, "", "");
            return this.mightCache(orgP, new MyResource(p0, finalP, bytes, "text/html"));
        }
        if (p.equals("js") || p.startsWith("+")) {
            List<String> filesInDirs;
            String finalP = p;
            if (p.startsWith("+")) {
                String[] split = p.substring(1).split("\\+");
                filesInDirs = this.dependencyResolver.findFilesInDirs((comp, finam) -> {
                    for (int i = 0; i < split.length; ++i) {
                        String s = split[i];
                        if (!finam.equals(s) && (!comp.equals(s) || !finam.endsWith(".js"))) continue;
                        return true;
                    }
                    return false;
                });
            } else {
                filesInDirs = this.dependencyResolver.findFilesInDirs((comp, finam) -> finam.endsWith(".js"));
            }
            byte[] bytes = null;
            bytes = this.devMode ? this.dependencyResolver.createScriptTags(filesInDirs) : this.dependencyResolver.mergeScripts(filesInDirs);
            return this.mightCache(orgP, new MyResource(p0, finalP, bytes, "text/javascript"));
        }
        return super.getResource(p0);
    }

    private Resource mightCache(String key, Resource fileResource) {
        if (!this.isDevMode()) {
            this.lookupCache.put(key, fileResource);
        }
        return fileResource;
    }

    protected static class MyResource
    implements Resource {
        protected String p0;
        protected String finalP;
        protected byte[] bytes;
        protected String resType;

        public MyResource(String p0, String finalP, byte[] bytes, String resType) {
            this.p0 = p0;
            this.finalP = finalP;
            this.bytes = bytes;
        }

        public String getPath() {
            return this.p0;
        }

        public Date getLastModified() {
            return null;
        }

        public String getLastModifiedString() {
            return null;
        }

        public ETag getETag() {
            return null;
        }

        public String getName() {
            return this.finalP;
        }

        public boolean isDirectory() {
            return false;
        }

        public List<Resource> list() {
            return null;
        }

        public String getContentType(MimeMappings mimeMappings) {
            return this.resType;
        }

        public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
            exchange.startBlocking();
            try {
                exchange.getOutputStream().write(this.bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public Long getContentLength() {
            return this.bytes.length;
        }

        public String getCacheKey() {
            return null;
        }

        public File getFile() {
            return null;
        }

        public File getResourceManagerRoot() {
            return null;
        }

        public URL getUrl() {
            return null;
        }
    }
}

