/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.nustaq.kontraktor.remoting.http.javascript.DependencyResolver;
import org.nustaq.kontraktor.remoting.http.javascript.KUrl;
import org.nustaq.kontraktor.remoting.http.javascript.jsmin.JSMin;
import org.nustaq.kontraktor.util.Log;

public class HtmlImportShim {
    boolean inline = true;
    boolean stripComments = true;
    boolean minify = true;
    KUrl baseUrl;
    ResourceLocator locator;

    public HtmlImportShim(final File baseDir, String baseUrl) {
        this.baseUrl = new KUrl(baseUrl);
        this.locator = new ResourceLocator(){

            @Override
            public File locateResource(String urlPath) {
                return new File(baseDir + "/" + urlPath);
            }
        };
    }

    public HtmlImportShim inline(boolean inline) {
        this.inline = inline;
        return this;
    }

    public HtmlImportShim(String baseUrl) {
        this.baseUrl = new KUrl(baseUrl);
    }

    public File locateResource(KUrl urlPath) {
        File file = this.locator.locateResource(this.baseUrl.concat(urlPath).toUrlString());
        if (file == null || !file.exists()) {
            Log.Warn((Object)this, (String)("failed to resolve '" + urlPath + "'"));
        }
        return file;
    }

    public void setLocator(DependencyResolver locator) {
        this.locator = locator;
    }

    public Element shimImports(String htmlFile) throws IOException {
        return this.shimImports(new KUrl(htmlFile), new HashSet<KUrl>(), null);
    }

    protected KUrl computeAssetPath(KUrl containingFileUrl, String href) {
        return containingFileUrl.getParentURL().concat(href);
    }

    public Element shimImports(KUrl containingFileUrl, HashSet<KUrl> visited, List<List<Node>> bodyContent) throws IOException {
        boolean isTop = false;
        if (bodyContent == null) {
            isTop = true;
            bodyContent = new ArrayList<List<Node>>();
        }
        if (visited.contains(containingFileUrl)) {
            return null;
        }
        visited.add(containingFileUrl);
        String compName = containingFileUrl.getFileNameNoExtension();
        File fi = this.locateResource(containingFileUrl);
        if (fi == null) {
            System.out.println("cannot locate " + containingFileUrl);
            return null;
        }
        Document doc = Jsoup.parse((File)fi, (String)"UTF-8", (String)this.baseUrl.toUrlString());
        Elements scripts = null;
        if (isTop) {
            scripts = doc.getElementsByTag("script");
        }
        if (this.stripComments) {
            this.stripComments(doc);
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        Elements links = doc.getElementsByTag("link");
        for (int i = 0; i < links.size(); ++i) {
            Element link = (Element)links.get(i);
            this.shimLink(containingFileUrl, visited, bodyContent, changes, link);
        }
        changes.forEach(change -> change.run());
        changes.clear();
        if (this.inline) {
            Elements resourcLinks = doc.getElementsByAttribute("src");
            for (int i = 0; i < resourcLinks.size(); ++i) {
                KUrl linkUrl;
                Element element = (Element)resourcLinks.get(i);
                if (!element.tagName().equals("img") && !element.tagName().equals("embed") && !element.tagName().equals("iframe") || !(linkUrl = new KUrl(element.attr("src"))).isRelative()) continue;
                linkUrl = linkUrl.prepend(containingFileUrl.getParentURL().getName());
                element.attr("src", linkUrl.toUrlString());
            }
        }
        if (isTop) {
            Element body = doc.getElementsByTag("body").first();
            Element div = new Element(Tag.valueOf((String)"div"), "");
            div.attr("hidden", "");
            div.attr("by-vulcanize", "");
            div.attr("not-really", "");
            for (int i = bodyContent.size() - 1; i >= 0; --i) {
                List<Node> children = bodyContent.get(i);
                div.insertChildren(0, children);
            }
            ArrayList<Element> children = new ArrayList<Element>();
            children.add(div);
            body.insertChildren(0, children);
            if (this.inline && scripts != null) {
                this.inlineScripts(containingFileUrl, visited, changes, scripts);
                changes.forEach(change -> change.run());
                changes.clear();
            }
        }
        return doc;
    }

    public void shimLink(KUrl containingFileUrl, HashSet<KUrl> visited, List<List<Node>> bodyContent, List<Runnable> changes, Element link) throws IOException {
        block14: {
            String href2;
            String rel = link.attr("rel");
            String type = link.attr("type");
            String ignore = link.attr("no-inline");
            if (ignore != "") {
                return;
            }
            if ("import".equals(rel) && (type == null || type.length() == 0)) {
                href2 = link.attr("href");
                type = href2 == null || href2.length() == 0 ? "" : href2.substring(href2.lastIndexOf(46) + 1);
            }
            if (link.attr("href").indexOf("skeleton") >= 0) {
                boolean href2 = true;
            }
            if (this.inline && type.indexOf("html") >= 0 && "import".equals(rel)) {
                href2 = link.attr("href");
                String noinline = link.attr("no-inline");
                if (noinline == "" && !href2.startsWith("http")) {
                    try {
                        KUrl impUrl = containingFileUrl.getParentURL().concat(href2);
                        Element imp = this.shimImports(impUrl, visited, bodyContent);
                        if (imp instanceof Document) {
                            KUrl assetPath = this.computeAssetPath(containingFileUrl, href2);
                            imp.getElementsByTag("dom-module").forEach(module -> module.attr("assetpath", this.baseUrl.concat(assetPath).toUrlString()));
                            imp.getElementsByTag("head").forEach(node -> {
                                ArrayList children = new ArrayList(node.children());
                                changes.add(() -> {
                                    Integer integer = link.siblingIndex();
                                    link.parent().insertChildren(integer.intValue(), (Collection)children);
                                });
                            });
                            this.inlineScripts(impUrl, visited, changes, imp);
                            List<List<Node>> finalBodyContent = bodyContent;
                            changes.add(() -> imp.getElementsByTag("body").forEach(node -> finalBodyContent.add(new ArrayList(node.children()))));
                            changes.add(() -> link.remove());
                            break block14;
                        }
                        if (imp == null) {
                            changes.add(() -> link.remove());
                            break block14;
                        }
                        Element finalImp = imp;
                        changes.add(() -> link.replaceWith((Node)finalImp));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.inline && ("stylesheet".equals(type) || "css".equals(type) || rel.equals("stylesheet"))) {
                KUrl resUrl;
                File impFi;
                href2 = link.attr("href");
                String noinline = link.attr("no-inline");
                if (noinline == "" && href2 != null && !href2.startsWith("http") && (impFi = this.locateResource(resUrl = containingFileUrl.getParentURL().concat(href2))) != null && impFi.exists()) {
                    if (visited.contains(resUrl)) {
                        link.remove();
                    } else {
                        visited.add(resUrl);
                        Element style = new Element(Tag.valueOf((String)"style"), "");
                        byte[] bytes = Files.readAllBytes(impFi.toPath());
                        style.appendChild((Node)new DataNode(new String(bytes, "UTF-8"), ""));
                        link.replaceWith((Node)style);
                    }
                }
            }
        }
    }

    public void inlineScripts(KUrl containingFileUrl, HashSet<KUrl> visited, List<Runnable> changes, Element doc) throws IOException {
        if (this.inline) {
            Elements scripts = doc.getElementsByTag("script");
            this.inlineScripts(containingFileUrl, visited, changes, scripts);
        }
    }

    public void inlineScripts(KUrl containingFileUrl, HashSet<KUrl> visited, List<Runnable> changes, Elements scripts) throws IOException {
        if (this.inline) {
            for (int i = 0; i < scripts.size(); ++i) {
                Element script = (Element)scripts.get(i);
                String href = script.attr("src");
                boolean ignore = script.hasAttr("no-inline");
                if (ignore) continue;
                if (href != null && href.length() > 0) {
                    KUrl url;
                    File impFi;
                    if (href.startsWith("http") || (impFi = this.locateResource(url = containingFileUrl.getParentURL().concat(href))) == null || !impFi.exists()) continue;
                    if (visited.contains(url)) {
                        changes.add(() -> script.remove());
                        continue;
                    }
                    Log.Info((Object)this, (String)("inlining script " + href));
                    visited.add(url);
                    Element newScript = new Element(Tag.valueOf((String)"script"), "");
                    byte[] bytes = Files.readAllBytes(impFi.toPath());
                    if (this.minify && url.getExtension().equals("js")) {
                        bytes = JSMin.minify(bytes);
                    }
                    String scriptSource = new String(bytes, "UTF-8");
                    newScript.appendChild((Node)new DataNode(scriptSource, ""));
                    newScript.attr("no-inline", "true");
                    changes.add(() -> script.replaceWith((Node)newScript));
                    continue;
                }
                if (!this.minify || script.hasAttr("no-inline")) continue;
                String minified = new String(JSMin.minify(script.html().getBytes("UTF-8")), "UTF-8");
                Element newScript = new Element(Tag.valueOf((String)"script"), "");
                newScript.appendChild((Node)new DataNode(minified, ""));
                newScript.attr("no-inline", "true");
                changes.add(() -> script.replaceWith((Node)newScript));
            }
        }
    }

    public void stripComments(Document doc) {
        ArrayList comments = new ArrayList();
        doc.getAllElements().forEach(elem -> {
            if (!elem.tagName().equals("style") && !elem.equals((Object)"script")) {
                elem.childNodes().forEach(child -> {
                    if (child instanceof Comment) {
                        comments.add(child);
                    }
                });
            }
        });
        comments.forEach(node -> node.remove());
    }

    public KUrl getBaseUrl() {
        return this.baseUrl;
    }

    public HtmlImportShim stripComments(boolean stripComments) {
        this.stripComments = stripComments;
        return this;
    }

    public HtmlImportShim minify(boolean minify) {
        this.minify = minify;
        return this;
    }

    public static void main(String[] args) throws IOException {
        File file = new File("/home/ruedi/projects/polystrene/bower_components/paper-slider/paper-slider.html");
        File baseDir = new File("/home/ruedi/projects/polystrene/bower_components/");
        HtmlImportShim shim = new HtmlImportShim(baseDir, "");
        Element element = shim.shimImports(new KUrl("paper-slider/paper-slider.html"), new HashSet<KUrl>(), null);
        System.out.println(element);
    }

    public static interface ResourceLocator {
        public File locateResource(String var1);
    }
}

