/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript;

import java.util.ArrayList;
import java.util.Objects;

public class KUrl {
    String protocol;
    String[] elements;

    public static String stripDoubleSeps(String url) {
        while (url.indexOf("//") > 0) {
            url = url.replace("//", "/");
        }
        return url;
    }

    public KUrl(String url) {
        int idx = url.indexOf("://");
        if (idx >= 0) {
            this.protocol = url.substring(0, idx);
            url.substring(idx + 3);
        }
        url = KUrl.stripDoubleSeps(url);
        this.elements = url.split("/");
        this.normalize();
    }

    public KUrl(String protocol, String[] elements) {
        this.protocol = protocol;
        this.elements = elements;
    }

    public KUrl(String[] elements) {
        this.elements = elements;
    }

    protected void normalize() {
        ArrayList<String> newElemns = new ArrayList<String>();
        for (int i = 0; i < this.elements.length; ++i) {
            String element = this.elements[i].trim();
            if (element.length() <= 0 || element.equals(".")) continue;
            if (element.equals("..") && newElemns.size() > 0 && !"..".equals(newElemns.get(newElemns.size() - 1))) {
                newElemns.remove(newElemns.size() - 1);
                continue;
            }
            newElemns.add(element);
        }
        this.elements = new String[newElemns.size()];
        newElemns.toArray(this.elements);
    }

    public KUrl concat(String url) {
        return this.concat(new KUrl(url));
    }

    public KUrl concat(KUrl url) {
        String[] elems = url.getElements();
        String[] newElems = new String[elems.length + this.elements.length];
        System.arraycopy(this.elements, 0, newElems, 0, this.elements.length);
        System.arraycopy(elems, 0, newElems, this.elements.length, elems.length);
        KUrl res = new KUrl(this.protocol, newElems);
        res.normalize();
        return res;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String[] getElements() {
        return this.elements;
    }

    public String getExtension() {
        String name = this.getName();
        int idx = name.lastIndexOf(".");
        if (idx >= 0) {
            return name.substring(idx + 1);
        }
        return "";
    }

    public String getFileNameNoExtension() {
        String name = this.getName();
        int idx = name.lastIndexOf(".");
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public String toUrlString() {
        String res = "";
        if (this.protocol != null) {
            res = res + this.protocol + "://";
        }
        for (int i = 0; i < this.elements.length; ++i) {
            String element = this.elements[i];
            res = res + element;
            if (i >= this.elements.length - 1) continue;
            res = res + "/";
        }
        return res;
    }

    public KUrl getParentURL() {
        return this.concat("../");
    }

    public String getName() {
        if (this.elements.length == 0) {
            return "";
        }
        return this.elements[this.elements.length - 1];
    }

    public boolean equals(Object obj) {
        if (obj instanceof KUrl) {
            KUrl other = (KUrl)obj;
            if (other.getElements().length != this.elements.length) {
                return false;
            }
            if (!Objects.equals(other.getProtocol(), this.protocol)) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                String element = this.elements[i];
                if (element.equals(other.getElements()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            String element = this.elements[i];
            hc ^= element.hashCode();
        }
        if (this.protocol != null) {
            hc ^= this.protocol.hashCode();
        }
        return hc;
    }

    public String toString() {
        return this.toUrlString();
    }

    public static void main(String[] args) {
        KUrl url = new KUrl("///test/one/../two/three");
        System.out.println(url.toUrlString());
        System.out.println(url.concat("../../bla").toUrlString());
    }

    public boolean isRelative() {
        return this.protocol == null;
    }

    public KUrl prepend(String name) {
        return new KUrl(name).concat(this);
    }
}

