/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.websockets;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.websockets.WebObjectSocket;
import org.nustaq.kontraktor.util.Log;

public class _JSR356ServerConnector
extends Endpoint
implements ActorServerConnector {
    Actor facade;
    Function<ObjectSocket, ObjectSink> factory;

    public static IPromise<ActorServer> Publish(Actor facade, String path, Coding coding) {
        _JSR356ServerConnector connector = new _JSR356ServerConnector();
        try {
            ActorServer actorServer = new ActorServer((ActorServerConnector)connector, facade, coding);
            actorServer.start();
            ContainerProvider.getWebSocketContainer().connectToServer((Object)connector, new URI(path));
            return new Promise((Object)actorServer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Promise(null, (Object)e);
        }
    }

    public void connect(Actor facade, Function<ObjectSocket, ObjectSink> factory) throws Exception {
        this.facade = facade;
        this.factory = factory;
    }

    public IPromise closeServer() {
        return new Promise(null, (Object)"unable to close from here, must stop hosting server instead");
    }

    public void onOpen(Session session, EndpointConfig config) {
        MySocket objectsocket = new MySocket(session);
        final ObjectSink sink = this.factory.apply(objectsocket);
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<byte[]>(){

            public void onMessage(byte[] msg) {
                sink.receiveObject((Object)msg, null);
            }
        });
    }

    static class DefaultClientEndpointConfig
    implements ClientEndpointConfig {
        DefaultClientEndpointConfig() {
        }

        public List<Class<? extends Encoder>> getEncoders() {
            return Collections.emptyList();
        }

        public List<Class<? extends Decoder>> getDecoders() {
            return Collections.emptyList();
        }

        public Map<String, Object> getUserProperties() {
            return Collections.emptyMap();
        }

        public List<String> getPreferredSubprotocols() {
            return Collections.emptyList();
        }

        public List<Extension> getExtensions() {
            return Collections.emptyList();
        }

        public ClientEndpointConfig.Configurator getConfigurator() {
            return new ClientEndpointConfig.Configurator();
        }
    }

    static class MySocket
    extends WebObjectSocket {
        Session session;

        public MySocket(Session session) {
            this.session = session;
        }

        @Override
        public void sendBinary(byte[] message) {
            try {
                this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(message));
            }
            catch (IOException ex) {
                Log.Warn((Object)this, (Throwable)ex);
                try {
                    this.close();
                }
                catch (IOException e) {
                    Log.Warn((Object)this, (Throwable)ex);
                }
            }
        }

        public void close() throws IOException {
            this.session.close();
        }
    }
}

