/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.builder;

import io.undertow.server.HttpHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.remoting.http.Http4K;
import org.nustaq.kontraktor.remoting.http.HttpPublisher;
import org.nustaq.kontraktor.remoting.http.builder.BldDirRoot;
import org.nustaq.kontraktor.remoting.http.builder.BldHttpHandler;
import org.nustaq.kontraktor.remoting.http.builder.BldResPath;
import org.nustaq.kontraktor.remoting.http.javascript.CachedFileResourceManager;
import org.nustaq.kontraktor.remoting.http.javascript.DynamicResourceManager;
import org.nustaq.kontraktor.remoting.http.javascript.HtmlImportShim;
import org.nustaq.kontraktor.remoting.websockets.WebSocketPublisher;

public class BldFourK {
    String hostName;
    int port;
    SSLContext context;
    boolean httpCachedEnabled = false;
    List items = new ArrayList();

    public BldFourK(String hostName, int port, SSLContext context) {
        this.hostName = hostName;
        this.port = port;
        this.context = context;
    }

    public BldFourK fileRoot(String urlPath, String dir) {
        BldDirRoot rt = new BldDirRoot(urlPath, dir);
        this.items.add(rt);
        return this;
    }

    public BldFourK httpCachedEnabled(boolean b) {
        this.httpCachedEnabled = b;
        return this;
    }

    public BldFourK fileRoot(String urlPath, File dir) {
        BldDirRoot rt = new BldDirRoot(urlPath, dir.getAbsolutePath());
        this.items.add(rt);
        return this;
    }

    public BldResPath resourcePath(String urlPath) {
        BldResPath rt = new BldResPath(this, urlPath);
        this.items.add(rt);
        return rt;
    }

    public WebSocketPublisher websocket(String urlPath, Actor facade) {
        return this.websocket(urlPath, facade, false);
    }

    public WebSocketPublisher websocket(String urlPath, Actor facade, boolean useStringMessages) {
        WebSocketPublisher wp = new WebSocketPublisher(this, facade, this.hostName, urlPath, this.port);
        wp.sendStringMessages(useStringMessages);
        this.items.add(wp);
        return wp;
    }

    public BldFourK httpHandler(String urlPath, HttpHandler handler) {
        this.items.add(new BldHttpHandler(urlPath, handler));
        return this;
    }

    public HttpPublisher httpAPI(String urlPath, Actor facade) {
        HttpPublisher hp = new HttpPublisher(this, facade, this.hostName, urlPath, this.port);
        this.items.add(hp);
        return hp;
    }

    public boolean getHttpCacheEnabled() {
        return this.httpCachedEnabled;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public SSLContext getContext() {
        return this.context;
    }

    public List getItems() {
        return this.items;
    }

    public BldFourK build() {
        Http4K http4K = Http4K.get();
        http4K.getServer(this.getPort(), this.getHostName(), this.context);
        this.getItems().forEach(item -> {
            if (item instanceof HttpPublisher) {
                http4K.publish((HttpPublisher)item);
            } else if (item instanceof WebSocketPublisher) {
                http4K.publish((WebSocketPublisher)item);
            } else if (item instanceof BldDirRoot) {
                BldDirRoot dr = (BldDirRoot)item;
                CachedFileResourceManager resMan = new CachedFileResourceManager(this.getHttpCacheEnabled(), new File(dr.getDir()), 100L);
                http4K.publishFileSystem(this.getHostName(), dr.getUrlPath(), this.getPort(), resMan);
            } else if (item instanceof BldHttpHandler) {
                BldHttpHandler dr = (BldHttpHandler)item;
                http4K.publishHandler(this.getHostName(), dr.getUrlPath(), this.getPort(), dr.getHandler());
            } else if (item instanceof BldResPath) {
                BldResPath dr = (BldResPath)item;
                DynamicResourceManager drm = new DynamicResourceManager(!dr.isCacheAggregates(), dr.getUrlPath(), dr.isMinify(), dr.getBaseDir(), dr.getResourcePath());
                HtmlImportShim shim = new HtmlImportShim(dr.getUrlPath());
                shim.minify(dr.isMinify()).inline(dr.isInline()).stripComments(dr.isStripComments());
                drm.setImportShim(shim);
                http4K.publishResourcePath(this.getHostName(), dr.getUrlPath(), this.getPort(), drm, dr.isCompress());
            } else {
                System.out.println("unexpected item " + item);
            }
        });
        return this;
    }
}

