/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript.jsmin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class JSMin {
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final String customHeader;
    public static final int EOF = -1;
    private int theA;
    private int theB;
    private int theLookahead = -1;
    private int theX = -1;
    private int theY = -1;

    private JSMin(Builder builder) {
        this.inputStream = builder.inputStream();
        this.outputStream = builder.outputStream();
        this.customHeader = builder.customHeader();
    }

    public static byte[] minify(byte[] bytes) {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(bytes.length);
        JSMin.builder().inputStream(bin).outputStream(bout).build().minify();
        return bout.toByteArray();
    }

    public void minify() {
        try {
            this.writeCustomHeader();
            this.jsmin();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.outputStream.flush();
            }
            catch (IOException iOException) {}
        }
    }

    protected void writeCustomHeader() throws IOException {
    }

    private void jsmin() throws IOException {
        if (this.peek() == 239) {
            this.get();
            this.get();
            this.get();
        }
        this.theA = 10;
        this.action(3);
        block15: while (this.theA != -1) {
            switch (this.theA) {
                case 32: {
                    this.action(this.isAlphanum(this.theB) ? 1 : 2);
                    continue block15;
                }
                case 10: {
                    switch (this.theB) {
                        case 33: 
                        case 40: 
                        case 43: 
                        case 45: 
                        case 91: 
                        case 123: 
                        case 126: {
                            this.action(1);
                            continue block15;
                        }
                        case 32: {
                            this.action(3);
                            continue block15;
                        }
                    }
                    this.action(this.isAlphanum(this.theB) ? 1 : 2);
                    continue block15;
                }
            }
            switch (this.theB) {
                case 32: {
                    this.action(this.isAlphanum(this.theA) ? 1 : 3);
                    continue block15;
                }
                case 10: {
                    switch (this.theA) {
                        case 34: 
                        case 39: 
                        case 41: 
                        case 43: 
                        case 45: 
                        case 93: 
                        case 96: 
                        case 125: {
                            this.action(1);
                            continue block15;
                        }
                    }
                    this.action(this.isAlphanum(this.theA) ? 1 : 3);
                    continue block15;
                }
            }
            this.action(1);
        }
    }

    private int get() throws IOException {
        int c = this.theLookahead;
        this.theLookahead = -1;
        if (c == -1) {
            c = this.inputStream.read();
        }
        if (c >= 32 || c == 10 || c == -1) {
            return c;
        }
        if (c == 13) {
            return 10;
        }
        return 32;
    }

    private int peek() throws IOException {
        this.theLookahead = this.get();
        return this.theLookahead;
    }

    private int next() throws IOException {
        int c = this.get();
        if (c == 47) {
            switch (this.peek()) {
                case 47: {
                    while ((c = this.get()) > 10) {
                    }
                    break;
                }
                case 42: {
                    this.get();
                    while (c != 32) {
                        switch (this.get()) {
                            case 42: {
                                if (this.peek() != 47) break;
                                this.get();
                                c = 32;
                                break;
                            }
                            case -1: {
                                this.error("Unterminated comment.");
                            }
                        }
                    }
                    break;
                }
            }
        }
        this.theY = this.theX;
        this.theX = c;
        return c;
    }

    private void action(int d) throws IOException {
        switch (d) {
            case 1: {
                this.outputStream.write(this.theA);
                if (!(this.theY != 10 && this.theY != 32 || this.theA != 43 && this.theA != 45 && this.theA != 42 && this.theA != 47 || this.theB != 43 && this.theB != 45 && this.theB != 42 && this.theB != 47)) {
                    this.outputStream.write(this.theY);
                }
            }
            case 2: {
                this.theA = this.theB;
                if (this.theA == 39 || this.theA == 34 || this.theA == 96) {
                    while (true) {
                        this.outputStream.write(this.theA);
                        this.theA = this.get();
                        if (this.theA == this.theB) break;
                        if (this.theA == 92) {
                            this.outputStream.write(this.theA);
                            this.theA = this.get();
                        }
                        if (this.theA != -1) continue;
                        this.error("Unterminated string literal.");
                    }
                }
            }
            case 3: {
                this.theB = this.next();
                if (this.theB != 47 || this.theA != 40 && this.theA != 44 && this.theA != 61 && this.theA != 58 && this.theA != 91 && this.theA != 33 && this.theA != 38 && this.theA != 124 && this.theA != 63 && this.theA != 43 && this.theA != 45 && this.theA != 126 && this.theA != 42 && this.theA != 47 && this.theA != 10) break;
                this.outputStream.write(this.theA);
                if (this.theA == 47 || this.theA == 42) {
                    this.outputStream.write(32);
                }
                this.outputStream.write(this.theB);
                while (true) {
                    this.theA = this.get();
                    if (this.theA == 91) {
                        while (true) {
                            this.outputStream.write(this.theA);
                            this.theA = this.get();
                            if (this.theA != 93) {
                                if (this.theA == 92) {
                                    this.outputStream.write(this.theA);
                                    this.theA = this.get();
                                }
                                if (this.theA != -1) continue;
                                this.error("Unterminated set in Regular Expression literal.");
                                continue;
                            }
                            break;
                        }
                    } else {
                        if (this.theA == 47) {
                            switch (this.peek()) {
                                case 42: 
                                case 47: {
                                    this.error("Unterminated set in Regular Expression literal.");
                                }
                            }
                            break;
                        }
                        if (this.theA == 92) {
                            this.outputStream.write(this.theA);
                            this.theA = this.get();
                        }
                    }
                    if (this.theA == -1) {
                        this.error("Unterminated Regular Expression literal.");
                    }
                    this.outputStream.write(this.theA);
                }
                this.theB = this.next();
            }
        }
    }

    private void error(String s) {
        System.err.println("JSMin Error: " + s);
        throw new JsMinException(s);
    }

    private boolean isAlphanum(int c) {
        return c >= 97 && c <= 122 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c == 36 || c == 92 || c > 126;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) {
        JSMin.builder().build().minify();
    }

    public static final class Builder {
        private InputStream inputStream = System.in;
        private OutputStream outputStream = System.out;
        private String customHeader = "";
        private Charset charset = Charset.forName("UTF-8");

        public InputStream inputStream() {
            return this.inputStream;
        }

        public OutputStream outputStream() {
            return this.outputStream;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder outputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public String customHeader() {
            return this.customHeader;
        }

        public Builder customHeader(String customHeader) {
            this.customHeader = customHeader;
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public JSMin build() {
            return new JSMin(this);
        }
    }

    static final class JsMinException
    extends RuntimeException {
        private JsMinException(String message) {
            super(message);
        }
    }
}

