/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.servlet;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.servlet.ServletActorConnector;
import org.nustaq.kontraktor.util.Log;

@WebServlet(name="KontraktorServler", urlPatterns={"/ep/*"}, asyncSupported=true)
public abstract class KontraktorServlet
extends HttpServlet {
    protected Actor facade;
    protected ServletActorConnector connector;

    public void init(ServletConfig config) throws ServletException {
        this.createAndInitFacadeApp(config);
        this.createAndInitConnector();
        super.init(config);
    }

    protected void createAndInitConnector() {
        this.connector = new ServletActorConnector(this.facade, this, new Coding(SerializerType.JsonNoRef), fail -> this.handleDisconnect((Actor)fail));
    }

    protected void handleDisconnect(Actor fail) {
        Log.Warn((Object)((Object)this), (String)"");
    }

    protected abstract void createAndInitFacadeApp(ServletConfig var1);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream out = resp.getOutputStream();
        out.write("hello kontraktor".getBytes());
        out.flush();
        out.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final AsyncContext aCtx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ServletRequest contextRequest = aCtx.getRequest();
        final ServletInputStream inputStream = contextRequest.getInputStream();
        inputStream.setReadListener(new ReadListener(){
            byte[] buffer;
            int index = 0;

            public void onDataAvailable() throws IOException {
                int c;
                if (this.buffer == null) {
                    int available = aCtx.getRequest().getContentLength();
                    this.buffer = new byte[available];
                }
                while (inputStream.isReady() && (c = inputStream.read()) != -1) {
                    this.buffer[this.index++] = (byte)c;
                }
                if (this.index == this.buffer.length) {
                    KontraktorServlet.this.facade.execute(() -> KontraktorServlet.this.connector.requestReceived(aCtx, this.buffer));
                }
            }

            public void onAllDataRead() throws IOException {
            }

            public void onError(Throwable throwable) {
                Log.Error((Object)((Object)KontraktorServlet.this), (Throwable)throwable);
            }
        });
    }
}

