/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.javascript;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.nodes.Element;
import org.nustaq.kontraktor.remoting.http.javascript.DependencyResolver;
import org.nustaq.kontraktor.remoting.http.javascript.HtmlImportShim;
import org.nustaq.kontraktor.remoting.http.javascript.TranspilerHook;
import org.nustaq.kontraktor.remoting.http.javascript.jsmin.JSMin;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.serialization.util.FSTUtil;

public class DynamicResourceManager
extends FileResourceManager {
    boolean devMode = false;
    DependencyResolver dependencyResolver;
    HtmlImportShim importShim;
    String prefix = "";
    Date lastStartup;
    ConcurrentHashMap<String, Resource> lookupCache = new ConcurrentHashMap();
    boolean minify;
    private Map<String, TranspilerHook> transpilerMap;

    public DynamicResourceManager(boolean devMode, String prefix, boolean minify, String resPathBase, String ... resourcePath) {
        super(new File("."), 100L);
        this.devMode = devMode;
        this.minify = minify;
        this.lastStartup = new Date();
        this.setPrefix(prefix);
        this.dependencyResolver = new DependencyResolver(resPathBase, resourcePath);
        if (devMode) {
            Log.Warn((Object)((Object)this), (String)"Dependency resolving is running in *DEVELOPMENT MODE*. Turn off development mode to cache aggregated resources");
        } else {
            Log.Info((Object)((Object)this), (String)"Dependency resolving is running in *PRODUCTION MODE*. Turn on development mode for script-refresh-on-reload and per file javascript debugging");
        }
    }

    public void setImportShim(HtmlImportShim shim) {
        shim.setLocator(this.dependencyResolver);
        this.importShim = shim;
    }

    public void setPrefix(String prefix) {
        while (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        this.prefix = prefix;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public Resource getResource(String initialPath) {
        String normalizedPath = initialPath.startsWith("/") ? initialPath.substring(1) : initialPath;
        if (!this.isDevMode()) {
            if (normalizedPath.startsWith("f5_")) {
                this.lookupCache.clear();
                return super.getResource(initialPath);
            }
            Resource res = this.lookupCache.get(normalizedPath);
            if (res != null) {
                return res;
            }
        }
        if (initialPath.endsWith("index.html") && this.importShim != null) {
            try {
                Element element = this.importShim.shimImports(normalizedPath);
                if (element == null) {
                    return super.getResource(initialPath);
                }
                byte[] bytes = element.toString().getBytes("UTF-8");
                return this.mightCache(normalizedPath, new MyResource(initialPath, normalizedPath, bytes, "text/html", !this.isDevMode() ? this.lastStartup : null));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            File file = this.dependencyResolver.locateResource(normalizedPath);
            if (file != null) {
                String fname = file.getName();
                if (fname.endsWith(".js") && this.minify) {
                    try {
                        byte[] bytes = Files.readAllBytes(file.toPath());
                        bytes = JSMin.minify(bytes);
                        return this.mightCache(normalizedPath, new MyResource(initialPath, normalizedPath, bytes, "text/javascript", !this.isDevMode() ? this.lastStartup : null));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.transpilerMap != null && this.transpilerMap.size() > 0) {
                    try {
                        String ext;
                        TranspilerHook transpilerHook;
                        int idx = fname.lastIndexOf(46);
                        if (idx > 0 && (transpilerHook = this.transpilerMap.get(ext = fname.substring(idx + 1).toLowerCase())) != null) {
                            byte[] transpiled = transpilerHook.transpile(file);
                            if (this.minify) {
                                transpiled = JSMin.minify(transpiled);
                            }
                            if (transpiled != null) {
                                return this.mightCache(normalizedPath, new MyResource(initialPath, normalizedPath, transpiled, "text/javascript", !this.isDevMode() ? this.lastStartup : null));
                            }
                        }
                    }
                    catch (Exception ex) {
                        Log.Error((Object)((Object)this), (Throwable)ex);
                    }
                }
                try {
                    return this.mightCache(normalizedPath, (Resource)this.getFileResource(file, initialPath));
                }
                catch (IOException e) {
                    FSTUtil.rethrow((Throwable)e);
                }
            }
        }
        return super.getResource(initialPath);
    }

    protected FileResource getFileResource(File file, String path) throws IOException {
        if (this._isFileSameCase(file)) {
            return new FileResource(file, this, path){

                public Date getLastModified() {
                    if (DynamicResourceManager.this.isDevMode()) {
                        return new Date();
                    }
                    if (DynamicResourceManager.this.lastStartup == null) {
                        DynamicResourceManager.this.lastStartup = new Date();
                    }
                    return DynamicResourceManager.this.lastStartup;
                }
            };
        }
        return null;
    }

    private boolean _isFileSameCase(File file) throws IOException {
        String canonicalName = file.getCanonicalFile().getName();
        if (canonicalName.equals(file.getName())) {
            return true;
        }
        return !canonicalName.equalsIgnoreCase(file.getName());
    }

    private Resource mightCache(String key, Resource fileResource) {
        if (!this.isDevMode()) {
            this.lookupCache.put(key, fileResource);
        }
        return fileResource;
    }

    public void setTranspilerMap(Map<String, TranspilerHook> transpilerMap) {
        this.transpilerMap = transpilerMap;
    }

    public Map<String, TranspilerHook> getTranspilerMap() {
        return this.transpilerMap;
    }

    protected static class MyResource
    implements Resource {
        protected String p0;
        protected String finalP;
        protected byte[] bytes;
        protected String resType;
        protected Date lastModified;

        public MyResource(String p0, String finalP, byte[] bytes, String resType, Date lastStartup) {
            this.p0 = p0;
            this.finalP = finalP;
            this.bytes = bytes;
            this.resType = resType;
            this.lastModified = lastStartup;
        }

        public String getPath() {
            return this.p0;
        }

        public Date getLastModified() {
            return this.lastModified == null ? new Date() : this.lastModified;
        }

        public String getLastModifiedString() {
            return DateUtils.toDateString((Date)this.getLastModified());
        }

        public ETag getETag() {
            return null;
        }

        public String getName() {
            return this.finalP;
        }

        public boolean isDirectory() {
            return false;
        }

        public List<Resource> list() {
            return null;
        }

        public String getContentType(MimeMappings mimeMappings) {
            return this.resType;
        }

        public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
            exchange.startBlocking();
            try {
                exchange.getOutputStream().write(this.bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public Long getContentLength() {
            return this.bytes.length;
        }

        public String getCacheKey() {
            return null;
        }

        public File getFile() {
            return null;
        }

        public File getResourceManagerRoot() {
            return null;
        }

        public URL getUrl() {
            return null;
        }
    }
}

