/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.servlet;

import io.undertow.server.handlers.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.servlet.ServletActorConnector;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldResPath;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.javascript.DynamicResourceManager;
import org.nustaq.kontraktor.webapp.javascript.HtmlImportShim;
import org.nustaq.kontraktor.webapp.transpiler.JSXIntrinsicTranspiler;

public abstract class KontraktorServlet
extends HttpServlet {
    protected Actor facade;
    protected ServletActorConnector connector;
    protected DynamicResourceManager dynamicResourceManager;
    protected String realRoot;
    protected long deployTime = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.realRoot = this.findAppRoot();
        this.facade = this.createAndInitFacadeApp(config);
        this.connector = this.createAndInitConnector();
        this.dynamicResourceManager = this.createDependencyResolver(this.getResourcePathConfig());
    }

    protected String[] getResourcePathElementsAbsolute() {
        String[] rpe = this.getResourcePathElements();
        String[] res = new String[rpe.length];
        for (int i = 0; i < rpe.length; ++i) {
            res[i] = this.realRoot + File.separator + rpe[i];
        }
        return res;
    }

    protected String findAppRoot() {
        String realPath = this.getServletContext().getRealPath("/");
        return realPath;
    }

    protected long getLastModified(HttpServletRequest req) {
        if (this.isDevMode()) {
            return super.getLastModified(req);
        }
        return this.deployTime;
    }

    protected BldResPath getResourcePathConfig() {
        return new BldResPath(null, "/").elements(this.getResourcePathElementsAbsolute()).transpile("jsx", new JSXIntrinsicTranspiler(this.isDevMode(), !this.isDevMode())).allDev(this.isDevMode());
    }

    protected boolean isDevMode() {
        return true;
    }

    protected String[] getResourcePathElements() {
        return new String[]{"src/main/webapp/client/", "src/main/webapp/lib/"};
    }

    protected DynamicResourceManager createDependencyResolver(BldResPath dr) {
        DynamicResourceManager drm = new DynamicResourceManager(new File(this.realRoot), !dr.isCacheAggregates(), dr.getUrlPath(), dr.isMinify(), dr.getBaseDir(), dr.getResourcePath());
        HtmlImportShim shim = new HtmlImportShim(dr.getUrlPath());
        shim.minify(dr.isMinify()).inline(dr.isInline()).stripComments(dr.isStripComments());
        drm.setImportShim(shim);
        drm.setTranspilerMap(dr.getTranspilers());
        return drm;
    }

    protected String getApiPath() {
        return "/api";
    }

    protected ServletActorConnector createAndInitConnector() {
        if (this.facade != null) {
            return new ServletActorConnector(this.facade, this, new Coding(SerializerType.JsonNoRef), fail -> this.handleDisconnect((Actor)fail));
        }
        return null;
    }

    protected void handleDisconnect(Actor fail) {
        Log.Warn((Object)((Object)this), (String)"");
    }

    protected abstract Actor createAndInitFacadeApp(ServletConfig var1);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            String dbg = req.getRequestURI();
            resp.sendRedirect(dbg + "/");
            return;
        }
        Resource resource = null;
        resource = "".equals(pathInfo) || "/".equals(pathInfo) ? this.dynamicResourceManager.getResource(pathInfo + "index.html") : this.dynamicResourceManager.getResource(pathInfo);
        if (resource != null) {
            Long contentLength = resource.getContentLength();
            if (contentLength != null) {
                resp.setContentLength((int)contentLength.longValue());
            }
            byte[] bytes = null;
            if (resource instanceof DynamicResourceManager.MyResource) {
                bytes = ((DynamicResourceManager.MyResource)resource).getBytes();
            } else if (resource.getFile() != null) {
                bytes = Files.readAllBytes(resource.getFile().toPath());
            }
            if (bytes != null) {
                ServletOutputStream out = resp.getOutputStream();
                out.write(bytes);
                out.flush();
                out.close();
                return;
            }
        }
        Log.Error((Object)((Object)this), (String)"Unhandled resource");
        this.unhandledGet(req, resp);
    }

    protected void unhandledGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.facade == null) {
            this.nonAPIPost(req, resp);
            return;
        }
        String pathInfo = req.getPathInfo();
        if (!pathInfo.startsWith(this.getApiPath() + "/") && !pathInfo.equals(this.getApiPath())) {
            this.nonAPIPost(req, resp);
            return;
        }
        final AsyncContext aCtx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ServletRequest contextRequest = aCtx.getRequest();
        final ServletInputStream inputStream = contextRequest.getInputStream();
        inputStream.setReadListener(new ReadListener(){
            byte[] buffer;
            int index = 0;

            public void onDataAvailable() throws IOException {
                int c;
                if (this.buffer == null) {
                    int available = aCtx.getRequest().getContentLength();
                    this.buffer = new byte[available];
                }
                while (inputStream.isReady() && (c = inputStream.read()) != -1) {
                    this.buffer[this.index++] = (byte)c;
                }
                if (this.index == this.buffer.length) {
                    KontraktorServlet.this.facade.execute(() -> KontraktorServlet.this.connector.requestReceived(KontraktorServlet.this.getApiPath(), aCtx, this.buffer));
                }
            }

            public void onAllDataRead() throws IOException {
            }

            public void onError(Throwable throwable) {
                Log.Error((Object)((Object)KontraktorServlet.this), (Throwable)throwable);
            }
        });
    }

    protected void nonAPIPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Log.Warn((Object)((Object)this), (String)("unhandled post " + req.getPathInfo()));
        super.doPost(req, resp);
    }
}

