/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.AbstractHttpServerConnector;
import org.nustaq.kontraktor.remoting.http.HttpObjectSocket;
import org.nustaq.kontraktor.remoting.http.KHttpExchange;
import org.nustaq.kontraktor.remoting.http.servlet.KontraktorServlet;
import org.nustaq.kontraktor.remoting.http.servlet.ServletKHttpExchangeImpl;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.Pair;

public class ServletActorConnector
extends AbstractHttpServerConnector {
    KontraktorServlet servlet;

    public ServletActorConnector(Actor facade, KontraktorServlet servlet, Coding coding, Consumer<Actor> disconnectCallback) {
        super(facade);
        this.servlet = servlet;
        try {
            facade.setThrowExWhenBlocked(true);
            this.setConnectionVerifier(this.connectionVerifier);
            this.setSessionTimeout(this.sessionTimeout);
            this.actorServer = new ActorServer((ActorServerConnector)this, facade, coding == null ? new Coding(SerializerType.FSTSer) : coding);
            this.setActorServer(this.actorServer);
            this.actorServer.start(disconnectCallback);
        }
        catch (Exception e) {
            Log.Error(null, (Throwable)e);
        }
        try {
            this.actorServer.start(fail -> System.out.println("FIXME discon:" + fail));
        }
        catch (Exception e) {
            Log.Error((Object)this, (Throwable)e);
        }
    }

    protected void requestReceived(String endpointPrefix, AsyncContext aCtx, byte[] postData) {
        String path = ((HttpServletRequest)aCtx.getRequest()).getPathInfo();
        if (path == null) {
            path = "";
        }
        if (endpointPrefix != null) {
            path = path.substring(endpointPrefix.length());
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.trim().length() > 0) {
            String[] split = path.split("/");
            HttpObjectSocket httpObjectSocket = (HttpObjectSocket)this.sessions.get(split[0]);
            if (httpObjectSocket != null) {
                this.handleClientRequest(aCtx, httpObjectSocket, postData, split.length > 1 ? split[1] : null);
            } else {
                httpObjectSocket = this.restoreSessionFromId(split[0]);
                if (httpObjectSocket == null) {
                    HttpServletResponse response = (HttpServletResponse)aCtx.getResponse();
                    response.setStatus(404);
                    aCtx.complete();
                }
            }
        } else {
            Object auth = null;
            if (postData != null && postData.length > 0) {
                auth = this.conf.asObject(postData);
            }
            this.handleNewSession(new ServletKHttpExchangeImpl(this.servlet, aCtx));
        }
    }

    public void handleClientRequest(AsyncContext aCtx, HttpObjectSocket httpObjectSocket, byte[] postData, String lastSeenSequence) {
        boolean isEmptyLP;
        httpObjectSocket.updateTimeStamp();
        Object[] received = (Object[])httpObjectSocket.getConf().asObject(postData);
        boolean bl = isEmptyLP = received.length == 1 && received[0] instanceof Number;
        if (!isEmptyLP) {
            this.handleRegularRequest(aCtx, httpObjectSocket, received);
            return;
        }
        Pair<Runnable, KHttpExchange> lpTask = this.createLongPollTask(new ServletKHttpExchangeImpl(this.servlet, aCtx), httpObjectSocket);
        httpObjectSocket.cancelLongPoll();
        httpObjectSocket.setLongPollTask(lpTask);
    }

    protected void handleRegularRequest(AsyncContext aCtx, HttpObjectSocket httpObjectSocket, Object[] received) {
        ArrayList futures = new ArrayList();
        httpObjectSocket.getSink().receiveObject((Object)received, futures, (Object)((HttpServletRequest)aCtx.getRequest()).getHeader("JWT"));
        Runnable reply = () -> {
            Pair<byte[], Integer> nextQueuedMessage = httpObjectSocket.getNextQueuedMessage();
            byte[] response = (byte[])nextQueuedMessage.getFirst();
            aCtx.getResponse().setContentLength(response.length);
            if (response.length == 0) {
                aCtx.complete();
            } else {
                httpObjectSocket.storeLPMessage((Integer)nextQueuedMessage.cdr(), response);
                try {
                    ((HttpServletResponse)aCtx.getResponse()).setStatus(200);
                    aCtx.getResponse().setCharacterEncoding("UTF-8");
                    aCtx.getResponse().setContentType("text/html; charset=utf-8");
                    String respString = new String(response, "UTF-8");
                    System.out.println("send resp " + respString);
                    aCtx.getResponse().getWriter().write(respString);
                    aCtx.getResponse().getWriter().close();
                }
                catch (IOException e) {
                    Log.Error((Object)this, (Throwable)e);
                }
                aCtx.complete();
            }
        };
        if (futures == null || futures.size() == 0) {
            reply.run();
        } else {
            Actors.all(futures).timeoutIn((long)REQUEST_RESULTING_FUTURE_TIMEOUT).then(() -> reply.run()).onTimeout(() -> reply.run());
        }
    }

    protected Pair<Runnable, KHttpExchange> createLongPollTask(KHttpExchange exchange, HttpObjectSocket httpObjectSocket) {
        return new Pair(() -> {
            Pair<byte[], Integer> nextQueuedMessage = httpObjectSocket.getNextQueuedMessage();
            byte[] response = (byte[])nextQueuedMessage.getFirst();
            exchange.setResponseContentLength(response.length);
            if (response.length == 0) {
                exchange.endExchange();
            } else {
                httpObjectSocket.storeLPMessage((Integer)nextQueuedMessage.getSecond(), response);
                try {
                    exchange.send(new String(response, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    Log.Error((Object)this, (Throwable)ex);
                }
                exchange.endExchange();
            }
        }, (Object)exchange);
    }
}

