/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler.jsx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.nustaq.kontraktor.webapp.transpiler.jsx.AttributeNode;
import org.nustaq.kontraktor.webapp.transpiler.jsx.TokenNode;

public class TagNode
extends TokenNode {
    protected StringBuilder tagName = new StringBuilder(100);
    List<AttributeNode> attributes = new ArrayList<AttributeNode>();

    public void addTagName(char c) {
        if (this.tagName == null) {
            this.tagName = new StringBuilder(10);
        }
        if (c > '\u0000') {
            this.tagName.append(c);
        }
    }

    public boolean isReactComponent() {
        return this.tagName != null && this.tagName.length() > 0 && Character.isUpperCase(this.tagName.charAt(0));
    }

    public StringBuilder getTagName() {
        return this.tagName;
    }

    public List<AttributeNode> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(AttributeNode currentAttribute) {
        this.attributes.add(currentAttribute);
    }

    @Override
    public void dump(PrintStream p, String indent) {
        int i;
        p.println(indent + "_" + this.tagName + (this.children.size() == 0 ? "/_" : "_"));
        for (i = 0; i < this.attributes.size(); ++i) {
            AttributeNode attributeEntry = this.attributes.get(i);
            attributeEntry.dump(p, indent + "  ");
        }
        for (i = 0; i < this.children.size(); ++i) {
            TokenNode tokenNode = (TokenNode)this.children.get(i);
            tokenNode.dump(p, indent + "  ");
        }
    }
}

