/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.protocol.HttpContext;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;

public class AsyncHttpActor
extends Actor<AsyncHttpActor> {
    public static int MAX_CONN_PER_ROUTE = 30;
    public static int MAX_CONN_TOTAL = 500;
    private static AsyncHttpActor singleton;
    protected CloseableHttpAsyncClient asyncHttpClient;
    static final Header NO_CACHE;
    static String[] chromeHeaders;

    public static String readContentString(HttpResponse resp) throws IOException {
        byte[] bytes;
        String first;
        Header[] headers = resp.getHeaders("Content-Type");
        String charset = "UTF-8";
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                HeaderElement[] elements = header.getElements();
                if (elements == null) continue;
                for (int j = 0; j < elements.length; ++j) {
                    HeaderElement element = elements[j];
                    NameValuePair cs = element.getParameterByName("charset");
                    if (cs == null) continue;
                    charset = cs.getValue().toUpperCase();
                }
            }
        }
        String enc = null;
        headers = resp.getHeaders("Content-Encoding");
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                HeaderElement[] elements = header.getElements();
                if (elements == null) continue;
                for (int j = 0; j < elements.length; ++j) {
                    HeaderElement element = elements[j];
                    if (enc != null) {
                        Log.Error(AsyncHttpActor.class, (String)"unexpected encoding header");
                    }
                    enc = element.getName();
                }
            }
        }
        if ((first = new String(bytes = AsyncHttpActor.readContentBytes(resp, enc), 0, Math.min(bytes.length, 2000))).trim().startsWith("<?xml")) {
            int i = first.indexOf("encoding=\"");
            if (i > 0) {
                int beginIndex = i + "encoding=\"".length();
                int endIndex = first.indexOf(34, beginIndex);
                if (endIndex > beginIndex) {
                    charset = first.substring(beginIndex, endIndex).toUpperCase();
                }
                boolean bl = true;
            }
        } else {
            int idx = first.indexOf("charset=");
            if (idx >= 0) {
                int beginIndex;
                int endIndex = beginIndex = idx + "charset=".length();
                while (first.charAt(endIndex) != ' ' && first.charAt(endIndex) != '\"' && first.charAt(endIndex) != '\'' && first.charAt(endIndex) != '>' && first.charAt(endIndex) != '/') {
                    ++endIndex;
                }
                if (endIndex > beginIndex) {
                    charset = first.substring(beginIndex, endIndex).toUpperCase();
                }
            }
        }
        String s = new String(bytes, charset);
        for (int n = 0; n < s.length(); ++n) {
            if (s.charAt(n) != '\u0096') continue;
            s = s.replace('\u0096', '-');
            break;
        }
        return s;
    }

    public static byte[] readContentBytes(HttpResponse resp, String enc) throws IOException {
        ContentBufferEntity entity = (ContentBufferEntity)resp.getEntity();
        ContentInputStream in = (ContentInputStream)entity.getContent();
        byte[] barr = new byte[in.available()];
        int read = in.read(barr);
        if ("gzip".equals(enc)) {
            barr = AsyncHttpActor.unGZip(barr, read);
        }
        in.close();
        return barr;
    }

    public static byte[] unGZip(byte[] barr, int read) throws IOException {
        GZIPInputStream gin = new GZIPInputStream(new ByteArrayInputStream(barr));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(read * 10);
        IOUtils.copy((InputStream)gin, (OutputStream)baos);
        gin.close();
        barr = baos.toByteArray();
        return barr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableHttpAsyncClient getClient() {
        Class<AsyncHttpActor> clazz = AsyncHttpActor.class;
        synchronized (AsyncHttpActor.class) {
            if (this.asyncHttpClient == null) {
                SSLContext context = null;
                try {
                    context = SSLContext.getInstance("SSL");
                    context.init(null, new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }}, null);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (KeyManagementException e) {
                    e.printStackTrace();
                }
                this.asyncHttpClient = HttpAsyncClients.custom().setSSLContext(context).setMaxConnPerRoute(MAX_CONN_PER_ROUTE).setMaxConnTotal(MAX_CONN_TOTAL).setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(16).setSoKeepAlive(true).setSoReuseAddress(true).setConnectTimeout(10000).setSoTimeout(15000).build()).build();
                this.asyncHttpClient.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.asyncHttpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncHttpActor getSingleton() {
        Class<AsyncHttpActor> clazz = AsyncHttpActor.class;
        synchronized (AsyncHttpActor.class) {
            if (singleton == null) {
                singleton = (AsyncHttpActor)AsyncHttpActor.AsActor(AsyncHttpActor.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public IPromise sync() {
        return new Promise((Object)"dummy");
    }

    private String tryCleanUpUrl(String url) {
        try {
            String modifiedUrl = url;
            boolean containsHttp = modifiedUrl.indexOf("http://") >= 0;
            boolean containsHttps = modifiedUrl.indexOf("https://") >= 0;
            modifiedUrl = modifiedUrl.replaceAll("http://", "");
            modifiedUrl = modifiedUrl.replaceAll("https://", "");
            if (containsHttps) {
                modifiedUrl = "https://" + modifiedUrl;
            } else if (containsHttp) {
                modifiedUrl = "http://" + modifiedUrl;
            }
            return modifiedUrl;
        }
        catch (Throwable t) {
            Log.Warn((Object)((Object)this), (String)("error while cleanup url:" + url));
            t.printStackTrace();
            return url;
        }
    }

    public IPromise<String> getContent(String url, String ... headers) {
        int idx;
        if (url == null || url.trim().length() == 0) {
            return AsyncHttpActor.reject((Object)"invalid url");
        }
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        if ((idx = url.indexOf("#")) > 0) {
            url = url.substring(0, idx);
        }
        Promise res = new Promise();
        try {
            this.get(url, headers).then((Callback & Serializable)(response, err) -> {
                if (err != null) {
                    res.reject(err);
                    return;
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    res.reject((Object)response.getStatusLine().getStatusCode());
                    return;
                }
                try {
                    res.resolve((Object)AsyncHttpActor.readContentString(response));
                }
                catch (Throwable e) {
                    Log.Warn((Object)((Object)this), (Throwable)e);
                    res.reject((Object)e);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
            res.reject((Object)t);
        }
        return res;
    }

    public IPromise<byte[]> getContentBytes(String url, String ... headers) {
        int idx;
        if (url == null || url.trim().length() == 0) {
            return AsyncHttpActor.reject((Object)"invalid url");
        }
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        if ((idx = url.indexOf("#")) > 0) {
            url = url.substring(0, idx);
        }
        Promise res = new Promise();
        try {
            this.get(url, headers).then((Callback & Serializable)(response, err) -> {
                if (err != null) {
                    res.reject(err);
                    return;
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    res.reject((Object)response.getStatusLine().getStatusCode());
                    return;
                }
                String enc = null;
                Header[] heads = response.getHeaders("Content-Encoding");
                if (heads != null) {
                    for (int i = 0; i < heads.length; ++i) {
                        Header header = heads[i];
                        HeaderElement[] elements = header.getElements();
                        if (elements == null) continue;
                        for (int j = 0; j < elements.length; ++j) {
                            HeaderElement element = elements[j];
                            if (enc != null) {
                                Log.Error(AsyncHttpActor.class, (String)"unexpected encoding header");
                            }
                            enc = element.getName();
                        }
                    }
                }
                try {
                    res.resolve((Object)AsyncHttpActor.readContentBytes(response, enc));
                }
                catch (Throwable e) {
                    Log.Warn((Object)((Object)this), (Throwable)e);
                    res.reject((Object)e);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
            res.reject((Object)t);
        }
        return res;
    }

    public IPromise<HttpResponse> get(String url, String ... headers) {
        final Promise res = new Promise();
        if (url == null) {
            boolean bl = true;
        }
        try {
            String cleanedUrl = this.tryCleanUpUrl(url);
            HttpGet req = new HttpGet(cleanedUrl);
            this.setHeaders((HttpRequestBase)req, headers);
            this.beChrome((HttpRequestBase)req);
            this.getClient().execute((HttpUriRequest)req, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse result) {
                    AsyncHttpActor.this.execute(() -> res.resolve((Object)result));
                }

                public void failed(Exception ex) {
                    AsyncHttpActor.this.execute(() -> res.reject((Object)ex));
                }

                public void cancelled() {
                    AsyncHttpActor.this.execute(() -> res.reject((Object)"cancelled"));
                }
            });
        }
        catch (Throwable th) {
            Log.Warn((Object)((Object)this), (String)("get fail " + th + " " + url));
            res.reject((Object)th);
        }
        return res;
    }

    public IPromise<HttpResponse> post(String url, String postData, String ... headers) {
        final Promise res = new Promise();
        if (url == null) {
            boolean bl = true;
        }
        try {
            HttpPost req = new HttpPost(url);
            this.setHeaders((HttpRequestBase)req, headers);
            this.beChrome((HttpRequestBase)req);
            req.setEntity((HttpEntity)new StringEntity(postData));
            this.getClient().execute((HttpUriRequest)req, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse result) {
                    AsyncHttpActor.this.execute(() -> res.resolve((Object)result));
                }

                public void failed(Exception ex) {
                    AsyncHttpActor.this.execute(() -> res.reject((Object)ex));
                }

                public void cancelled() {
                    AsyncHttpActor.this.execute(() -> res.reject((Object)"cancelled"));
                }
            });
        }
        catch (Throwable th) {
            Log.Warn((Object)((Object)this), (String)("get fail " + th + " " + url));
            res.reject((Object)th);
        }
        return res;
    }

    public IPromise<HttpResponse> postWithContext(String url, String postData, HttpContext ctx, String ... headers) {
        final Promise res = new Promise();
        if (url == null) {
            boolean bl = true;
        }
        try {
            HttpPost req = new HttpPost(url);
            this.setHeaders((HttpRequestBase)req, headers);
            this.beChrome((HttpRequestBase)req);
            req.setEntity((HttpEntity)new StringEntity(postData));
            this.getClient().execute((HttpUriRequest)req, ctx, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse result) {
                    AsyncHttpActor.this.execute(() -> res.resolve((Object)result));
                }

                public void failed(Exception ex) {
                    AsyncHttpActor.this.execute(() -> res.reject((Object)ex));
                }

                public void cancelled() {
                    AsyncHttpActor.this.execute(() -> res.reject((Object)"cancelled"));
                }
            });
        }
        catch (Throwable th) {
            Log.Warn((Object)((Object)this), (String)("get fail " + th + " " + url));
            res.reject((Object)th);
        }
        return res;
    }

    private void setHeaders(HttpRequestBase req, String[] headers) {
        for (int i = 0; i < headers.length; i += 2) {
            if (headers[i] == null || headers[i + 1] == null) continue;
            req.setHeader(headers[i], headers[i + 1]);
        }
    }

    private void beChrome(HttpRequestBase req) {
        this.setHeaders(req, chromeHeaders);
    }

    public static void main(String[] args) throws InterruptedException {
        AsyncHttpActor http = (AsyncHttpActor)Actors.AsActor(AsyncHttpActor.class);
        http.getContent("http://www.zeit.de/gesellschaft/zeitgeschehen/2017-01/washington-womens-march-donald-trump-frauen-protest", new String[0]).then(r -> System.out.println((String)r));
        try {
            Thread.sleep(50000L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        http.post("https://www.betfair.com/www/sports/fixedodds/readonly/v1/getMarketPrices?xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c&_ak=FIhovAzZxtrvphhu&priceHistory=0", "{\"currencyCode\":\"GBP\",\"alt\":\"json\",\"locale\":\"en_GB\",\"marketIds\":[\"924.52118643\",\"924.52118648\",\"924.52118653\",\"924.52118658\",\"924.52118663\",\"924.52118668\",\"924.52118673\",\"924.40402572\",\"924.40594949\",\"924.40401998\",\"924.40402167\",\"924.40402697\",\"924.40402133\",\"924.40402201\",\"924.40402846\",\"924.40402595\",\"924.40402628\",\"924.40402666\",\"924.40402773\",\"924.40402249\",\"924.40402232\",\"924.40400946\",\"924.40402051\",\"924.40402099\",\"924.40402209\",\"924.40402635\",\"924.40402731\",\"924.40402863\",\"924.40402663\",\"924.40402812\",\"924.40402798\",\"924.40401939\",\"924.40402180\",\"924.40402012\",\"924.40402144\",\"924.40402067\",\"924.40402106\",\"924.40402596\",\"924.40402764\",\"924.40402830\",\"924.40402880\",\"924.40402700\",\"924.40402735\",\"924.8444186\",\"924.52118678\",\"924.52118683\"]}\nName\nfootball?modules=matchupdates%401038&lastId=1070&ts=1463161488790&alt=json&xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c\ngetMarketPrices?xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c&_ak=FIhovAzZxtrvphhu&priceHistory=0\nfootball?modules=matchupdates%401038&lastId=1070&ts=1463161503791&alt=json&xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c\ngetMarketPrices?xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c&_ak=FIhovAzZxtrvphhu&priceHistory=0\nfootball?modules=matchupdates%401038&lastId=1070&ts=1463161518790&alt=json&xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c\ngetMarketPrices?xsrftoken=1dea7f90-190f-11e6-9184-a0369f0e665c&_ak=FIhovAzZxtrvphhu&priceHistory=0\n", "Content-Type", "application/json").then((Callback & Serializable)(r, e) -> {
            System.out.println(r + " " + e);
            try {
                String s = AsyncHttpActor.readContentString(r);
                System.out.println("result:" + s);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
    }

    static {
        NO_CACHE = new Header(){

            public String getName() {
                return "Cache-Control";
            }

            public String getValue() {
                return "no-cache";
            }

            public HeaderElement[] getElements() throws ParseException {
                return new HeaderElement[0];
            }
        };
        chromeHeaders = new String[]{"Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8", "Accept-Language", "de-DE,de;q=0.8,en-US;q=0.6,en;q=0.4", "Upgrade-Insecure-Requests", "0", "User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.2924.76 Safari/537.36"};
    }
}

