/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.npm;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.yuchi.semver.Range;
import com.github.yuchi.semver.Version;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.npm.JNPMConfig;
import org.nustaq.utils.AsyncHttpActor;

public class JNPM
extends Actor<JNPM> {
    File nodeModulesDir;
    AsyncHttpActor http;
    JNPMConfig config;
    Map<String, List<Promise>> packagesUnderway = new HashMap<String, List<Promise>>();
    static JNPM singleton;

    public void init(File nodeModules, JNPMConfig config) {
        this.nodeModulesDir = nodeModules;
        this.http = AsyncHttpActor.getSingleton();
        this.http.setLimits(5, 10);
        this.config = config;
    }

    protected String getVersion(String module, String spec, List<String> versions, JsonObject finalDist) {
        String dist;
        if (spec == null) {
            return "latest";
        }
        String conf = this.config.getVersion(module);
        if (conf != null) {
            spec = conf;
        }
        if ((dist = finalDist.getString(spec, null)) != null) {
            return dist;
        }
        String[] bestMatch = new String[]{"latest"};
        try {
            String finalSpec = spec;
            versions.forEach(vers -> {
                try {
                    if (JNPM.matches(vers, finalSpec)) {
                        bestMatch[0] = vers;
                    }
                }
                catch (Exception e) {
                    Log.Warn((Object)((Object)this), (String)("cannot parse version tag:'" + vers + "'. Default to latest."));
                }
            });
        }
        catch (Exception e) {
            Log.Warn((Object)((Object)this), (String)("cannot parse version condition:'" + spec + "'. Default to latest."));
        }
        return bestMatch[0];
    }

    private static boolean matches(String version, String condition) {
        Range r = Range.from((Object)condition, (boolean)false);
        Version v = Version.from((Object)version, (boolean)false);
        return r.test(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPromise<InstallResult> npmInstall(String module, String versionSpec, File importingModuleDir) {
        if (versionSpec == null) {
            versionSpec = "latest";
        }
        File nodeModule = new File(this.nodeModulesDir, module);
        boolean installPrivate = false;
        if (nodeModule.exists()) {
            File targetDir = importingModuleDir.getName().equals("node_modules") ? this.nodeModulesDir : new File(importingModuleDir, "node_modules");
            String moduleKey = this.createModuleKey(module, targetDir);
            List<Promise> promises = this.packagesUnderway.get(moduleKey);
            if (promises != null) {
                boolean bl = true;
            }
            String finalVersionSpec1 = versionSpec;
            if (promises != null && promises.size() > 0) {
                Log.Warn((Object)((Object)this), (String)("Delaying because in transfer:" + module + " " + targetDir.getAbsolutePath()));
                Promise p = new Promise();
                this.delayed(1000L, () -> this.npmInstall(module, finalVersionSpec1, importingModuleDir).then((Callback)p));
                return p;
            }
            File pack = new File(nodeModule, "package.json");
            if (!pack.exists() || versionSpec.indexOf(".") <= 0) return JNPM.resolve((Object)((Object)InstallResult.EXISTS));
            String version = null;
            String vspec = null;
            try {
                JsonObject pjson = Json.parse((Reader)new FileReader(pack)).asObject();
                version = pjson.getString("version", null);
                vspec = versionSpec;
                if (!JNPM.matches(version, vspec)) {
                    Log.Warn((Object)((Object)this), (String)("version mismatch for module '" + module + "'. requested:" + versionSpec + " from '" + importingModuleDir.getName() + "' installed:" + version + ". (delete module dir for update)"));
                    if (this.config.getVersion(module) == null) {
                        installPrivate = true;
                        Log.Warn((Object)((Object)this), (String)("   installing private " + module));
                    } else {
                        Log.Warn((Object)((Object)this), (String)("   stick with mismatch because of jnpm.kson config entry for " + module));
                    }
                }
            }
            catch (Exception e) {
                Log.Error((Object)((Object)this), (String)("can't parse package.json in " + module + " " + importingModuleDir.getAbsolutePath() + ". Retry"));
                Promise p = new Promise();
                this.delayed(1000L, () -> this.npmInstall(module, finalVersionSpec1, importingModuleDir).then((Callback)p));
                return p;
            }
        }
        Promise p = new Promise();
        IPromise<List<String>> versionProm = this.getVersions(module);
        IPromise<JsonObject> distributionsProm = this.getDistributions(module);
        String finalVersionSpec = versionSpec == null ? "latest" : versionSpec;
        boolean finalInstallPrivate = installPrivate;
        distributionsProm.then((Callback & Serializable)(dist, derr) -> {
            if (dist == null) {
                dist = new JsonObject();
                Log.Error((Object)((Object)this), (String)("distribution is empty or error " + derr + " in module:" + module));
            }
            JsonObject finalDist = dist;
            versionProm.then((Callback & Serializable)(versions, verr) -> {
                if (versions == null) {
                    p.reject(verr);
                    return;
                }
                String resolvedVersion = this.getVersion(module, finalVersionSpec, (List<String>)versions, finalDist);
                this.http.getContent(this.config.getRepo() + "/" + module + "/" + resolvedVersion, new String[0]).then((Callback & Serializable)(cont, err) -> {
                    if (cont != null) {
                        File targetDir;
                        JsonObject pkg = Json.parse((String)cont).asObject();
                        String tarUrl = pkg.get("dist").asObject().get("tarball").asString();
                        JsonValue dependencies = pkg.get("dependencies");
                        dependencies = dependencies == null ? new JsonObject() : dependencies.asObject();
                        JsonValue peerdependencies = pkg.get("peerDependencies");
                        if (peerdependencies != null) {
                            ((JsonObject)dependencies).merge(peerdependencies.asObject());
                        }
                        File file = targetDir = finalInstallPrivate ? new File(importingModuleDir, "node_modules") : this.nodeModulesDir;
                        if (finalInstallPrivate) {
                            targetDir.mkdirs();
                        }
                        IPromise depP = this.downLoadAndInstall(tarUrl, module, resolvedVersion, targetDir);
                        ArrayList<IPromise> deps = new ArrayList<IPromise>();
                        deps.add(depP);
                        File importingDir = new File(this.nodeModulesDir, module);
                        ((JsonObject)dependencies).forEach(member -> deps.add(this.npmInstall(member.getName(), member.getValue().asString(), importingDir)));
                        JNPM.all(deps).then((Callback & Serializable)(r, e) -> p.resolve((Object)InstallResult.INSTALLED));
                    } else {
                        p.reject((Object)"no such module");
                    }
                });
            });
        });
        return p;
    }

    protected IPromise<List<String>> getVersions(String module) {
        Promise res = new Promise();
        this.http.getContent(this.config.getRepo() + "/" + module, new String[0]).then((Callback & Serializable)(cont, err) -> {
            if (cont != null) {
                JsonObject parse = Json.parse((String)cont).asObject().get("versions").asObject();
                ArrayList versions = new ArrayList();
                parse.forEach(mem -> versions.add(mem.getName()));
                res.resolve(versions);
            } else {
                res.reject(err);
            }
        });
        return res;
    }

    protected IPromise<JsonObject> getDistributions(String module) {
        Promise res = new Promise();
        this.http.getContent(this.config.getRepo() + "/-/package/" + module + "/dist-tags", new String[0]).then((Callback & Serializable)(cont, err) -> {
            if (cont != null) {
                JsonObject parse = Json.parse((String)cont).asObject();
                res.resolve((Object)parse);
            } else {
                res.reject(err);
            }
        });
        return res;
    }

    private IPromise downLoadAndInstall(String tarUrl, String moduleName, String resolvedVersion, File targetDir) {
        Promise p = new Promise();
        String moduleKey = this.createModuleKey(moduleName, targetDir);
        List<Promise> promlist = this.packagesUnderway.get(moduleKey);
        if (promlist != null) {
            if (promlist.size() == 0) {
                p.resolve((Object)true);
            } else {
                this.packagesUnderway.get(moduleKey).add(p);
            }
            return p;
        }
        Log.Info((Object)((Object)this), (String)String.format("installing '%s' in %s.", moduleName + "@" + resolvedVersion, targetDir.getAbsolutePath()));
        ArrayList<Promise> list = new ArrayList<Promise>();
        this.packagesUnderway.put(moduleKey, list);
        list.add(p);
        this.checkThread();
        this.http.getContentBytes(tarUrl, new String[0]).then((Callback & Serializable)(resp, err) -> this.execInThreadPool(() -> {
            byte[] b = resp;
            try {
                b = AsyncHttpActor.unGZip(b, b.length * 10);
                File outputDir = new File(targetDir, moduleName);
                JNPM.unTar(new ByteArrayInputStream(b), outputDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (ArchiveException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }).then(() -> {
            this.checkThread();
            this.packagesUnderway.get(moduleKey).forEach(prom -> prom.resolve((Object)true));
            this.packagesUnderway.get(moduleKey).clear();
        }));
        return p;
    }

    private String createModuleKey(String moduleName, File targetDir) {
        try {
            return moduleName + "#" + targetDir.getCanonicalPath();
        }
        catch (IOException e) {
            return moduleName + "#" + targetDir.getAbsolutePath();
        }
    }

    private static List<File> unTar(InputStream is, File outputDir) throws FileNotFoundException, IOException, ArchiveException {
        LinkedList<File> untaredFiles = new LinkedList<File>();
        TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
        TarArchiveEntry entry = null;
        while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.startsWith("package/")) {
                name = name.substring("package/".length());
            }
            File outputFile = new File(outputDir, name);
            if (entry.isDirectory()) {
                if (!outputFile.mkdirs()) {
                    throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
            } else {
                outputFile.getParentFile().mkdirs();
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                ((OutputStream)outputFileStream).close();
            }
            untaredFiles.add(outputFile);
        }
        debInputStream.close();
        return untaredFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPromise<InstallResult> Install(String module, String versionSpec, File modulesDir, JNPMConfig config) {
        Promise p = new Promise();
        Class<JNPM> clazz = JNPM.class;
        synchronized (JNPM.class) {
            if (singleton == null || singleton.isStopped()) {
                singleton = (JNPM)JNPM.AsActor(JNPM.class, (Scheduler)AsyncHttpActor.getSingleton().getScheduler());
                singleton.init(modulesDir, config);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            singleton.npmInstall(module, versionSpec, modulesDir).then((Callback & Serializable)(r, e) -> p.complete((Object)r, e));
            return p;
        }
    }

    public static void main(String[] args) {
        boolean matches = JNPM.matches("15.6.1", ">=0.14.0 <= 15");
        matches = JNPM.matches("15.6.1", ">=0.14.0 <=15");
        matches = JNPM.matches("16.0.0-beta.5", "^15.6.1");
        System.out.println(JNPM.matches("15.6.2", "^0.14.9 || >=15.3.0"));
    }

    public static enum InstallResult {
        EXISTS,
        INSTALLED,
        NOT_FOUND,
        FAILED,
        VERSION_MISMATCH;

    }
}

