/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.javascript;

import java.io.File;
import org.nustaq.kontraktor.webapp.javascript.HtmlImportShim;

public class DependencyResolver
implements HtmlImportShim.ResourceLocator {
    private final HtmlImportShim.ResourceLocator resourceLocator;
    protected File[] resourcePath;
    protected String baseDir = ".";

    public DependencyResolver(String baseDir, String[] resourcePath, HtmlImportShim.ResourceLocator rl) {
        this.baseDir = baseDir;
        this.setResourcePath(resourcePath);
        this.resourceLocator = rl;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected DependencyResolver setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    protected DependencyResolver setResourcePath(String ... path) {
        if (path == null) {
            this.resourcePath = new File[0];
            return this;
        }
        this.resourcePath = new File[path.length];
        for (int i = 0; i < path.length; ++i) {
            String dir = path[i].startsWith("/") ? path[i] : this.baseDir + "/" + path[i];
            File f = new File(dir).getAbsoluteFile();
            if (f.exists() && !f.isDirectory()) {
                throw new RuntimeException("only directorys can reside on resourcepath");
            }
            this.resourcePath[i] = f;
        }
        return this;
    }

    @Override
    public File locateResource(String name) {
        for (int i = 0; i < this.resourcePath.length; ++i) {
            File fi = new File(this.resourcePath[i].getAbsolutePath() + File.separator + name);
            if (!fi.exists()) continue;
            return fi;
        }
        return null;
    }

    @Override
    public byte[] retrieveBytes(File impFi) {
        byte[] bytes;
        if (this.resourceLocator != null && (bytes = this.resourceLocator.retrieveBytes(impFi)) != null) {
            return bytes;
        }
        return HtmlImportShim.ResourceLocator.super.retrieveBytes(impFi);
    }

    public String resolveUniquePath(File fi) {
        if (fi == null) {
            return null;
        }
        String longestMatch = "";
        try {
            String fp = fi.getCanonicalPath();
            for (int i = 0; i < this.resourcePath.length; ++i) {
                String p = this.resourcePath[i].getCanonicalPath();
                if (!fp.startsWith(p) || p.length() <= longestMatch.length()) continue;
                longestMatch = p;
            }
            return fp.substring(longestMatch.length()).replace('\\', '/');
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

