/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletResponse;
import org.nustaq.kontraktor.remoting.http.KHttpExchange;
import org.nustaq.kontraktor.remoting.http.servlet.KontraktorServlet;
import org.nustaq.kontraktor.util.Log;

public class ServletKHttpExchangeImpl
implements KHttpExchange {
    KontraktorServlet servlet;
    AsyncContext aCtx;

    public ServletKHttpExchangeImpl(KontraktorServlet servlet, AsyncContext aCtx) {
        this.servlet = servlet;
        this.aCtx = aCtx;
    }

    @Override
    public void endExchange() {
        this.aCtx.complete();
    }

    @Override
    public void setResponseContentLength(int length) {
        this.aCtx.getResponse().setContentLength(length);
    }

    @Override
    public void setResponseCode(int i) {
        ((HttpServletResponse)this.aCtx.getResponse()).setStatus(i);
    }

    @Override
    public void send(String s) {
        try {
            this.aCtx.getResponse().setCharacterEncoding("UTF-8");
            this.aCtx.getResponse().setContentType("text/html; charset=utf-8");
            this.aCtx.getResponse().getWriter().write(s);
        }
        catch (IOException e) {
            Log.Warn((Object)this, (Throwable)e);
        }
    }

    @Override
    public void send(byte[] b) {
        try {
            this.send(new String(b, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.Error((Object)this, (Throwable)e);
        }
    }

    @Override
    public void sendAuthResponse(byte[] response, String sessionId) {
        try {
            this.send(new String(response, "UTF-8"));
            this.aCtx.complete();
        }
        catch (UnsupportedEncodingException e) {
            Log.Error((Object)this, (Throwable)e);
        }
    }
}

