/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.transpiler;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import io.undertow.server.handlers.resource.Resource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.webapp.javascript.DynamicResourceManager;
import org.nustaq.kontraktor.webapp.javascript.FileResolver;
import org.nustaq.kontraktor.webapp.npm.JNPM;
import org.nustaq.kontraktor.webapp.npm.JNPMConfig;
import org.nustaq.kontraktor.webapp.transpiler.ErrorHandler;
import org.nustaq.kontraktor.webapp.transpiler.TranspileException;
import org.nustaq.kontraktor.webapp.transpiler.TranspilerHook;
import org.nustaq.kontraktor.webapp.transpiler.jsx.FileWatcher;
import org.nustaq.kontraktor.webapp.transpiler.jsx.ImportSpec;
import org.nustaq.kontraktor.webapp.transpiler.jsx.JSXGenerator;
import org.nustaq.kontraktor.webapp.transpiler.jsx.NodeLibNameResolver;
import org.nustaq.kontraktor.webapp.transpiler.jsx.ParseUtils;
import org.nustaq.kontraktor.webapp.transpiler.jsx.TimeStampedFileCache;
import org.nustaq.kontraktor.webapp.transpiler.jsx.WatchedFile;

public class JSXIntrinsicTranspiler
implements TranspilerHook {
    public static boolean BUNDLE_NODE_ALWAYS = true;
    protected boolean dev;
    protected File jnpmNodeModulesDir;
    protected boolean autoJNPM;
    protected JNPMConfig jnpmConfig;
    protected String jnpmConfigFile;
    protected JNPMConfig jnpmConfigFileCached;
    protected List<WatchedFile> readFiles;
    protected Map<String, File> nodeTopLevelImports;
    protected FileWatcher watcher;
    protected TimeStampedFileCache<JSXGenerator.ParseResult> transpiledCache = new TimeStampedFileCache();
    protected Map<String, File> nodeDirResolveCache = new HashMap<String, File>();
    protected boolean hmr = false;
    static File falseFile = new File("false");
    public static boolean USE_CUSTOM_RELOADFUN = false;

    public JSXIntrinsicTranspiler(boolean dev) {
        this.dev = dev;
        this.autoJNPM = dev;
    }

    @Override
    public byte[] transpile(File f) throws TranspileException {
        throw new RuntimeException("should not be called");
    }

    @Override
    public byte[] transpile(File f, FileResolver resolver, Map<String, Object> alreadyResolved) {
        byte[] bytes = this.processJSX(this.dev, f, resolver, alreadyResolved);
        return bytes;
    }

    private NodeLibNameResolver createNodeLibNameResolver(final FileResolver resolver) {
        return new NodeLibNameResolver(){

            @Override
            public String getFinalLibName(File requiredIn, FileResolver res, String requireText) {
                File file = null;
                try {
                    file = JSXIntrinsicTranspiler.this.findNodeModulesNearestMatch(requiredIn, requireText);
                    if (file == null) {
                        file = resolver.resolveFile(requiredIn.getParentFile(), requireText);
                    }
                    if (file == null) {
                        file = resolver.resolveFile(requiredIn.getParentFile(), requireText + ".js");
                    }
                    if (file == null) {
                        file = resolver.resolveFile(requiredIn.getParentFile(), requireText + ".jsx");
                    }
                    if (file == null) {
                        Log.Warn((Object)this, (String)("unable to find finalLibName for:" + requireText + " in " + requiredIn.getAbsolutePath()));
                        return requireText;
                    }
                    if (file.isDirectory()) {
                        file = JSXIntrinsicTranspiler.this.processNodeDir(file, resolver, new HashMap());
                    }
                    return JSXIntrinsicTranspiler.this.constructLibName(file, resolver);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public byte[] resolve(File baseDir, String name, Map<String, Object> alreadyProcessed) {
                return resolver.resolve(baseDir, name, alreadyProcessed);
            }

            @Override
            public File resolveFile(File baseDir, String name) {
                return resolver.resolveFile(baseDir, name);
            }

            @Override
            public void install(String path, byte[] resolved) {
                resolver.install(path, resolved);
            }

            @Override
            public String resolveUniquePath(File file) {
                return resolver.resolveUniquePath(file);
            }

            @Override
            public Resource getResource(String initialPath) {
                return resolver.getResource(initialPath);
            }
        };
    }

    File findNodeModulesNearestMatch(File requiringFile, String requireText) throws IOException {
        if (requiringFile == null) {
            return null;
        }
        if (!requireText.startsWith(".")) {
            File f = new File(requiringFile, "node_modules/" + requireText);
            if (f.exists()) {
                return new File(TimeStampedFileCache.getCanonicalPath(f));
            }
            f = new File(requiringFile, "node_modules/" + requireText + ".js");
            if (f.exists()) {
                return new File(TimeStampedFileCache.getCanonicalPath(f));
            }
            return this.findNodeModulesNearestMatch(requiringFile.getParentFile(), requireText);
        }
        File f = new File(requiringFile.getParentFile(), requireText);
        if (!f.exists()) {
            f = new File(requiringFile.getParentFile(), requireText + ".js");
        }
        if (f.exists()) {
            return new File(TimeStampedFileCache.getCanonicalPath(f));
        }
        return null;
    }

    private String getCanonicalPath(File f) throws IOException {
        if (Files.isSymbolicLink(f.toPath())) {
            return f.getAbsolutePath();
        }
        return f.getCanonicalPath();
    }

    String findNodeSubDir(File requiringFile) throws IOException {
        if (requiringFile == null) {
            return null;
        }
        if (requiringFile.getParentFile() != null && requiringFile.getParentFile().getName().equals("node_modules")) {
            return TimeStampedFileCache.getCanonicalPath(requiringFile);
        }
        return this.findNodeSubDir(requiringFile.getParentFile());
    }

    private File processNodeDir(File file, FileResolver resolver, Map<String, Object> alreadyResolved) {
        File jfi = new File(file, "package.json");
        if (jfi.exists()) {
            try {
                String main;
                JsonObject pkg = Json.parse((Reader)new FileReader(jfi)).asObject();
                JsonValue browser = pkg.get("browser");
                if (browser != null) {
                    if (browser.isBoolean() && !browser.asBoolean()) {
                        return falseFile;
                    }
                    if (browser.isString()) {
                        return new File(file, browser.asString());
                    }
                    if (browser.isObject()) {
                        String nodeModuleDir = TimeStampedFileCache.getCanonicalPath(file);
                        JsonObject members = browser.asObject();
                        members.forEach(member -> {
                            String key = "browser_" + nodeModuleDir + "_" + member.getName();
                            alreadyResolved.put(key, member.getValue());
                        });
                    } else {
                        Log.Warn((Object)this, (String)("unrecognized 'browser' entry in package.json, " + TimeStampedFileCache.getCanonicalPath(file)));
                        return null;
                    }
                }
                if ((main = pkg.getString("main", null)) != null) {
                    if (!main.endsWith(".js")) {
                        main = main + ".js";
                    }
                    File newF = new File(file, main);
                    return newF;
                }
                File indexf = new File(file, "index.js");
                if (indexf.exists()) {
                    return indexf;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (new File(file, "index.js").exists()) {
                return new File(file, "index.js");
            }
            if (new File(file.getParentFile(), file.getName() + ".js").exists()) {
                return new File(file.getParentFile(), file.getName() + ".js");
            }
        }
        return null;
    }

    public byte[] updateJSX(File f, FileResolver resolver) {
        try {
            boolean dev = true;
            ErrorHandler.get().reset();
            JSXGenerator.ParseResult result = JSXGenerator.process(f, dev, this.createNodeLibNameResolver(resolver), this.getConfig());
            byte[] res = result.getFiledata();
            ByteArrayOutputStream mainBao = new ByteArrayOutputStream(20000);
            if (result.generateESWrap()) {
                mainBao.write(this.generateImportPrologue(result, resolver).getBytes("UTF-8"));
            }
            if (result.generateCommonJSWrap()) {
                mainBao.write(this.generateCommonJSPrologue(f, result, resolver).getBytes("UTF-8"));
            }
            mainBao.write(res);
            if (result.generateESWrap()) {
                mainBao.write(this.generateImportEnd(result, resolver).getBytes("UTF-8"));
            }
            if (result.generateCommonJSWrap()) {
                mainBao.write(this.generateCommonJSEnd(f, result, resolver).getBytes("UTF-8"));
            }
            String dirName = "_node_modules";
            if (JSXIntrinsicTranspiler.isNotInNodeModules(f)) {
                dirName = "_appsrc";
            }
            String name = this.constructLibName(f, resolver) + ".transpiled";
            resolver.install("/" + dirName + "/" + name, mainBao.toByteArray());
            return mainBao.toByteArray();
        }
        catch (Exception e) {
            Log.Error((Object)this, (Throwable)e);
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            try {
                return out.getBuffer().toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                return new byte[0];
            }
        }
    }

    protected byte[] processJSX(boolean dev, File f, FileResolver resolver, Map<String, Object> alreadyResolved) {
        try {
            ByteArrayOutputStream mainBao;
            boolean notInNodeModules;
            boolean notInNodeModulesForModuleBundlingDev;
            boolean isInitialIndexJSX;
            boolean bl = isInitialIndexJSX = f != null && f.getName().endsWith("index.jsx");
            if (isInitialIndexJSX) {
                ErrorHandler.get().reset();
                this.jnpmConfigFileCached = null;
                if (dev) {
                    this.readFiles = new ArrayList<WatchedFile>();
                    this.nodeTopLevelImports = new HashMap<String, File>();
                    if (this.watcher != null) {
                        this.watcher = null;
                    }
                }
            }
            NodeLibNameResolver nodeLibNameResolver = this.createNodeLibNameResolver(resolver);
            JSXGenerator.ParseResult result = null;
            if (dev && !isInitialIndexJSX) {
                result = this.transpiledCache.get(f);
            }
            if (result == null) {
                result = JSXGenerator.process(f, dev, nodeLibNameResolver, this.getConfig());
                if (dev && !isInitialIndexJSX) {
                    this.transpiledCache.put(f, result);
                }
            }
            boolean bl2 = notInNodeModulesForModuleBundlingDev = (notInNodeModules = JSXIntrinsicTranspiler.isNotInNodeModules(f)) || !BUNDLE_NODE_ALWAYS;
            if (dev && notInNodeModules) {
                String finalLibName = nodeLibNameResolver.getFinalLibName(f, resolver, f.getName());
                this.readFiles.add(new WatchedFile(f, this, resolver, finalLibName));
            }
            List<ImportSpec> specs = result.getImports();
            byte[] res = result.getFiledata();
            if (isInitialIndexJSX) {
                alreadyResolved.put("JSXIndexStart", System.currentTimeMillis());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1000000);
                baos.write((this.getInitialShims() + "\n").getBytes("UTF-8"));
                alreadyResolved.put("JSXIndex", baos);
            }
            ByteArrayOutputStream indexBaos = (ByteArrayOutputStream)alreadyResolved.get("JSXIndex");
            if (alreadyResolved.get("_Ignored") == null) {
                alreadyResolved.put("_Ignored", result.getIgnoredRequires());
            }
            Set ignoredRequires = (Set)alreadyResolved.get("_Ignored");
            ignoredRequires.addAll(result.getIgnoredRequires());
            for (int i = 0; i < specs.size(); ++i) {
                ImportSpec importSpec = specs.get(i);
                File redirected = this.resolveImportSpec(f, importSpec, resolver, alreadyResolved, ignoredRequires);
                if (redirected != null) continue;
            }
            ByteArrayOutputStream byteArrayOutputStream = mainBao = dev && notInNodeModulesForModuleBundlingDev ? new ByteArrayOutputStream(20000) : indexBaos;
            if (result.generateESWrap()) {
                mainBao.write(this.generateImportPrologue(result, resolver).getBytes("UTF-8"));
            }
            if (result.generateCommonJSWrap()) {
                mainBao.write(this.generateCommonJSPrologue(f, result, resolver).getBytes("UTF-8"));
            }
            mainBao.write(res);
            if (result.generateESWrap()) {
                mainBao.write(this.generateImportEnd(result, resolver).getBytes("UTF-8"));
            }
            if (result.generateCommonJSWrap()) {
                mainBao.write(this.generateCommonJSEnd(f, result, resolver).getBytes("UTF-8"));
            }
            if (dev && notInNodeModulesForModuleBundlingDev) {
                String dirName = "_node_modules";
                if (notInNodeModules) {
                    dirName = "_appsrc";
                }
                String name = this.constructLibName(f, resolver) + ".transpiled";
                resolver.install("/" + dirName + "/" + name, mainBao.toByteArray());
                indexBaos.write(("document.write( '<script src=\"" + dirName + "/" + name + "\"></script>');\n").getBytes("UTF-8"));
            }
            if (isInitialIndexJSX) {
                if (dev) {
                    indexBaos.write("document.write('<script>_kreporterr = true; kinitfuns.forEach( fun => fun() );</script>')\n".getBytes("UTF-8"));
                    this.watcher = FileWatcher.get();
                    this.watcher.setFiles(this.readFiles);
                    if (dev && this.getConfig().isGeneratePackageDotJson()) {
                        System.out.println("============================= TOP LEVEL IMPORTS ======================================");
                        this.nodeTopLevelImports.forEach((s, fi) -> {
                            try {
                                File file = new File((File)fi, "package.json");
                                if (file.exists()) {
                                    JsonValue packjson = Json.parse((Reader)new FileReader(file));
                                    String version = packjson.asObject().getString("version", "*");
                                    System.out.println("\"" + s + "\":\"" + version + "\",");
                                } else {
                                    System.out.println("\"" + s + "\":no package.json");
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        });
                    }
                } else {
                    indexBaos.write("_kreporterr = true; kinitfuns.forEach( fun => fun() );\n".getBytes("UTF-8"));
                }
                Long tim = (Long)alreadyResolved.get("JSXIndexStart");
                Log.Info((Object)this, (String)("Transpilation time:" + (double)(System.currentTimeMillis() - tim) / 1000.0));
                if (isInitialIndexJSX && dev) {
                    List<String> errors = ErrorHandler.get().getErrors();
                    for (int i = 0; i < errors.size(); ++i) {
                        String s2 = errors.get(i);
                        indexBaos.write(("console.warn('" + s2 + "');\n").getBytes("UTF-8"));
                    }
                    Log.Info((Object)this, (String)("Number of Words estimated " + ParseUtils.calcWordCount()));
                }
                return indexBaos.toByteArray();
            }
            return mainBao.toByteArray();
        }
        catch (Exception e) {
            Log.Error((Object)this, (Throwable)e);
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            try {
                return out.getBuffer().toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                return new byte[0];
            }
        }
    }

    public static boolean isNotInNodeModules(File f) {
        return f.getAbsolutePath().replace('\\', '/').indexOf("/node_modules/") < 0;
    }

    private File resolveImportSpec(File requiringFile, ImportSpec importSpec, FileResolver resolver, Map<String, Object> alreadyResolved, Set ignoredRequires) throws IOException {
        File resolvedFile;
        String key;
        String from = importSpec.getFrom();
        File toReadFrom = requiringFile;
        String toReadFromName = null;
        if (importSpec.isRequire()) {
            if (ignoredRequires.contains(importSpec.getFrom())) {
                return null;
            }
            if (this.dev && this.getConfig().getIgnoredDevRequires().contains(importSpec.getFrom())) {
                Log.Info((Object)this, (String)("omit " + importSpec.getFrom() + " caused by jnpm.kson"));
                return null;
            }
            if (!this.dev && this.getConfig().getIgnoredProdRequires().contains(importSpec.getFrom())) {
                Log.Info((Object)this, (String)("omit " + importSpec.getFrom() + " caused by jnpm.kson"));
                return null;
            }
            String canonicalF = this.findNodeSubDir(requiringFile);
            if (canonicalF != null) {
                key = "browser_" + canonicalF + "_" + from;
                JsonValue o = (JsonValue)alreadyResolved.get(key);
                if (o != null) {
                    if (o.isString()) {
                        String oldFrom = from;
                        from = o.asString();
                        Log.Info((Object)this, (String)("mapping package.json/browser:" + oldFrom + " to " + from));
                    } else if (o.isBoolean()) {
                        if (!o.asBoolean()) {
                            Log.Info((Object)this, (String)("ignoring because of package.json/browser:" + from));
                            return null;
                        }
                    } else {
                        Log.Warn((Object)this, (String)("unrecognized browser entry in package.json:" + o + ". file:" + requiringFile.getAbsolutePath()));
                    }
                }
            } else {
                Log.Warn((Object)this, (String)("node module dir could not be resolved " + requiringFile.getAbsolutePath()));
                return null;
            }
        }
        if (importSpec.isRequire()) {
            key = requiringFile.getAbsolutePath() + "#" + from;
            resolvedFile = this.nodeDirResolveCache.get(key);
            if (resolvedFile == null && (resolvedFile = this.findNodeModulesNearestMatch(requiringFile, from)) != null) {
                this.nodeDirResolveCache.put(key, resolvedFile);
            }
            if (resolvedFile != null) {
                toReadFromName = resolvedFile.getName();
                toReadFrom = resolvedFile;
            } else {
                boolean o = true;
            }
        } else {
            resolvedFile = resolver.resolveFile(requiringFile.getParentFile(), from);
        }
        if (resolvedFile != null && resolvedFile.isDirectory()) {
            File indexFile;
            if (JSXIntrinsicTranspiler.isNotInNodeModules(requiringFile)) {
                String tlFrom = importSpec.getFrom();
                if (this.nodeTopLevelImports != null) {
                    this.nodeTopLevelImports.put(tlFrom, resolvedFile);
                }
            }
            if ((indexFile = this.processNodeDir(resolvedFile, resolver, alreadyResolved)) == falseFile) {
                return null;
            }
            if (indexFile == null) {
                ErrorHandler.get().add(this.getClass(), "node directory could not be resolved to a resource ", resolvedFile);
                return null;
            }
            toReadFrom = indexFile;
            toReadFromName = indexFile.getName();
        } else {
            int extlen = from.length() - from.lastIndexOf(46);
            if (!(extlen < 6 && from.substring(from.length() - extlen).indexOf(47) < 0 || from.endsWith(".js") || from.endsWith(".jsx") || from.endsWith(".json"))) {
                from = from + ".js";
            }
        }
        byte[] resolved = resolver.resolve(toReadFrom.getParentFile(), toReadFromName != null ? toReadFromName : from, alreadyResolved);
        if (resolved == null && from.endsWith(".js")) {
            from = from.substring(0, from.length() - 3) + ".jsx";
            resolved = resolver.resolve(requiringFile.getParentFile(), from, alreadyResolved);
        }
        if (resolved != null) {
            if (resolved.length > 0) {
                resolvedFile = resolver.resolveFile(toReadFrom.getParentFile(), toReadFromName != null ? toReadFromName : from);
                String name = null;
                if (resolvedFile.getName().endsWith(".json")) {
                    name = this.constructLibName(resolvedFile, resolver) + ".json";
                    ByteArrayOutputStream jsonBao = new ByteArrayOutputStream(resolved.length + 100);
                    jsonBao.write("(function(exports, require, module, __filename, __dirname) { module.exports = \n".getBytes("UTF-8"));
                    jsonBao.write(resolved);
                    String s = this.constructLibName(requiringFile, resolver);
                    jsonBao.write(("})( kgetModule('" + s + "').exports, krequire, kgetModule('" + s + "'), '', '' );").getBytes("UTF-8"));
                    resolver.install("/debug/" + name, jsonBao.toByteArray());
                } else if (resolvedFile.getName().endsWith(".css") && importSpec.isPureImport()) {
                    name = this.constructLibName(resolvedFile, resolver);
                    ByteArrayOutputStream cssBao = new ByteArrayOutputStream(resolved.length + 100);
                    cssBao.write(("if ( !window['" + name + "'] ) {\n").getBytes("UTF-8"));
                    cssBao.write("  const __css__ = document.createElement('style');".getBytes("UTF-8"));
                    cssBao.write("  __css__.type = \"text/css\";\n".getBytes("UTF-8"));
                    cssBao.write("  __css__.innerHTML = `".getBytes("UTF-8"));
                    cssBao.write(resolved);
                    cssBao.write("`\n".getBytes("UTF-8"));
                    cssBao.write("  document.body.appendChild(__css__);\n".getBytes("UTF-8"));
                    cssBao.write(("  window['" + name + "'] = 1;\n").getBytes("UTF-8"));
                    cssBao.write("}\n".getBytes("UTF-8"));
                    String s = this.constructLibName(requiringFile, resolver);
                    resolver.install("/debug/" + name, cssBao.toByteArray());
                }
            }
        } else {
            if (this.autoJNPM && this.jnpmNodeModulesDir != null) {
                String required = importSpec.getFrom();
                if ((required = JSXIntrinsicTranspiler.getLookupLibName(required)).indexOf(".") < 0) {
                    JNPMConfig config = this.getConfig();
                    Log.Info((Object)this, (String)(importSpec.getFrom() + " not found. installing .. '" + required + "'"));
                    try {
                        JNPM.InstallResult await = (JNPM.InstallResult)((Object)JNPM.Install(required, null, this.jnpmNodeModulesDir, config).await(TimeUnit.MINUTES.toMillis(1L)));
                        if (await == JNPM.InstallResult.INSTALLED) {
                            return this.resolveImportSpec(requiringFile, importSpec, resolver, alreadyResolved, ignoredRequires);
                        }
                    }
                    catch (Throwable kt) {
                        kt.printStackTrace();
                        Log.Error((Object)this, (String)"jnpm install timed out. Check Proxy JVM settings, internet connectivity or just retry");
                    }
                }
            }
            ErrorHandler.get().add(this.getClass(), importSpec.getFrom() + " not found. requiredBy ", requiringFile);
        }
        return requiringFile;
    }

    public static String getLookupLibName(String required) {
        if (required.startsWith("@")) {
            int idx = required.indexOf(47);
            int i = (required = required.substring(0, idx) + "/" + required.substring(idx + 1)).indexOf("/", idx + 1);
            if (i >= 0) {
                required = required.substring(0, i);
            }
            return required;
        }
        int i = required.indexOf("/");
        if (i >= 0) {
            required = required.substring(0, i);
        }
        return required;
    }

    protected JNPMConfig getConfig() {
        JNPMConfig jNPMConfig = this.jnpmConfig != null ? this.jnpmConfig : (this.jnpmConfigFile != null ? (this.jnpmConfigFileCached != null ? this.jnpmConfigFileCached : (this.jnpmConfigFileCached = JNPMConfig.read(this.jnpmConfigFile))) : new JNPMConfig());
        return jNPMConfig;
    }

    protected String generateCommonJSPrologue(File f, JSXGenerator.ParseResult result, FileResolver resolver) {
        return "(function(exports, require, module, __filename, __dirname) {\n";
    }

    protected String generateCommonJSEnd(File f, JSXGenerator.ParseResult result, FileResolver resolver) {
        String s = this.constructLibName(f, resolver);
        return "\n})( kgetModule('" + s + "').exports, krequire, kgetModule('" + s + "'), '', '' );";
    }

    protected String generateImportEnd(JSXGenerator.ParseResult result, FileResolver resolver) {
        String gl;
        int i;
        String s = "\n\n\n//generated by jsxtranspiler\n";
        String libName = this.constructLibName(result.getFile(), resolver);
        s = s + "kimports['" + libName + "']=_kimptmp;";
        String exportObject = "_kimptmp";
        for (i = 0; i < result.getGlobals().size(); ++i) {
            gl = result.getGlobals().get(i);
            s = s + exportObject + "." + gl + " = _kwrapfn(" + gl + ");";
            if (!gl.equals(result.getDefaultExport())) continue;
            s = s + exportObject + ".__kdefault__= " + exportObject + "." + gl;
        }
        if (this.hmr) {
            s = s + "\n_kimptmp.__modimports = __modimports; _kimptmp.__initial_modimports = __initial_modimports;\n";
        }
        if (this.dev && this.hmr) {
            s = s + "\n__keval['" + libName + "'] = __uh_oh__ => {";
            for (i = 0; i < result.getGlobals().size(); ++i) {
                gl = result.getGlobals().get(i);
                s = s + "let " + gl + " = _kimptmp['" + gl + "'];";
                if (!gl.equals(result.getDefaultExport())) continue;
                s = s + "let __kdefault__= " + gl + ";";
            }
            s = s + "return eval(__uh_oh__.toString()); }";
            if ("index".equals(libName)) {
                s = s + this.getHMRReloadFun();
            }
        }
        return s + "});\n";
    }

    protected String generateImportPrologue(JSXGenerator.ParseResult result, FileResolver resolver) {
        String alias;
        int j;
        String libname;
        ImportSpec spec;
        int i;
        String s = "";
        s = s + "(new function() {\n";
        List<ImportSpec> imports = result.getImports();
        NodeLibNameResolver nodeLibNameResolver = this.createNodeLibNameResolver(resolver);
        for (i = 0; i < imports.size(); ++i) {
            spec = imports.get(i);
            libname = nodeLibNameResolver.getFinalLibName(result.getFile(), resolver, spec.getFrom());
            if (spec.getAlias() != null) {
                s = s + "let " + spec.getAlias() + "=null;";
            }
            for (j = 0; j < spec.getAliases().size(); ++j) {
                alias = spec.getAliases().get(j);
                s = s + "let " + alias + "=null;";
            }
        }
        if (this.hmr) {
            s = s + "\n  const __modimports = { _kNoHMR: true };";
            s = s + "\n  const __initial_modimports = { _kNoHMR: true };";
        }
        s = s + "\n  const _initmods = () => {\n";
        for (i = 0; i < imports.size(); ++i) {
            spec = imports.get(i);
            libname = nodeLibNameResolver.getFinalLibName(result.getFile(), resolver, spec.getFrom());
            if (spec.isPureImport()) {
                byte[] resolved = ((DynamicResourceManager.MyResource)resolver.getResource("/debug/" + libname)).getBytes();
                try {
                    s = s + new String(resolved, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (spec.getAlias() != null) {
                s = s + "    " + spec.getAlias() + " = _kresolve('" + libname + "');" + (this.hmr ? "" : "\n");
                if (this.hmr) {
                    s = s + "__modimports['" + spec.getAlias() + "'] = " + spec.getAlias() + "; __initial_modimports['" + spec.getAlias() + "'] = true; \n";
                }
            }
            for (j = 0; j < spec.getAliases().size(); ++j) {
                alias = spec.getAliases().get(j);
                s = s + "    " + alias + " = _kresolve('" + libname + "', '" + spec.getComponents().get(j) + "'); " + (this.hmr ? "" : "\n");
                if (!this.hmr) continue;
                s = s + "__modimports['" + alias + "'] = " + alias + "; __initial_modimports['" + alias + "'] = true; \n";
            }
        }
        s = s + "  };\n";
        s = s + "  kaddinit(_initmods); const _kimptmp = {};\n\n";
        return s;
    }

    protected String constructLibName(File f, FileResolver resolver) {
        String name;
        String unique = resolver.resolveUniquePath(f);
        if (unique.startsWith("/")) {
            unique = unique.substring(1);
        }
        if ((name = unique).endsWith(".js")) {
            name = name.substring(0, name.length() - 3);
        }
        if (name.endsWith(".jsx")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith(".json")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }

    protected String getInitialShims() {
        return "// generated, see _appsrc folder in chrome's src tab for original sourcecode\n\nwindow.kmodules = {};\n\n  function kgetModule(name) {\n    var res = kmodules[name];\n    if ( res == null ) {\n      kmodules[name] = { exports: {} };\n      return kgetModule(name);\n    } else {\n      return res;\n    }\n  }\n\n  function krequire(name) {\n    const res = kgetModule(name).exports;\n    return res;\n  }\n\nwindow.__keval = window.__keval || {};\nwindow.klibmap = window.klibmap || {};\nwindow.kimports = window.kimports || {};\nwindow._sprd = function (obj) {\n  const copy = Object.assign({},obj);\n  Object.keys(obj).forEach( key => {\n    if ( key.indexOf(\"...\") == 0 ) {\n      const ins = obj[key];\n      if ( typeof ins != 'undefined') {\n        Object.keys(ins).forEach( ikey => {\n          if ( typeof ins[ikey] != 'undefined')\n          {\n            obj[ikey] = ins[ikey];\n          }\n        });\n        delete obj[key];\n      }\n    } else {\n      obj[key] = copy[key]; // overwrite original value\n    }\n  });\n  return obj;\n};\nvar _kreporterr = false;window._kresolve = function (libname,identifier) {\n  var res = klibmap[libname] ? klibmap[libname]() : (window.kimports[libname] ? window.kimports[libname] : null);\n  if ( identifier && res) res = res[identifier];\n  if ( ! res ) {\n    if ( !identifier)\n        res = kmodules[libname] ? kmodules[libname].exports : null;\n    else\n        res = kmodules[libname] ? kmodules[libname].exports[identifier] : null;\n  }\n  if ( ! res ) {\n    if (_kreporterr) console.error(\"unable to resolve \"+identifier+\" in klibmap['\"+libname+\"'] \")\n  }\n  else if (!identifier) {    var res1 = res.__esModule ? res.default:res;\n    return res1.__kdefault__ ? res1.__kdefault__ : res1;\n  }  return res;\n};\nwindow.module = {}; \nconst kinitfuns = [];\nfunction kaddinit(fun) { fun(); kinitfuns.push(fun); }\n" + (this.dev ? "window.process = { env: {} };\n" : "window.process = { env: { 'NODE_ENV' : 'production' } };\n") + (this.dev && this.hmr ? this.getHMRFunWrapper() : "_kwrapfn = function(fn){\n  return fn;\n};\n");
    }

    protected String getHMRFunWrapper() {
        return "_kwrapfn = function(fn){\n  if ( typeof fn === 'function') {\n    if ( ! fn._kNoHMR ) {\n      if ( fn.toString().indexOf('class') == 0 ) {\n        return fn; // classes are patched by prototype\n      } else if ( fn.toString().indexOf('function') == 0 ) {\n        const f = function(){\n          return f._kwrapped.apply(this, arguments);\n        };\n        f._kwrapped = fn;\n        return f;\n      } else {\n        const f = function(){\n          return f._kwrapped.apply(this, arguments);\n        };\n        f._kwrapped = fn;\n        return f;\n      }\n    }\n  }\n  return fn;\n};\n";
    }

    protected String getHMRReloadFun() {
        if (USE_CUSTOM_RELOADFUN) {
            return "";
        }
        return "\nif (typeof _kHMR === 'undefined') {\n  if (typeof KClient === 'undefined') {\n    console.error(\"hot module reloading requires 'import {KClient} from 'kontraktor-client''\");\n  }\n  const hmrcl = new KClient().useProxies(false);\n  let addr = \"ws://\" + window.location.host + \"/hotreloading\";\n\n  window._kredefineModule = function(patch, prev, libname, noUpdate) {\n\n    let impPatch = '';\n    Object.getOwnPropertyNames(patch.__modimports).forEach( key => {\n      if ( ! prev.__initial_modimports[key] ) {\n        prev.__modimports[key] = patch.__modimports[key];\n        impPatch += '\\nvar '+key+'= __modimports.'+key+';';\n        console.log(\"new import detected:\",key);\n\n      }\n    });\n    Object.getOwnPropertyNames(patch).forEach(topleveldef=>{\n        try {\n          const istop = \"__kdefault__\" !== topleveldef && prev['__kdefault__'] === prev[topleveldef];\n          if (\"__kdefault__\" === topleveldef) {// ignore\n          } else if (!prev[topleveldef]) {\n            prev[topleveldef] = patch[topleveldef];\n            // new definition, FIXME: not locally visible, unsupported for now\n            console.log('new definition detected',topleveldef);\n          } else if (patch[topleveldef]._kNoHMR) {// unmarked for HMR\n          } else if (typeof patch[topleveldef] === 'function') {\n            let src = patch[topleveldef].toString();\n            const isclass = src.indexOf(\"class\") == 0;\n            const isfun = src.indexOf(\"function\") == 0;\n            if (isfun || (!isclass)) // assume function or lambda\n            {\n              if (patch[topleveldef]._kwrapped && prev[topleveldef]._kwrapped) {\n                let funsrc = patch[topleveldef]._kwrapped.toString();\n                let evalSrc = impPatch+\";\"+\"\" + topleveldef + \" = \" + funsrc + \";\" + topleveldef;\n                const newfun = __keval[libname](evalSrc);\n                prev[topleveldef]._kwrapped = newfun;\n              }\n            } else if (isclass) {\n              const newName = topleveldef;\n              const newDef = __keval[libname](impPatch+\";\"+newName + \"=\" + src + \"; \" + newName);\n              Object.getOwnPropertyNames(newDef.prototype).forEach(key=>{\n                  prev[topleveldef].prototype[key] = newDef.prototype[key];\n                }\n              );\n            } else {\n              // should not happen\n              console.error(\"unknown function object\", src);\n            }\n          } else {\n            if (typeof patch[topleveldef] === 'object')\n              Object.assign(prev[topleveldef], patch[topleveldef]);\n            else {\n              console.log('(possible hot rel failure) direct assignment on redefine:' + topleveldef + ',' + (typeof patch[topleveldef]), patch[topleveldef]);\n              prev[topleveldef] = patch[topleveldef];\n            }\n          }\n          if (istop)\n            prev['__kdefault__'] = prev[topleveldef];\n        } catch (e) {\n          if (!(e instanceof TypeError))\n            console.log(e);\n        }\n      }\n    );\n    !noUpdate &&  window._kreactapprender.forceUpdate();\n  }\n  ;\n  // subscribe to filewatcher\n  hmrcl.connect(addr, \"WS\").then((conn,err)=>{\n      if (err) {\n        console.error(\"failed to connect to hot reloading actor on '\" + addr + \"'. Hot reloading won't work.\");\n        console.error('add to server builder:\".hmrServer(true)\"\\n');\n        return;\n      }\n      conn.ask(\"addListener\", (libname,e)=>{\n          console.log(\"a file has changed _appsrc/\" + libname);\n          if (!window._kreactapprender) {\n            console.error(\"hot module reloading requires window._kreactapprender to be set to rect root. E.g. 'window._kreactapprender = ReactDOM.render(global.app,document.getElementById(\\\"root\\\"));' \");\n            return;\n          }\n          if (!libname) {\n            console.error(\"failed to init hot reloading actor on '\" + addr + \"'. Hot reloading won't work.\");\n            console.error('add to server builder:\".hmrServer(true)\"\\n');\n          }\n          const lib = kimports[libname];\n          if (lib) {\n            // fetch new source and patch\n            fetch(\"_appsrc/\" + libname + \".transpiled\").then(response=>response.text()).then(text=>{\n                const prev = kimports[libname];\n                const prevEval = __keval[libname];\n                const exp = eval(\"let _kHMR=true;\" + text.toString());\n                const patch = kimports[libname];\n                kimports[libname] = prev;\n                __keval[libname] = prevEval;\n                window._kredefineModule(patch, prev, libname);\n              }\n            );\n          }\n        }\n      ).then((r,e)=>{\n          if (r)\n            console.log('connected to hmr server');\n          else\n            console.log('could not subscribe to hmr server');\n        }\n      );\n    }\n  );\n\n  // initially redefine all libs to avoid state loss on first redefine\n  console.log(\"init hot reloading ..\");\n  Object.getOwnPropertyNames(kimports).forEach(prop=>{\n      window._kredefineModule(kimports[prop], kimports[prop], prop, true);\n    }\n  );\n  console.log(\"... done init hot reloading\");\n}\n";
    }

    public JSXIntrinsicTranspiler nodeModulesDir(File jnpmNodeModulesDir) {
        this.jnpmNodeModulesDir = jnpmNodeModulesDir;
        return this;
    }

    public JSXIntrinsicTranspiler configureJNPM(String nodeModulesDir, String pathToJNPMConfigKsonFile) {
        this.jnpmNodeModulesDir = new File(nodeModulesDir);
        this.jnpmConfigFile = pathToJNPMConfigKsonFile;
        return this;
    }

    public JSXIntrinsicTranspiler configureJNPM(String nodeModulesDir, JNPMConfig config) {
        this.jnpmNodeModulesDir = new File(nodeModulesDir);
        this.jnpmConfig = config;
        return this;
    }

    public JSXIntrinsicTranspiler autoJNPM(boolean b) {
        this.autoJNPM = b;
        return this;
    }

    public JSXIntrinsicTranspiler dev(boolean dev) {
        this.dev = dev;
        return this;
    }

    public JSXIntrinsicTranspiler jnpmNodeModulesDir(File jnpmNodeModulesDir) {
        this.jnpmNodeModulesDir = jnpmNodeModulesDir;
        return this;
    }

    public JSXIntrinsicTranspiler jnpmConfig(JNPMConfig jnpmConfig) {
        this.jnpmConfig = jnpmConfig;
        return this;
    }

    public JSXIntrinsicTranspiler jnpmConfigFile(String jnpmConfigFile) {
        this.jnpmConfigFile = jnpmConfigFile;
        return this;
    }

    public JSXIntrinsicTranspiler jnpmConfigFileCached(JNPMConfig jnpmConfigFileCached) {
        this.jnpmConfigFileCached = jnpmConfigFileCached;
        return this;
    }

    public JSXIntrinsicTranspiler readFiles(List<WatchedFile> readFiles) {
        this.readFiles = readFiles;
        return this;
    }

    public JSXIntrinsicTranspiler watcher(FileWatcher watcher) {
        this.watcher = watcher;
        return this;
    }

    public JSXIntrinsicTranspiler hmr(boolean hmr) {
        this.hmr = hmr;
        return this;
    }

    public JSXIntrinsicTranspiler falseFile(File falseFile) {
        JSXIntrinsicTranspiler.falseFile = falseFile;
        return this;
    }
}

