/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.base.ObjectSink;
import org.nustaq.kontraktor.remoting.base.ObjectSocket;
import org.nustaq.kontraktor.remoting.http.undertow.Http4K;
import org.nustaq.kontraktor.remoting.websockets.WebObjectSocket;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.Pair;
import org.nustaq.serialization.util.FSTUtil;
import org.xnio.Buffers;
import org.xnio.ChannelListener;

public class UndertowWebsocketServerConnector
implements ActorServerConnector {
    String host;
    String path;
    int port;
    boolean sendStrings = false;
    boolean sendSid = false;

    public UndertowWebsocketServerConnector(String path, int port, String host) {
        this.path = path;
        this.port = port;
        this.host = host;
    }

    public void connect(Actor facade, Function<ObjectSocket, ObjectSink> factory) throws Exception {
        PathHandler server = (PathHandler)this.getServer(this.port).getFirst();
        server.addExactPath(this.path, (HttpHandler)Handlers.websocket((exchange, channel) -> {
            CountDownLatch latch = new CountDownLatch(1);
            Runnable runnable = () -> {
                final UTWebObjectSocket objectSocket = new UTWebObjectSocket(exchange, channel, this.sendStrings, this.sendSid);
                final ObjectSink sink = (ObjectSink)factory.apply(objectSocket);
                objectSocket.setSink(sink);
                channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                    protected void onClose(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) throws IOException {
                        this.onCloseMessage(null, webSocketChannel);
                    }

                    protected void onCloseMessage(CloseMessage cm, WebSocketChannel channel) {
                        try {
                            channel.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        sink.sinkClosed();
                        try {
                            objectSocket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        channel.getReceiveSetter().set(null);
                    }

                    protected void onError(WebSocketChannel channel, Throwable error) {
                        Log.Debug((Object)((Object)this), (Throwable)error);
                        sink.sinkClosed();
                    }

                    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                        String data = message.getData();
                        byte[] bytez = data.getBytes("UTF-8");
                        sink.receiveObject(objectSocket.getConf().asObject(bytez), null, null);
                    }

                    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                        ByteBuffer[] data = (ByteBuffer[])message.getData().getResource();
                        byte[] bytez = Buffers.take((ByteBuffer[])data, (int)0, (int)data.length);
                        sink.receiveObject(objectSocket.getConf().asObject(bytez), null, null);
                    }
                });
                latch.countDown();
            };
            facade.execute(runnable);
            try {
                latch.await(3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            channel.resumeReceives();
        }));
    }

    protected Pair<PathHandler, Undertow> getServer(int port) {
        String hostName = this.host;
        return Http4K.get().getServer(port, hostName);
    }

    public IPromise closeServer() {
        ((Undertow)this.getServer(this.port).getSecond()).stop();
        return new Promise(null);
    }

    public UndertowWebsocketServerConnector sendStrings(boolean sendStrings) {
        this.sendStrings = sendStrings;
        return this;
    }

    public UndertowWebsocketServerConnector host(String host) {
        this.host = host;
        return this;
    }

    public UndertowWebsocketServerConnector path(String path) {
        this.path = path;
        return this;
    }

    public UndertowWebsocketServerConnector port(int port) {
        this.port = port;
        return this;
    }

    public UndertowWebsocketServerConnector sendSid(boolean sendSid) {
        this.sendSid = sendSid;
        return this;
    }

    protected static class UTWebObjectSocket
    extends WebObjectSocket {
        protected boolean sendSid;
        protected boolean sendStrings;
        protected WebSocketChannel channel;
        protected WebSocketHttpExchange ex;
        protected WeakReference<ObjectSink> sink;
        protected String uuid;
        static AtomicInteger idCount = new AtomicInteger(0);
        int id = idCount.incrementAndGet();

        public UTWebObjectSocket(WebSocketHttpExchange ex, WebSocketChannel channel, boolean sendStrings, boolean sendSid) {
            this.ex = ex;
            this.channel = channel;
            this.sendStrings = sendStrings;
            this.sendSid = sendSid;
            this.uuid = UUID.randomUUID().toString();
            if (sendSid) {
                WebSockets.sendText((ByteBuffer)ByteBuffer.wrap(("sid:" + this.uuid).getBytes()), (WebSocketChannel)channel, null);
            }
        }

        @Override
        public void sendBinary(byte[] message) {
            WebSocketCallback callback = new WebSocketCallback(){

                public void complete(WebSocketChannel channel, Object context) {
                }

                public void onError(WebSocketChannel channel, Object context, Throwable throwable) {
                    this.setLastError(throwable);
                    try {
                        isClosed = true;
                        this.close();
                    }
                    catch (IOException e) {
                        FSTUtil.rethrow((Throwable)e);
                    }
                }
            };
            if (this.sendStrings) {
                WebSockets.sendText((ByteBuffer)ByteBuffer.wrap(message), (WebSocketChannel)this.channel, (WebSocketCallback)callback);
            } else {
                WebSockets.sendBinary((ByteBuffer)ByteBuffer.wrap(message), (WebSocketChannel)this.channel, (WebSocketCallback)callback);
            }
        }

        public void close() throws IOException {
            ObjectSink objectSink;
            if (this.channel != null) {
                ChannelListener.Setter receiveSetter = this.channel.getReceiveSetter();
                if (receiveSetter != null) {
                    receiveSetter.set(null);
                }
                this.channel.close();
            }
            if (this.sink != null && (objectSink = (ObjectSink)this.sink.get()) != null) {
                objectSink.sinkClosed();
            }
            this.conf = null;
            this.channel = null;
            this.ex = null;
        }

        public String getConnectionIdentifier() {
            return this.uuid;
        }

        public int getId() {
            return this.id;
        }

        public void setSink(ObjectSink sink) {
            this.sink = new WeakReference<ObjectSink>(sink);
        }

        public ObjectSink getSink() {
            return (ObjectSink)this.sink.get();
        }
    }
}

