/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Date;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.bind.DatatypeConverter;

public class JWTUtil {
    public static String createSecret() {
        SecretKey secretKey = null;
        try {
            secretKey = KeyGenerator.getInstance("AES").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String secr = Base64.getEncoder().encodeToString(secretKey.getEncoded());
        return secr;
    }

    public static String encrypt(String subject, String secret) {
        return Jwts.builder().setSubject(subject).setIssuedAt(new Date()).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    public static String decrypt(String jwt, String secret) {
        if (secret == null) {
            return null;
        }
        Claims claims = JWTUtil.getClaims(jwt, secret);
        return claims.getSubject();
    }

    public static Claims getClaims(String jwt, String secret) {
        return (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secret)).parseClaimsJws(jwt).getBody();
    }

    public static String readSecret(String fi) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(fi, new String[0]));
        return new String(bytes, "UTF-8");
    }

    public static void writeSecret(String secret, String fi) throws IOException {
        byte[] bytes = secret.getBytes("UTF-8");
        Files.write(Paths.get(fi, new String[0]), bytes, new OpenOption[0]);
    }
}

