/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.javascript.minbingen;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nustaq.kontraktor.annotations.GenRemote;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.webapp.javascript.minbingen.AbstractGen;
import org.nustaq.kontraktor.webapp.javascript.minbingen.GenClazzInfo;
import org.nustaq.kontraktor.webapp.javascript.minbingen.GenContext;
import org.nustaq.kontraktor.webapp.javascript.minbingen.MsgInfo;
import org.nustaq.serialization.FSTClazzInfo;

public class MB2JS {
    public static void Gen(String packagesToScanColonSeparated, final String outputFile) throws Exception {
        AbstractGen gen = new AbstractGen(){

            @Override
            protected void genClzList(String outFile, ArrayList<String> finallist, GenContext ctx, HashMap<Class, List<MsgInfo>> infoMap, String templateFile) throws Exception {
                GenClazzInfo[] infos = new GenClazzInfo[finallist.size()];
                int skipCount = 0;
                for (int i = 0; i < infos.length; ++i) {
                    Class<?> type = Class.forName(finallist.get(i));
                    if (type.getAnnotation(Local.class) == null) {
                        infos[i] = new GenClazzInfo(this.conf.getClassInfo(type));
                        infos[i].setMsgs(infoMap.get(infos[i].getClzInfo().getClazz()));
                        System.out.println("generating clz " + finallist.get(i));
                        continue;
                    }
                    ++skipCount;
                }
                if (skipCount > 0) {
                    GenClazzInfo[] newInfos = new GenClazzInfo[infos.length - skipCount];
                    int icount = 0;
                    for (int i = 0; i < infos.length; ++i) {
                        if (infos[i] == null) continue;
                        newInfos[icount++] = infos[i];
                    }
                    infos = newInfos;
                }
                ctx.clazzInfos = infos;
                new MB2JS().receiveContext(ctx, new PrintStream(new FileOutputStream(outputFile)));
            }

            @Override
            public String getTemplateFileOrClazz() {
                return null;
            }
        };
        new FastClasspathScanner(packagesToScanColonSeparated.split(",")).matchClassesWithAnnotation(GenRemote.class, clazz -> {
            try {
                gen.addTopLevelClass(clazz.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).scan();
        if (gen.clazzSet.size() > 0) {
            gen.generate(outputFile);
        } else {
            System.out.println("no @GenRemote classes found in given packages");
        }
    }

    public void receiveContext(Object o, PrintStream out) throws Exception {
        int ii;
        GenContext CTX = (GenContext)o;
        for (ii = 0; ii < CTX.clazzInfos.length; ++ii) {
            int i;
            GenClazzInfo INF = CTX.clazzInfos[ii];
            FSTClazzInfo CLZ = INF.getClzInfo();
            List<MsgInfo> MSGS = INF.getMsgs();
            FSTClazzInfo.FSTFieldInfo[] fi = CLZ.getFieldInfo();
            out.println("");
            out.print("var J" + CLZ.getClazz().getSimpleName());
            out.println(" = function(obj) {");
            out.print("    this.__typeInfo = '" + (INF.isClientSide() ? CLZ.getClazz().getName() : CLZ.getClazz().getSimpleName()));
            out.println("';");
            if (INF.isActor()) {
                out.println("    this.receiverKey=obj;");
                out.println("    this._actorProxy = true;");
            }
            out.println("");
            for (i = 0; !INF.isActor() && fi != null && i < fi.length; ++i) {
                if (fi[i] == null) {
                    System.out.println(i + " is null in class " + CLZ.getClazz().getName());
                    continue;
                }
                String fnam = fi[i].getField().getName();
                String na = "j_" + fnam;
                out.print("    this." + na);
                out.print(" = function() { return " + CTX.getJSTransform(fi[i]));
                out.println("; };");
            }
            out.println("");
            for (i = 0; INF.isActor() && i < INF.getMsgs().size(); ++i) {
                int pi;
                MsgInfo mi = INF.getMsgs().get(i);
                out.print("    this." + mi.getName());
                out.print(" = function(");
                for (pi = 0; pi < mi.getParameters().length; ++pi) {
                    out.print(mi.getParameters()[pi].getName());
                    out.print(pi == mi.getParameters().length - 1 ? "" : ", ");
                }
                out.print(")");
                if (!INF.isClientSide()) {
                    out.println(" {");
                    out.println("        var call = MinBin.obj('call', {");
                    out.print("            method: '" + mi.getName());
                    out.println("',");
                    out.println("            receiverKey: this.receiverKey,");
                    out.print("            args: MinBin.jarray([");
                    for (pi = 0; pi < mi.getParameters().length; ++pi) {
                        out.println("");
                        out.print("                " + CTX.getJSTransform(mi.getParameters()[pi].getName(), mi.getParams()[pi]));
                        out.print(pi < mi.getParameters().length - 1 ? "," : "");
                    }
                    out.println("");
                    out.println("            ])");
                    out.println("        });");
                    if (mi.hasFutureResult()) {
                        out.println("        return K.send(call,true);");
                    } else {
                        out.println("        return K.send(call);");
                    }
                    out.println("    };");
                    continue;
                }
                out.println(" { /**/ };");
            }
            if (!INF.isActor()) {
                out.println("");
                out.println("    this.fromObj = function(obj) {");
                out.println("        for ( var key in obj ) {");
                out.println("            var setter = 'j_'.concat(key);");
                out.println("            if ( this.hasOwnProperty(setter) ) {");
                out.println("                this[key] = obj[key];");
                out.println("            }");
                out.println("        }");
                out.println("        return this;");
                out.println("    };");
                out.println("    if ( obj != null ) {");
                out.println("        this.fromObj(obj);");
                out.println("    }");
            }
            out.println("");
            out.println("};");
            out.println("");
        }
        out.println("");
        out.println("");
        out.println("var mbfactory = function(clzname,jsObjOrRefId) {");
        out.println("    switch (clzname) {");
        for (ii = 0; ii < CTX.clazzInfos.length; ++ii) {
            FSTClazzInfo CLZ = CTX.clazzInfos[ii].getClzInfo();
            out.print("        case '" + CLZ.getClazz().getSimpleName());
            out.print("': return new J" + CLZ.getClazz().getSimpleName());
            out.println("(jsObjOrRefId);");
        }
        out.println("        default: if (!jsObjOrRefId) return { __typeInfo: clzname }; else { jsObjOrRefId.__typeInfo = clzname; return jsObjOrRefId; }");
        out.println("    }");
        out.println("};");
        out.println("");
        out.println("MinBin.installFactory(mbfactory);");
    }
}

