/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.rest;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.remoting.base.ConnectionRegistry;
import org.nustaq.kontraktor.remoting.base.JsonMapable;
import org.nustaq.kontraktor.rest.AuthCredentials;
import org.nustaq.kontraktor.rest.ContentType;
import org.nustaq.kontraktor.rest.FromQuery;
import org.nustaq.kontraktor.rest.RequestPath;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.Pair;
import org.nustaq.serialization.FSTConfiguration;
import org.xnio.channels.StreamSourceChannel;

public class UndertowRESTHandler
implements HttpHandler {
    protected static final Object NOVAL = new Object();
    protected ObjectMapper mapper;
    protected String basePath;
    protected Actor facade;
    protected FSTConfiguration jsonConf = FSTConfiguration.createJsonConfiguration();
    protected Function<HeaderMap, IPromise> requestAuthenticator;
    protected Set<String> allowedMethods;
    protected Consumer<HttpServerExchange> prepareResponse;
    public static ParseAndDispatchREST RESTRequestHandler = null;

    public UndertowRESTHandler(String basePath, Actor facade, Function<HeaderMap, IPromise> requestAuthenticator, Consumer<HttpServerExchange> prepareResponse) {
        this.basePath = basePath;
        this.facade = facade;
        this.requestAuthenticator = requestAuthenticator;
        this.allowedMethods = new HashSet<String>();
        Arrays.stream(new String[]{"get", "put", "patch", "post", "delete", "head", "option"}).forEach(s -> this.allowedMethods.add((String)s));
        this.prepareResponse = prepareResponse;
        this.mapper = (ObjectMapper)ConnectionRegistry.CreateDefaultObjectMapper.get();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setAllowedMethods(Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.requestAuthenticator != null) {
            exchange.dispatch();
            this.requestAuthenticator.apply(exchange.getRequestHeaders()).then((Callback & Serializable)(r, e) -> {
                if (e != null) {
                    exchange.setResponseCode(403);
                    exchange.getResponseSender().send("" + e);
                } else {
                    this.handleInternal(exchange, r);
                }
            });
        } else {
            this.handleInternal(exchange, null);
        }
    }

    private void handleInternal(HttpServerExchange exchange, Object credentials) {
        String first;
        Method m;
        if (this.prepareResponse != null) {
            this.prepareResponse.accept(exchange);
        }
        String requestPath = exchange.getRequestPath();
        requestPath = requestPath.substring(this.basePath.length());
        while (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        String[] split = requestPath.split("/");
        String method = "" + exchange.getRequestMethod();
        String rawMethodName = method.toLowerCase();
        Object methodName = rawMethodName;
        if (!this.allowedMethods.contains(methodName)) {
            exchange.setResponseCode(400);
            exchange.endExchange();
            return;
        }
        if (split.length > 0 && split[0].length() > 1) {
            methodName = (String)methodName + split[0].substring(0, 1).toUpperCase() + split[0].substring(1);
        }
        if ((m = this.facade.getActor().__getCachedMethod((String)methodName, this.facade, null)) == null && (m = this.facade.getActor().__getCachedMethod(rawMethodName, this.facade, null)) == null) {
            exchange.setResponseCode(404);
            exchange.endExchange();
            return;
        }
        ContentType ct = m.getAnnotation(ContentType.class);
        if (ct != null) {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ct.value());
        }
        if ((first = exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH)) != null) {
            int len = Integer.parseInt(first);
            StreamSourceChannel requestChannel = exchange.getRequestChannel();
            ByteBuffer buf = ByteBuffer.allocate(len);
            Method finalM = m;
            this.checkExchangeState(exchange);
            AtomicBoolean hadResponse = new AtomicBoolean(false);
            requestChannel.getReadSetter().set(streamSourceChannel -> {
                this.checkExchangeState(exchange);
                try {
                    streamSourceChannel.read(buf);
                }
                catch (IOException e) {
                    Log.Warn((Object)this, (Throwable)e);
                }
                if (buf.remaining() == 0 && hadResponse.compareAndSet(false, true)) {
                    try {
                        requestChannel.shutdownReads();
                    }
                    catch (IOException e) {
                        Log.Warn((Object)this, (Throwable)e);
                    }
                    exchange.dispatch();
                    this.parseAndDispatch(exchange, split, rawMethodName, finalM, buf.array(), credentials);
                }
            });
            requestChannel.resumeReads();
            this.checkExchangeState(exchange);
        } else {
            exchange.dispatch();
            this.parseAndDispatch(exchange, split, requestPath, m, new byte[0], credentials);
        }
    }

    private void parseAndDispatch(HttpServerExchange exchange, String[] split, String rawPath, Method m, byte[] postData, Object credentials) {
        if (RESTRequestHandler != null) {
            RESTRequestHandler.parseAndDispatch(exchange, this, split, rawPath, m, postData, credentials);
            return;
        }
        try {
            Class<?>[] parameterTypes = m.getParameterTypes();
            Annotation[][] parameterAnnotations = m.getParameterAnnotations();
            Object[] args = new Object[parameterTypes.length];
            int splitIndex = 1;
            try {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    String stringVal;
                    Object val;
                    Class<?> parameterType = parameterTypes[i];
                    Annotation[] parameterAnnotation = parameterAnnotations[i];
                    if (parameterAnnotation != null && parameterAnnotation.length > 0) {
                        if (parameterAnnotation[0].annotationType() == FromQuery.class) {
                            String value = ((FromQuery)parameterAnnotation[0]).value();
                            Deque strings = (Deque)exchange.getQueryParameters().get(value);
                            if (strings != null) {
                                args[i] = this.inferValue(parameterType, (String)strings.getFirst());
                                continue;
                            }
                            args[i] = this.inferValue(parameterType, null);
                            continue;
                        }
                        if (parameterAnnotation[0].annotationType() == RequestPath.class) {
                            args[i] = rawPath;
                            continue;
                        }
                        if (parameterAnnotation[0].annotationType() == AuthCredentials.class) {
                            args[i] = credentials;
                            continue;
                        }
                    }
                    if (splitIndex < split.length && (val = this.inferValue(parameterType, stringVal = split[splitIndex])) != NOVAL) {
                        args[i] = val;
                        ++splitIndex;
                        continue;
                    }
                    if (parameterType == HeaderMap.class) {
                        args[i] = exchange.getRequestHeaders();
                        continue;
                    }
                    if (parameterType == String[].class) {
                        args[i] = split;
                        continue;
                    }
                    if (postData != null && (parameterType == JsonObject.class || parameterType == JsonValue.class)) {
                        args[i] = Json.parse((String)new String(postData, "UTF-8"));
                        continue;
                    }
                    if (postData != null) {
                        if (parameterType == byte[].class) {
                            args[i] = postData;
                            continue;
                        }
                        if (!JsonMapable.class.isAssignableFrom(parameterType)) continue;
                        args[i] = this.getMapper().readValue(postData, parameterType);
                        continue;
                    }
                    if (parameterType == Map.class) {
                        args[i] = exchange.getQueryParameters();
                        continue;
                    }
                    System.out.println("unsupported parameter type " + parameterType.getName());
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                Log.Warn((Object)this, (Throwable)th, (String)(postData != null ? new String(postData, 0) : ""));
                exchange.setStatusCode(400);
                exchange.getResponseSender().send(th + "\n");
                return;
            }
            Object invoke = m.invoke((Object)this.facade.getActorRef(), args);
            if (invoke instanceof IPromise) {
                this.checkExchangeState(exchange);
                ((IPromise)invoke).then((Callback & Serializable)(r, e) -> {
                    if (e != null) {
                        exchange.setStatusCode(500);
                        exchange.getResponseSender().send("" + e);
                    } else {
                        this.checkExchangeState(exchange);
                        if (r instanceof String) {
                            exchange.setStatusCode(200);
                            exchange.getResponseSender().send("" + r);
                        } else if (r instanceof Integer) {
                            exchange.setStatusCode(((Integer)r).intValue());
                            exchange.endExchange();
                        } else if (r instanceof Pair) {
                            exchange.setStatusCode(((Integer)((Pair)r).car()).intValue());
                            exchange.getResponseSender().send("" + ((Pair)r).cdr());
                        } else if (r instanceof JsonValue) {
                            exchange.getResponseSender().send(r.toString());
                        } else if (r instanceof Serializable) {
                            byte[] bytes = this.jsonConf.asByteArray(r);
                            exchange.getResponseSender().send(ByteBuffer.wrap(bytes));
                        }
                    }
                });
            } else if (invoke == null) {
                exchange.setStatusCode(200);
                exchange.endExchange();
            }
        }
        catch (Exception e2) {
            Log.Warn((Object)this, (Throwable)e2);
            exchange.setStatusCode(500);
            exchange.getResponseSender().send("" + e2);
            exchange.endExchange();
            return;
        }
    }

    private void checkExchangeState(HttpServerExchange exchange) {
    }

    private Object inferValue(Class<?> parameterType, String stringVal) {
        if (parameterType == Integer.TYPE) {
            return stringVal != null ? Integer.parseInt(stringVal) : 0;
        }
        if (parameterType == Long.TYPE) {
            return stringVal != null ? Long.parseLong(stringVal) : 0L;
        }
        if (parameterType == Double.TYPE) {
            return stringVal != null ? Double.parseDouble(stringVal) : 0.0;
        }
        if (parameterType == String.class) {
            return stringVal;
        }
        if (parameterType == JsonObject.class) {
            return stringVal != null ? Json.parse((String)stringVal).asObject() : null;
        }
        if (parameterType == JsonArray.class) {
            return stringVal != null ? Json.parse((String)stringVal).asArray() : null;
        }
        if (parameterType == JsonValue.class) {
            return stringVal != null ? Json.parse((String)stringVal) : null;
        }
        if (parameterType == String[].class) {
            return stringVal != null ? stringVal.split(",") : null;
        }
        return NOVAL;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Actor getFacade() {
        return this.facade;
    }

    public FSTConfiguration getJsonConf() {
        return this.jsonConf;
    }

    public Function<HeaderMap, IPromise> getRequestAuthenticator() {
        return this.requestAuthenticator;
    }

    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public Consumer<HttpServerExchange> getPrepareResponse() {
        return this.prepareResponse;
    }

    public static ParseAndDispatchREST getRESTRequestHandler() {
        return RESTRequestHandler;
    }

    public static interface ParseAndDispatchREST {
        public void parseAndDispatch(HttpServerExchange var1, UndertowRESTHandler var2, String[] var3, String var4, Method var5, byte[] var6, Object var7);
    }
}

