/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.nustaq.kontraktor.remoting.http.KHttpExchange;
import org.nustaq.kontraktor.util.Log;
import org.xnio.channels.StreamSinkChannel;

public class UndertowKHttpExchangeImpl
implements KHttpExchange {
    final HttpServerExchange ex;

    public UndertowKHttpExchangeImpl(HttpServerExchange ex) {
        this.ex = ex;
    }

    @Override
    public void endExchange() {
        this.ex.endExchange();
    }

    @Override
    public void setResponseContentLength(int length) {
        this.ex.setResponseContentLength((long)length);
    }

    @Override
    public void setResponseCode(int i) {
        this.ex.setResponseCode(i);
    }

    @Override
    public void send(String s) {
        this.ex.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html; charset=utf-8");
        this.ex.getResponseSender().send(s);
    }

    @Override
    public void send(byte[] b) {
        this.ex.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html; charset=utf-8");
        this.ex.getResponseSender().send(ByteBuffer.wrap(b));
    }

    @Override
    public void sendAuthResponse(byte[] response, String sessionId) {
        ByteBuffer responseBuf = ByteBuffer.wrap(response);
        this.ex.setResponseCode(200);
        this.ex.setResponseContentLength((long)response.length);
        StreamSinkChannel sinkchannel = this.ex.getResponseChannel();
        String finalSessionId1 = sessionId;
        sinkchannel.getWriteSetter().set(channel -> {
            if (responseBuf.remaining() > 0) {
                try {
                    sinkchannel.write(responseBuf);
                    if (responseBuf.remaining() == 0) {
                        Log.Info((Object)this, (String)("client connected " + finalSessionId1));
                        this.ex.endExchange();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.ex.endExchange();
                }
            } else {
                Log.Info((Object)this, (String)("client connected " + finalSessionId1));
                this.ex.endExchange();
            }
        });
        sinkchannel.resumeWrites();
    }

    @Override
    public String getPath() {
        return this.ex.getRequestPath();
    }
}

