/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow.builder;

import io.undertow.server.HttpServerExchange;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;
import org.nustaq.kontraktor.webapp.javascript.JSPostProcessor;
import org.nustaq.kontraktor.webapp.javascript.jsmin.JSMinifcationPostProcessor;
import org.nustaq.kontraktor.webapp.transpiler.TranspilerHook;

public class BldResPath {
    transient BldFourK cfg4k;
    String urlPath = "/dyn";
    String[] resourcePath;
    String baseDir = ".";
    boolean cacheAggregates = true;
    Boolean compress;
    File productionBuildDir;
    boolean inline = true;
    boolean stripComments = true;
    boolean minify = true;
    transient Map<String, TranspilerHook> transpilers = new HashMap<String, TranspilerHook>();
    Function<HttpServerExchange, Boolean> handlerInterceptor;
    List<JSPostProcessor> prodModePostProcessors = new ArrayList<JSPostProcessor>();

    public BldResPath(BldFourK cfg4k, String urlPath) {
        this.cfg4k = cfg4k;
        this.urlPath = urlPath;
        this.prodModePostProcessors.add(new JSMinifcationPostProcessor());
    }

    public BldResPath handlerInterceptor(Function<HttpServerExchange, Boolean> handlerInterceptor) {
        this.handlerInterceptor = handlerInterceptor;
        return this;
    }

    public List<JSPostProcessor> getProdModePostProcessors() {
        return this.prodModePostProcessors;
    }

    public Function<HttpServerExchange, Boolean> getHandlerInterceptor() {
        return this.handlerInterceptor;
    }

    public BldResPath jsPostProcessors(JSPostProcessor ... procs) {
        this.prodModePostProcessors.clear();
        for (int i = 0; i < procs.length; ++i) {
            this.prodModePostProcessors.add(procs[i]);
        }
        return this;
    }

    public BldResPath elements(String ... resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public BldResPath inline(boolean inline) {
        this.inline = inline;
        return this;
    }

    public BldResPath stripComments(boolean stripComments) {
        this.stripComments = stripComments;
        return this;
    }

    public BldResPath modify(Function<BldResPath, BldResPath> modificator) {
        return modificator.apply(this);
    }

    public BldResPath baseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public BldResPath minify(boolean minify) {
        this.minify = minify;
        return this;
    }

    public boolean isInline() {
        return this.inline;
    }

    public boolean isStripComments() {
        return this.stripComments;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public BldResPath cacheAggregates(boolean cacheAggregates) {
        this.cacheAggregates = cacheAggregates;
        return this;
    }

    public BldResPath allDev(boolean dev) {
        this.inline(!dev);
        this.stripComments(!dev);
        this.minify(!dev);
        this.cacheAggregates(!dev);
        this.compress(!dev);
        return this;
    }

    public BldResPath compress(boolean doGZip) {
        this.compress = doGZip;
        return this;
    }

    public BldFourK buildResourcePath() {
        return this.cfg4k;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public boolean isCacheAggregates() {
        return this.cacheAggregates;
    }

    public String[] getResourcePath() {
        return this.resourcePath;
    }

    public boolean isCompress() {
        if (this.compress == null) {
            return !this.cacheAggregates;
        }
        return this.compress;
    }

    public BldResPath transpile(String ending, TranspilerHook hook) {
        this.transpilers.put(ending, hook);
        return this;
    }

    public Map<String, TranspilerHook> getTranspilers() {
        return this.transpilers;
    }

    public BldResPath cfg4k(BldFourK cfg4k) {
        this.cfg4k = cfg4k;
        return this;
    }

    public BldResPath urlPath(String urlPath) {
        this.urlPath = urlPath;
        return this;
    }

    public BldResPath resourcePath(String[] resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public BldResPath productionBuildDir(File productionBuildDir) {
        this.productionBuildDir = productionBuildDir;
        return this;
    }

    public File getProductionBuildDir() {
        return this.productionBuildDir;
    }

    public BldResPath transpilers(Map<String, TranspilerHook> transpilers) {
        this.transpilers = transpilers;
        return this;
    }
}

