/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.rest;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.undertow.util.HeaderMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.remoting.base.JsonMapable;
import org.nustaq.kontraktor.rest.AuthCredentials;
import org.nustaq.kontraktor.rest.FromQuery;
import org.nustaq.kontraktor.rest.RequestPath;
import org.nustaq.kontraktor.rest.UndertowRESTHandler;
import org.nustaq.kontraktor.rest.doc.ApiOp;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.util.Pair;

public interface DocHandlerMixin {
    public static final AtomicReference<ObjectMapper> mapper = new AtomicReference();
    public static final Set<String> HttpMethods = Set.of(UndertowRESTHandler.METHODS);

    @CallerSideMethod
    public boolean isDocEnabled();

    private ObjectMapper getMapper() {
        if (mapper.get() == null) {
            ObjectMapper mp = new ObjectMapper();
            mp.setSerializationInclusion(JsonInclude.Include.ALWAYS);
            mp.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mp.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
            mp.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mp.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            mp.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
            mp.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
            mapper.set(mp);
        }
        return mapper.get();
    }

    private String methodPrefix(String mname) {
        if ("getDocumentation".equals(mname)) {
            return null;
        }
        if ("getClass".equals(mname)) {
            return null;
        }
        for (String htm : HttpMethods) {
            if (!mname.toLowerCase().startsWith(htm)) continue;
            return htm;
        }
        return null;
    }

    default public IPromise getDocumentation(String[] path) {
        String docTitle;
        if (!this.isDocEnabled()) {
            return new Promise((Object)404);
        }
        Class<?> aClass = this.getClass();
        Method[] methods = aClass.getMethods();
        List<Method> ml = Arrays.stream(methods).filter(m -> !Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && this.methodPrefix(m.getName()) != null && m.getDeclaringClass() != Actor.class).collect(Collectors.toList());
        OpenAPIDefinition apiDoc = aClass.getAnnotation(OpenAPIDefinition.class);
        String string = apiDoc == null ? aClass.getSimpleName() : (docTitle = !apiDoc.info().title().isEmpty() ? apiDoc.info().title() : "no title");
        String docDesc = apiDoc == null ? "" : (!apiDoc.info().description().isEmpty() ? apiDoc.info().description() : "");
        StringBuilder res = new StringBuilder();
        res.append("<html>");
        res.append("<h1>" + docTitle + "</h1>");
        res.append("<i>" + docDesc + "</i>");
        ml.forEach(method -> this.generateMethod(res, (Method)method));
        res.append("</html>");
        return new Promise((Object)res.toString());
    }

    private void generateMethod(StringBuilder res, Method method) {
        Operation op = method.getAnnotation(Operation.class);
        if (op != null && op.hidden()) {
            return;
        }
        String httpMethod = this.methodPrefix(method.getName());
        String path = method.getName().substring(httpMethod.length(), httpMethod.length() + 1).toLowerCase() + method.getName().substring(httpMethod.length() + 1);
        String summary = op == null ? "" : op.summary();
        String description = op == null ? "" : op.description();
        List<Pair<FromQuery, Class>> qp = this.extractQueryParams(method.getParameterAnnotations(), method.getParameters());
        List<Pair<String, Class>> pp = this.extractPathParams(method.getParameterAnnotations(), method.getParameters());
        Class postDTO = this.extractPostDTO(method.getParameterAnnotations(), method.getParameters());
        path = "/" + path + this.pathString(pp) + this.parameterString(qp);
        res.append("<div style='display: inline-block; background:#eee; margin:4px; padding: 8px; width: 97%;'>");
        DocHandlerMixin.lineHeader(res, httpMethod.toUpperCase(), "#fff", false);
        res.append("<div style='display: inline-block;margin: 2px;'><b>" + path + "</b></div>");
        ApiOp apiOp = method.getAnnotation(ApiOp.class);
        if (apiOp != null && apiOp.docPostDataDTO() != Void.class) {
            postDTO = apiOp.docPostDataDTO();
        }
        if (apiOp != null && summary.isEmpty()) {
            summary = apiOp.summary();
        }
        if (!summary.isEmpty()) {
            res.append("<div style='display: inline-block; margin: 4px;'> - <i>" + summary + "</i></div>");
        }
        if (apiOp != null && description.isEmpty()) {
            description = apiOp.description();
        }
        if (!description.isEmpty()) {
            res.append("<div style='display: inline-block; margin: 4px;'><i>" + description + "</i></div>");
        }
        if (qp.size() > 0) {
            qp.forEach(ap -> this.parameterDoc(res, (Pair<FromQuery, Class>)ap));
        }
        if (postDTO != null) {
            Object dtoStr = postDTO.getSimpleName();
            dtoStr = this.getDTOString(postDTO, (String)dtoStr);
            DocHandlerMixin.lineHeader(res, "post data", "none");
            if (apiOp != null && !apiOp.requestContainer().isEmpty()) {
                dtoStr = apiOp.requestContainer() + " of \n" + (String)dtoStr;
            }
            res.append("<div style='vertical-align: top;display: inline-block; margin: 2px;'><pre>" + (String)dtoStr + "</pre></div>");
        }
        if (op != null && op.responses().length > 0) {
            ApiResponse[] responses = op.responses();
            for (int i = 0; i < responses.length; ++i) {
                ApiResponse response = responses[i];
                Content[] contArr = response.content();
                for (int j = 0; j < contArr.length; ++j) {
                    Object dtoStr;
                    Content content = contArr[j];
                    Class clz = content.schema().implementation();
                    if (clz == Void.class && apiOp != null) {
                        clz = apiOp.response();
                    }
                    if (clz != Void.class) {
                        dtoStr = clz.getSimpleName();
                        dtoStr = this.getDTOString(clz, (String)dtoStr);
                        if (apiOp != null && !apiOp.container().isEmpty()) {
                            dtoStr = apiOp.container() + " of \n" + (String)dtoStr;
                        }
                        DocHandlerMixin.lineHeader(res, "response", "none");
                        res.append("<div style='vertical-align: top;display: inline-block; margin: 2px;'><pre>" + (String)dtoStr + "</pre></div>");
                        continue;
                    }
                    clz = content.array().schema().implementation();
                    if (clz == Void.class && apiOp != null) {
                        clz = apiOp.response();
                    }
                    if (clz == Void.class) continue;
                    dtoStr = clz.getSimpleName();
                    dtoStr = this.getDTOString(clz, (String)dtoStr);
                    dtoStr = apiOp != null && !apiOp.container().isEmpty() ? apiOp.container() + " of \n" + (String)dtoStr : "array of \n" + (String)dtoStr;
                    DocHandlerMixin.lineHeader(res, "response", "none");
                    res.append("<div style='vertical-align: top;display: inline-block; margin: 2px;'><pre>" + (String)dtoStr + "</pre></div>");
                }
            }
        } else if (apiOp != null && apiOp.response() != Void.class) {
            Class clz = apiOp.response();
            Object dtoStr = clz.getSimpleName();
            dtoStr = this.getDTOString(clz, (String)dtoStr);
            if (!apiOp.container().isEmpty()) {
                dtoStr = apiOp.container() + " of \n" + (String)dtoStr;
            }
            DocHandlerMixin.lineHeader(res, "response", "none");
            res.append("<div style='vertical-align: top;display: inline-block; margin: 2px;'><pre>" + (String)dtoStr + "</pre></div>");
        }
        res.append("</div>");
    }

    private String getDTOString(Class clz, String dtoStr) {
        if (!JsonMapable.class.isAssignableFrom(clz)) {
            return dtoStr;
        }
        try {
            JsonMapable o = (JsonMapable)clz.newInstance();
            if (o != null) {
                JsonObject parse = (JsonObject)Json.parse((String)this.getMapper().writeValueAsString((Object)o));
                this.putTypes(clz, parse);
                dtoStr = parse.toString(WriterConfig.PRETTY_PRINT);
            }
        }
        catch (Throwable t) {
            Log.Info((Object)this, (Throwable)t);
        }
        return dtoStr;
    }

    private void putTypes(Class clz, JsonObject parse) {
        parse.names().forEach(name -> {
            try {
                Field field = clz.getDeclaredField((String)name);
                if (field != null) {
                    if (JsonMapable.class.isAssignableFrom(field.getType())) {
                        JsonValue jsonValue = parse.get(name);
                        if (jsonValue.isNull()) {
                            JsonMapable o = (JsonMapable)field.getType().newInstance();
                            parse.set(name, Json.parse((String)this.getMapper().writeValueAsString((Object)o)));
                            this.putTypes(clz, parse);
                        } else {
                            this.putTypes(field.getType(), (JsonObject)parse.get(name));
                        }
                    } else {
                        parse.set(name, "&lt;" + field.getType().getSimpleName() + "&gt;");
                    }
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        });
    }

    private void parameterDoc(StringBuilder res, Pair<FromQuery, Class> ap) {
        if (!((FromQuery)ap.car()).desc().isEmpty()) {
            DocHandlerMixin.lineHeader(res, "param", "none");
            res.append("<div style='display: inline-block; margin: 2px;'> &lt;" + ((Class)ap.cdr()).getSimpleName() + "&gt; <b>" + ((FromQuery)ap.car()).value() + "</b> - <i>" + ((FromQuery)ap.car()).desc() + "</i></div>");
        }
    }

    private String parameterString(List<Pair<FromQuery, Class>> li) {
        if (li.isEmpty()) {
            return "";
        }
        Object res = "?";
        for (int i = 0; i < li.size(); ++i) {
            Pair<FromQuery, Class> pair = li.get(i);
            Class clz = (Class)pair.cdr();
            String type = clz.getSimpleName();
            res = (String)res + ((FromQuery)pair.car()).value() + "=&lt;" + type + "&gt;";
        }
        return res;
    }

    private String pathString(List<Pair<String, Class>> li) {
        if (li.isEmpty()) {
            return "";
        }
        Object res = "";
        for (int i = 0; i < li.size(); ++i) {
            Pair<String, Class> pair = li.get(i);
            Class clz = (Class)pair.cdr();
            String type = clz.getSimpleName();
            res = (String)res + "/" + (String)pair.car() + "&lt;" + type + "&gt;";
        }
        return res;
    }

    private List<Pair<FromQuery, Class>> extractQueryParams(Annotation[][] annotatedParameterTypes, Parameter[] p) {
        ArrayList<Pair<FromQuery, Class>> queryParams = new ArrayList<Pair<FromQuery, Class>>();
        for (int i = 0; i < annotatedParameterTypes.length; ++i) {
            Annotation[] ans = annotatedParameterTypes[i];
            Parameter par = p[i];
            for (int j = 0; j < ans.length; ++j) {
                Annotation an = ans[j];
                if (an.annotationType() != FromQuery.class) continue;
                queryParams.add((Pair<FromQuery, Class>)new Pair((Object)((FromQuery)an), par.getType()));
            }
        }
        return queryParams;
    }

    private List<Pair<String, Class>> extractPathParams(Annotation[][] annotatedParameterTypes, Parameter[] p) {
        ArrayList<Pair<String, Class>> queryParams = new ArrayList<Pair<String, Class>>();
        for (int i = 0; i < annotatedParameterTypes.length; ++i) {
            Annotation[] ans = annotatedParameterTypes[i];
            boolean hadSpecialAnnotation = false;
            Parameter par = p[i];
            Class<?> parType = par.getType();
            String desc = "";
            for (int j = 0; j < ans.length; ++j) {
                Annotation an = ans[j];
                if (an.annotationType() != FromQuery.class && an.annotationType() != RequestPath.class && an.annotationType() != AuthCredentials.class) continue;
                hadSpecialAnnotation = true;
                if (an.annotationType() != FromQuery.class) continue;
                desc = ((FromQuery)an).desc();
            }
            if (JsonMapable.class.isAssignableFrom(parType) || parType == HeaderMap.class || parType == String[].class || parType == byte[].class || parType == JsonObject.class || Map.class.isAssignableFrom(parType) || parType == JsonValue.class) {
                hadSpecialAnnotation = true;
            }
            if (hadSpecialAnnotation) continue;
            queryParams.add((Pair<String, Class>)new Pair((Object)desc, parType));
        }
        return queryParams;
    }

    private Class extractPostDTO(Annotation[][] annotatedParameterTypes, Parameter[] p) {
        for (int i = 0; i < annotatedParameterTypes.length; ++i) {
            Parameter par = p[i];
            Class<?> parType = par.getType();
            if (!JsonMapable.class.isAssignableFrom(parType)) continue;
            return parType;
        }
        return null;
    }

    private static void lineHeader(StringBuilder res, String httpMethod, String col) {
        DocHandlerMixin.lineHeader(res, httpMethod, col, true);
    }

    private static void lineHeader(StringBuilder res, String httpMethod, String col, boolean br) {
        if (br) {
            res.append("<br/>");
        }
        res.append("<div style='vertical-align: top; display: inline-block; width: 80px; padding: 2px; margin: 0; background: " + col + "; color:black'>" + httpMethod + "</div>&nbsp;");
    }
}

