/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.javascript.minbingen;

import java.util.Collection;
import java.util.Map;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.webapp.javascript.minbingen.GenClazzInfo;
import org.nustaq.serialization.FSTClazzInfo;

public class GenContext {
    public GenClazzInfo[] clazzInfos;

    public String getJSTransform(FSTClazzInfo.FSTFieldInfo fi) {
        Class fieldType = fi.getType();
        return this.getJSTransform("this." + fi.getField().getName(), fieldType);
    }

    public String getJSTransform(String fieldName, Class fieldType) {
        boolean isIntegral;
        Object res = "";
        boolean isArray = fieldType.isArray();
        boolean bl = isIntegral = fieldType.isPrimitive() || isArray && fieldType.getComponentType().isPrimitive();
        if (!isIntegral && isArray) {
            res = (String)res + "MinBin.jarray(" + fieldName + ")";
        } else if (Map.class.isAssignableFrom(fieldType)) {
            res = (String)res + "MinBin.jmap(" + fieldName + ")";
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            res = (String)res + "MinBin.jlist(" + fieldName + ")";
        } else if (isArray && isIntegral) {
            int integralCode = FSTClazzInfo.FSTFieldInfo.getIntegralCode(fieldType.getComponentType());
            switch (integralCode) {
                case 1: {
                    res = (String)res + fieldName + "?1:0";
                    break;
                }
                case 2: {
                    res = (String)res + "MinBin.i8(" + fieldName + ")";
                    break;
                }
                case 3: {
                    res = (String)res + "MinBin.ui16(" + fieldName + ")";
                    break;
                }
                case 4: {
                    res = (String)res + "MinBin.i16(" + fieldName + ")";
                    break;
                }
                case 5: {
                    res = (String)res + "MinBin.i32(" + fieldName + ")";
                    break;
                }
                case 6: {
                    res = (String)res + "MinBin.i64(" + fieldName + ")";
                    break;
                }
                case 7: {
                    res = (String)res + "MinBin.dbl(" + fieldName + ")";
                    break;
                }
                case 8: {
                    res = (String)res + "MinBin.dbl(" + fieldName + ")";
                    break;
                }
                default: {
                    throw new RuntimeException("wat? " + integralCode);
                }
            }
        } else if (fieldType == String[].class) {
            res = (String)res + "MinBin.strArr(" + fieldName + ")";
        } else if (isIntegral && !isArray) {
            int integralCode = FSTClazzInfo.FSTFieldInfo.getIntegralCode((Class)fieldType);
            switch (integralCode) {
                case 1: {
                    res = (String)res + fieldName + "?1:0";
                    break;
                }
                case 2: {
                    res = (String)res + "MinBin.parseIntOrNan(" + fieldName + ", 'byte' )";
                    break;
                }
                case 3: {
                    res = (String)res + "MinBin.parseIntOrNan(" + fieldName + ", 'char' )";
                    break;
                }
                case 4: {
                    res = (String)res + "MinBin.parseIntOrNan(" + fieldName + ", 'short' )";
                    break;
                }
                case 5: {
                    res = (String)res + "MinBin.parseIntOrNan(" + fieldName + ", 'int' )";
                    break;
                }
                case 6: {
                    res = (String)res + "MinBin.parseIntOrNan(" + fieldName + ", 'int' )";
                    break;
                }
                default: {
                    res = (String)res + fieldName;
                    break;
                }
            }
        } else {
            res = !Number.class.isAssignableFrom(fieldType) && !String.class.isAssignableFrom(fieldType) && !Character.class.isAssignableFrom(fieldType) && !Callback.class.isAssignableFrom(fieldType) ? (String)res + "MinBin.obj('" + fieldType.getSimpleName() + "'," + fieldName + ")" : (String)res + fieldName;
        }
        res = (String)res;
        return res;
    }
}

