/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow;

import io.undertow.Undertow;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.http.undertow.HttpPublisher;
import org.nustaq.kontraktor.remoting.http.undertow.WebSocketPublisher;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;
import org.nustaq.kontraktor.util.Pair;
import org.nustaq.kontraktor.webapp.javascript.DynamicResourceManager;

public class Http4K {
    public static int UNDERTOW_IO_THREADS = 8;
    public static int UNDERTOW_WORKER_THREADS = 8;
    protected static Http4K instance;
    protected Map<Integer, Pair<PathHandler, Undertow>> serverMap = new HashMap<Integer, Pair<PathHandler, Undertow>>();

    public static void set(Http4K http) {
        instance = http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Http4K get() {
        Class<Http4K> clazz = Http4K.class;
        synchronized (Http4K.class) {
            if (instance == null) {
                System.setProperty("org.jboss.logging.provider", "slf4j");
                instance = new Http4K();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static BldFourK Build(String hostName, int port, SSLContext ctx) {
        return Http4K.get().builder(hostName, port, ctx);
    }

    public static BldFourK Build(String hostName, int port) {
        return Http4K.get().builder(hostName, port, null);
    }

    public synchronized Pair<PathHandler, Undertow> getServer(int port, String hostName) {
        return this.getServer(port, hostName, null);
    }

    public synchronized Pair<PathHandler, Undertow> getServer(int port, String hostName, SSLContext context) {
        Pair pair = this.serverMap.get(port);
        if (pair == null) {
            PathHandler pathHandler = new PathHandler();
            Undertow.Builder builder = Undertow.builder().setIoThreads(UNDERTOW_IO_THREADS).setWorkerThreads(UNDERTOW_WORKER_THREADS);
            Undertow server = this.customize(builder, pathHandler, port, hostName, context).build();
            server.start();
            pair = new Pair((Object)pathHandler, (Object)server);
            this.serverMap.put(port, (Pair<PathHandler, Undertow>)pair);
        }
        return pair;
    }

    public BldFourK builder(String hostName, int port, SSLContext ctx) {
        return new BldFourK(hostName, port, ctx);
    }

    public BldFourK builder(String hostName, int port) {
        return new BldFourK(hostName, port, null);
    }

    protected Undertow.Builder customize(Undertow.Builder builder, PathHandler rootPathHandler, int port, String hostName, SSLContext context) {
        if (context == null) {
            return builder.addHttpListener(port, hostName).setHandler((HttpHandler)rootPathHandler);
        }
        return builder.addHttpsListener(port, hostName, context).setHandler((HttpHandler)rootPathHandler);
    }

    public Http4K publishFileSystem(String hostName, String urlPath, int port, File root) {
        if (!root.exists()) {
            root.mkdirs();
        }
        if (!root.isDirectory()) {
            throw new RuntimeException("root must be an existing direcory:" + root.getAbsolutePath());
        }
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ((PathHandler)server.car()).addPrefixPath(urlPath, (HttpHandler)new ResourceHandler((ResourceManager)new FileResourceManager(root, 100L)));
        return this;
    }

    public Http4K publishFileSystem(String hostName, String urlPath, int port, FileResourceManager man) {
        if (!man.getBase().isDirectory()) {
            throw new RuntimeException("root must be an existing direcory:" + man.getBase().getAbsolutePath());
        }
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ((PathHandler)server.car()).addPrefixPath(urlPath, (HttpHandler)new ResourceHandler((ResourceManager)man));
        return this;
    }

    public Http4K publishResourcePath(String hostName, String urlPath, int port, DynamicResourceManager man, boolean compress) {
        return this.publishResourcePath(hostName, urlPath, port, man, compress, null);
    }

    static byte[] gzip(byte[] val) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(val.length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            gos.write(val, 0, val.length);
            gos.finish();
            gos.flush();
            bos.flush();
            val = bos.toByteArray();
        }
        finally {
            if (gos != null) {
                gos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return val;
    }

    public Http4K publishResourcePath(String hostName, String urlPath, int port, final DynamicResourceManager man, boolean compress, Function<HttpServerExchange, Boolean> interceptor) {
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        final ResourceHandler handler = new ResourceHandler((ResourceManager)man);
        if (compress) {
            final HttpHandler compressHandler = new EncodingHandler.Builder().build(new HashMap()).wrap((HttpHandler)handler);
            HttpHandler httpHandler = new HttpHandler(){
                volatile byte[] zippedAggregate;

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    String requestPath = exchange.getRequestPath();
                    if (exchange.getRequestMethod() == Methods.GET && !man.isDevMode() && (requestPath.equals("/") || requestPath.equals("") || requestPath.equals("/index.html"))) {
                        Date date;
                        HeaderMap requestHeaders = exchange.getRequestHeaders();
                        String lastMod = requestHeaders.get(Headers.IF_MODIFIED_SINCE, 0);
                        if (lastMod != null && (date = DateUtils.parseDate((String)lastMod)) != null && date.getTime() >= man.getLastModified() - 2000L) {
                            exchange.setResponseCode(304);
                            exchange.endExchange();
                            return;
                        }
                        Resource cacheEntry = man.getCacheEntry("index.html");
                        if (cacheEntry instanceof DynamicResourceManager.MyResource) {
                            if (this.zippedAggregate == null) {
                                this.zippedAggregate = Http4K.gzip(((DynamicResourceManager.MyResource)cacheEntry).getBytes());
                            }
                            exchange.setResponseCode(200);
                            exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                            exchange.getResponseHeaders().put(Headers.LAST_MODIFIED, DateUtils.toDateString((Date)man.getLastModifiedDate()));
                            Sender responseSender = exchange.getResponseSender();
                            responseSender.send(ByteBuffer.wrap(this.zippedAggregate));
                        } else {
                            this.zippedAggregate = null;
                            compressHandler.handleRequest(exchange);
                        }
                    } else {
                        handler.handleRequest(exchange);
                    }
                }
            };
            if (interceptor != null) {
                ((PathHandler)server.car()).addPrefixPath(urlPath, httpExchange -> {
                    boolean apply = (Boolean)interceptor.apply(httpExchange);
                    if (!apply) {
                        httpHandler.handleRequest(httpExchange);
                    }
                });
            } else {
                ((PathHandler)server.car()).addPrefixPath(urlPath, httpHandler);
            }
        } else if (interceptor != null) {
            ((PathHandler)server.car()).addPrefixPath(urlPath, httpExchange -> {
                boolean apply = (Boolean)interceptor.apply(httpExchange);
                if (!apply) {
                    handler.handleRequest(httpExchange);
                }
            });
        } else {
            ((PathHandler)server.car()).addPrefixPath(urlPath, (HttpHandler)handler);
        }
        return this;
    }

    public IPromise<ActorServer> publish(WebSocketPublisher publisher) {
        return publisher.publish();
    }

    public IPromise<ActorServer> publish(HttpPublisher publisher) {
        return publisher.publish();
    }

    public Http4K publishHandler(String hostName, String urlPath, int port, HttpHandler handler) {
        Pair<PathHandler, Undertow> server = this.getServer(port, hostName);
        ((PathHandler)server.car()).addPrefixPath(urlPath, handler);
        return this;
    }

    public Http4K unPublishHandler(String urlPath, int port) {
        Pair<PathHandler, Undertow> server = this.serverMap.get(port);
        if (server != null) {
            ((PathHandler)server.car()).removePrefixPath(urlPath);
        }
        return this;
    }
}

