/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http.undertow;

import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.remoting.base.ActorPublisher;
import org.nustaq.kontraktor.remoting.base.ActorServer;
import org.nustaq.kontraktor.remoting.base.ActorServerConnector;
import org.nustaq.kontraktor.remoting.base.TrafficMonitor;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.undertow.UndertowWebsocketServerConnector;
import org.nustaq.kontraktor.remoting.http.undertow.builder.BldFourK;

public class WebSocketPublisher
implements ActorPublisher {
    BldFourK cfg;
    String hostName;
    String urlPath;
    int port;
    Coding coding = new Coding(SerializerType.FSTSer);
    Actor facade;
    boolean sendStringMessages = false;
    boolean sendSid = false;
    private TrafficMonitor trafficMonitor;

    public WebSocketPublisher() {
    }

    public WebSocketPublisher(Actor facade, String host, String path, int port) {
        this.hostName = host;
        this.urlPath = path;
        this.port = port;
        this.facade = facade;
    }

    public WebSocketPublisher(BldFourK cfgFourK, Actor facade, String hostName, String urlPath, int port) {
        this(facade, hostName, urlPath, port);
        this.cfg = cfgFourK;
    }

    public BldFourK buildWebsocket() {
        return this.cfg;
    }

    public IPromise<ActorServer> publish(Consumer<Actor> disconnectCallback) {
        Promise finished = new Promise();
        try {
            ActorServer publisher = new ActorServer((ActorServerConnector)new UndertowWebsocketServerConnector(this.urlPath, this.port, this.hostName).sendStrings(this.sendStringMessages).sendSid(this.sendSid), this.facade, this.coding);
            this.facade.execute(() -> {
                try {
                    publisher.start(disconnectCallback);
                    finished.resolve((Object)publisher);
                }
                catch (Exception e) {
                    finished.reject((Object)e);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Promise(null, (Object)e);
        }
        return finished;
    }

    public WebSocketPublisher hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public WebSocketPublisher urlPath(String urlPath) {
        this.urlPath = urlPath;
        return this;
    }

    public WebSocketPublisher port(int port) {
        this.port = port;
        return this;
    }

    public WebSocketPublisher coding(Coding coding) {
        this.coding = coding;
        return this;
    }

    public WebSocketPublisher serType(SerializerType tp) {
        return this.coding(new Coding(tp));
    }

    public WebSocketPublisher facade(Actor facade) {
        this.facade = facade;
        return this;
    }

    public void setTrafficMonitor(TrafficMonitor trafficMonitor) {
        this.trafficMonitor = trafficMonitor;
    }

    public WebSocketPublisher sendStringMessages(boolean sendStringMessages) {
        this.sendStringMessages = sendStringMessages;
        return this;
    }

    public WebSocketPublisher cfg(BldFourK cfg) {
        this.cfg = cfg;
        return this;
    }

    public WebSocketPublisher sendSid(boolean sendSid) {
        this.sendSid = sendSid;
        return this;
    }

    public TrafficMonitor getTrafficMonitor() {
        return this.trafficMonitor;
    }
}

