/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.webapp.npm;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kson.Kson;
import org.nustaq.serialization.util.FSTUtil;

public class JNPMConfig
implements Serializable {
    protected Map<String, String> versionMap = new HashMap<String, String>();
    protected Map<String, String> nodeLibraryMap = new HashMap<String, String>();
    protected String repo = "http://registry.npmjs.org/";
    protected String transformFunction = "React.createElement";
    protected Set<String> ignoredDevRequires = new HashSet<String>();
    protected Set<String> ignoredProdRequires = new HashSet<String>();
    protected boolean generatePackageDotJson = true;

    public JNPMConfig() {
        this.versionMap.put("module-name", "^1.2.3");
    }

    public String getVersion(String moduleName) {
        return this.versionMap.get(moduleName);
    }

    public void putVersion(String moduleName, String spec) {
        this.versionMap.put(moduleName, spec);
    }

    public String getTransformFunction() {
        return this.transformFunction;
    }

    public Map<String, String> getVersionMap() {
        return this.versionMap;
    }

    public Map<String, String> getNodeLibraryMap() {
        return this.nodeLibraryMap;
    }

    public String getRepo() {
        return this.repo;
    }

    public static JNPMConfig read() {
        return JNPMConfig.read("./run/etc/jnpm.kson");
    }

    public boolean isGeneratePackageDotJson() {
        return this.generatePackageDotJson;
    }

    public static JNPMConfig read(String pathname) {
        Kson kson = new Kson().map(new Class[]{JNPMConfig.class});
        try {
            JNPMConfig raw = (JNPMConfig)kson.readObject(new File(pathname));
            return raw;
        }
        catch (Exception e) {
            Log.Warn(null, (String)(pathname + " not found or parse error. " + e.getClass().getSimpleName() + ":" + e.getMessage()));
            try {
                String sampleconf = kson.writeObject((Object)new JNPMConfig());
                System.out.println("JNPM Defaulting to:\n" + sampleconf);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                return new JNPMConfig();
            }
            catch (Exception e2) {
                FSTUtil.rethrow((Throwable)e2);
                return null;
            }
        }
    }

    public static void main(String[] args) {
        JNPMConfig.read();
    }

    public Set<String> getIgnoredDevRequires() {
        return this.ignoredDevRequires;
    }

    public Set<String> getIgnoredProdRequires() {
        return this.ignoredProdRequires;
    }

    public JNPMConfig versionMap(Map<String, String> versionMap) {
        this.versionMap = versionMap;
        return this;
    }

    public JNPMConfig repo(String repo) {
        this.repo = repo;
        return this;
    }

    public JNPMConfig transformFunction(String transFormFunction) {
        this.transformFunction = transFormFunction;
        return this;
    }
}

