/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.http;

import java.util.function.Consumer;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.kontraktor.remoting.base.ActorClient;
import org.nustaq.kontraktor.remoting.base.ActorClientConnector;
import org.nustaq.kontraktor.remoting.base.ConnectableActor;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.HttpClientConnector;

public class HttpConnectable
implements ConnectableActor {
    protected Class actorClz;
    protected String url;
    protected Coding coding = new Coding(SerializerType.FSTSer);
    protected Object[] authData;
    protected boolean noPoll = false;
    protected boolean shortPollMode = false;
    protected long shortPollIntervalMS = 5000L;
    protected int inboundQueueSize = SimpleScheduler.DEFQSIZE;

    public HttpConnectable() {
    }

    public HttpConnectable(Class clz, String url) {
        this.actorClz = clz;
        this.url = url;
    }

    public HttpConnectable noPoll(boolean noPoll) {
        this.noPoll = noPoll;
        return this;
    }

    public HttpConnectable shortPoll(boolean shortPollMode) {
        this.shortPollMode = shortPollMode;
        return this;
    }

    public HttpConnectable shortPollIntervalMS(long shortPollIntervalMS) {
        this.shortPollIntervalMS = shortPollIntervalMS;
        return this;
    }

    public HttpConnectable actorClazz(Class clz) {
        this.actorClz = clz;
        return this;
    }

    public HttpConnectable url(String url) {
        this.url = url;
        return this;
    }

    public HttpConnectable coding(Coding coding) {
        this.coding = coding;
        return this;
    }

    public HttpConnectable serType(SerializerType type) {
        this.coding = new Coding(type);
        return this;
    }

    public HttpConnectable authData(Object[] authData) {
        this.authData = authData;
        return this;
    }

    public <T extends Actor> IPromise<T> connect(Callback<ActorClientConnector> disconnectCallback, Consumer<Actor> actorDisconnecCB) {
        HttpClientConnector con = new HttpClientConnector(this);
        con.disconnectCallback = disconnectCallback;
        ActorClient actorClient = new ActorClient((ActorClientConnector)con, this.actorClz, this.coding);
        Promise p = new Promise();
        con.getRefPollActor().execute(() -> {
            Thread.currentThread().setName("Http Ref Polling");
            actorClient.connect(this.inboundQueueSize, null).then((Callback)p);
        });
        return p;
    }

    public ConnectableActor actorClass(Class actorClz) {
        this.actorClz = actorClz;
        return this;
    }

    public Class<? extends Actor> getActorClass() {
        return this.actorClz;
    }

    public Class getActorClz() {
        return this.actorClz;
    }

    public String getUrl() {
        return this.url;
    }

    public Coding getCoding() {
        return this.coding;
    }

    public Object[] getAuthData() {
        return this.authData;
    }

    public boolean isNoPoll() {
        return this.noPoll;
    }

    public boolean isShortPollMode() {
        return this.shortPollMode;
    }

    public long getShortPollIntervalMS() {
        return this.shortPollIntervalMS;
    }

    public HttpConnectable inboundQueueSize(int inboundQSize) {
        this.inboundQueueSize = inboundQSize;
        return this;
    }

    public String getKey() {
        return this.actorClz.getName() + this.url + this.coding;
    }
}

