/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.weblication;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.RemoteConnection;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.annotations.Remoted;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.kontraktor.remoting.base.SessionResurrector;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.weblication.BasicAuthenticationResult;
import org.nustaq.kontraktor.weblication.BasicWebAppConfig;
import org.nustaq.kontraktor.weblication.BasicWebSessionActor;
import org.nustaq.kontraktor.weblication.ISessionStorage;
import org.nustaq.kontraktor.weblication.model.DefaultSessionStorage;

public abstract class BasicWebAppActor<T extends BasicWebAppActor, C extends BasicWebAppConfig>
extends Actor<T>
implements SessionResurrector {
    public static String WEBAPP_DIR = "./src/main/web/client";
    public static String BASH_EXEC = "/usr/bin/bash";
    public static String BABEL_SERVER_JS_PATH = "./node_modules/babelserver/babelserver.js";
    protected Scheduler[] sessionThreads;
    protected ISessionStorage sessionStorage;
    protected Map<String, BasicWebSessionActor> sessions;

    @Local
    public void init(C config) {
        int numSessionThreads = ((BasicWebAppConfig)config).getNumSessionThreads();
        this.sessionThreads = new Scheduler[numSessionThreads];
        for (int i = 0; i < numSessionThreads; ++i) {
            this.sessionThreads[i] = new SimpleScheduler(10000, true);
        }
        this.sessionStorage = this.createSessionStorage(config);
        this.sessions = new HashMap<String, BasicWebSessionActor>();
    }

    protected ISessionStorage createSessionStorage(C config) {
        DefaultSessionStorage defaultSessionStorage = (DefaultSessionStorage)BasicWebAppActor.AsActor(DefaultSessionStorage.class);
        defaultSessionStorage.init(new DefaultSessionStorage.Config()).await();
        return defaultSessionStorage;
    }

    @Remoted
    public IPromise<Object[]> login(String user, String pw, String jwt) {
        Promise res = new Promise();
        RemoteConnection remoteConnection = (RemoteConnection)connection.get();
        this.getCredentials(user, pw, jwt).then((Callback & Serializable)(authres, err) -> {
            if (err != null) {
                res.reject(err);
            } else {
                String sessionId = remoteConnection != null ? remoteConnection.getSocketRef().getConnectionIdentifier() : null;
                this.getSession(user, sessionId, (BasicAuthenticationResult)authres).then((Callback & Serializable)(sess, serr) -> {
                    if (sess != null) {
                        if (sessionId != null && this.sessionStorage != null) {
                            this.sessionStorage.putUserAtSessionId(sessionId, user);
                        }
                        res.resolve((Object)new Object[]{sess, authres});
                    } else {
                        res.complete((Object)sess, serr);
                    }
                });
            }
        });
        return res;
    }

    protected IPromise<BasicAuthenticationResult> getCredentials(String user, String pw, String jwt) {
        Promise p = new Promise();
        this.sessionStorage.getUser(user).then((Callback & Serializable)(rec, err) -> {
            if (rec == null) {
                p.reject((Object)"wrong user or password");
            } else if (pw.equals(rec.getString("pwd"))) {
                if (!rec.getBool("verified")) {
                    p.reject((Object)"account not verified");
                } else {
                    p.resolve((Object)new BasicAuthenticationResult().userName(rec.getKey()));
                }
            }
        });
        return p;
    }

    protected IPromise<BasicWebSessionActor> getSessionForReanimation(String user, String sessionId) {
        return this.getSession(user, sessionId, new BasicAuthenticationResult().userName(user));
    }

    protected IPromise<BasicWebSessionActor> getSession(String user, String sessionId, BasicAuthenticationResult authenticationResult) {
        return this.createSession(user, sessionId, authenticationResult);
    }

    protected IPromise<BasicWebSessionActor> createSession(String user, String sessionId, BasicAuthenticationResult authenticationResult) {
        Promise p = new Promise();
        BasicWebSessionActor sess = (BasicWebSessionActor)BasicWebAppActor.AsActor((Class)this.getSessionClazz(), (Scheduler)this.sessionThreads[(int)(Math.random() * (double)this.sessionThreads.length)]);
        sess.init((BasicWebAppActor)this.self(), authenticationResult, sessionId).then((Callback & Serializable)(res, err) -> {
            if (err == null) {
                this.sessions.put(sessionId, sess);
                authenticationResult.initialData(res);
                p.resolve((Object)sess);
            } else {
                p.reject(err);
            }
        });
        return p;
    }

    protected abstract Class getSessionClazz();

    @Local
    public void restoreRemoteRefConnection(String sessionId) {
        Log.Info((Object)((Object)this), (String)("try reanimating " + sessionId));
    }

    @Local
    public IPromise<Actor> reanimate(String sessionId, long remoteRefId) {
        if (this.sessionStorage == null) {
            return BasicWebAppActor.resolve(null);
        }
        Promise res = new Promise();
        this.sessionStorage.getUserFromSessionId(sessionId).then((Callback & Serializable)(user, err) -> {
            if (user == null) {
                res.resolve(null);
            } else {
                this.getSessionForReanimation((String)user, sessionId).then((Callback)res);
            }
        });
        return res;
    }

    @Local
    public void notifySessionEnd(BasicWebSessionActor session) {
        this.sessions.remove(session.getSessionId());
        Log.Info((Object)((Object)this), (String)("session timed out " + session.getSessionId() + " " + session.getUserKey() + " sessions:" + this.sessions.size()));
    }

    @CallerSideMethod
    public ISessionStorage getSessionStorage() {
        return ((BasicWebAppActor)this.getActor()).sessionStorage;
    }

    public void handleDirectRequest(HttpServerExchange exchange) {
        Log.Info((Object)((Object)this), (String)("direct request received " + exchange));
        this.getDirectRequestResponse(exchange.getRequestPath()).then((Callback & Serializable)(s, err) -> {
            exchange.setResponseCode(200);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html; charset=utf-8");
            exchange.getResponseSender().send(s == null ? "" + err : s);
        });
    }

    protected IPromise<String> getDirectRequestResponse(String path) {
        return new Promise((Object)("Hey there " + path));
    }
}

