/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.weblication;

import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.remoting.base.RemotedActor;
import org.nustaq.kontraktor.weblication.BasicAuthenticationResult;
import org.nustaq.kontraktor.weblication.BasicWebAppActor;
import org.nustaq.kontraktor.weblication.ISessionStorage;

public abstract class BasicWebSessionActor<T extends BasicWebSessionActor>
extends Actor<T>
implements RemotedActor {
    protected BasicWebAppActor app;
    protected String userKey;
    protected String sessionId;

    @Local
    public IPromise init(BasicWebAppActor app, BasicAuthenticationResult user, String sessionId) {
        this.app = app;
        this.userKey = user.getUserKey();
        this.sessionId = sessionId;
        return this.loadSessionData(sessionId, this.getSessionStorage());
    }

    @CallerSideMethod
    public String getSessionId() {
        return ((BasicWebSessionActor)this.getActor()).sessionId;
    }

    @CallerSideMethod
    public String getUserKey() {
        return ((BasicWebSessionActor)this.getActor()).userKey;
    }

    public void hasBeenUnpublished() {
        this.app.notifySessionEnd((BasicWebSessionActor)this.self());
        ISessionStorage storage = this.app.getSessionStorage();
        this.persistSessionData(this.sessionId, storage);
    }

    protected abstract void persistSessionData(String var1, ISessionStorage var2);

    protected abstract IPromise loadSessionData(String var1, ISessionStorage var2);

    protected ISessionStorage getSessionStorage() {
        return this.app.getSessionStorage();
    }
}

