/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.weblication;

import io.undertow.server.HttpServerExchange;
import java.io.File;
import java.io.IOException;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.babel.BabelOpts;
import org.nustaq.kontraktor.babel.BrowseriBabelify;
import org.nustaq.kontraktor.babel.JSXTranspiler;
import org.nustaq.kontraktor.remoting.encoding.Coding;
import org.nustaq.kontraktor.remoting.encoding.SerializerType;
import org.nustaq.kontraktor.remoting.http.javascript.TranspilerHook;
import org.nustaq.kontraktor.remoting.http.undertow.Http4K;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.weblication.BasicWebAppActor;
import org.nustaq.kontraktor.weblication.BasicWebAppConfig;

public class UndertowWebServerMain {
    public boolean runNodify() {
        try {
            BrowseriBabelify.get();
        }
        catch (Exception ex) {
            Log.Warn(BasicWebAppActor.class, (String)"babelserver not running .. try starting");
            boolean isWindows = System.getProperty("os.name", "linux").toLowerCase().indexOf("windows") >= 0;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                if (isWindows) {
                    processBuilder.command("cmd.exe", "/c", "node " + BasicWebAppActor.BABEL_SERVER_JS_PATH);
                } else {
                    String bash = BasicWebAppActor.BASH_EXEC;
                    if (!new File(bash).exists()) {
                        bash = "/bin/bash";
                    }
                    processBuilder.command(bash, "-c", "node " + BasicWebAppActor.BABEL_SERVER_JS_PATH);
                }
                processBuilder.directory(new File(BasicWebAppActor.WEBAPP_DIR));
                processBuilder.inheritIO();
                Process process = processBuilder.start();
                for (int i = 0; i < 8; ++i) {
                    Thread.sleep(500L);
                    System.out.print('.');
                    try {
                        BrowseriBabelify.get();
                        break;
                    }
                    catch (Exception e) {
                        if (i != 3) continue;
                        e.printStackTrace();
                        continue;
                    }
                }
                System.out.println();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public BasicWebAppActor reactMainHelper(Class<? extends BasicWebAppActor> myHttpAppClass, BasicWebAppConfig cfg) throws IOException {
        boolean DEV = cfg.getDev();
        this.checkBabelService();
        File root = new File(cfg.getClientRoot());
        this.checkWorkingDir(root);
        BasicWebAppActor myHttpApp = this.setupAppActor(myHttpAppClass, cfg);
        this.setupUndertow4K_React(cfg, DEV, myHttpApp);
        return myHttpApp;
    }

    protected void setupUndertow4K_React(BasicWebAppConfig cfg, boolean DEV, BasicWebAppActor myHttpApp) {
        Class[] msgClasses = cfg.getMessageClasses();
        Http4K.Build((String)cfg.getHost(), (int)cfg.getPort()).fileRoot(cfg.getStaticUrlPrefix(), cfg.getStaticFileRoot()).resourcePath("/").elements(new String[]{cfg.getClientRoot(), cfg.getClientRoot() + "/node_modules"}).allDev(DEV).transpile("jsx", (TranspilerHook)new JSXTranspiler().opts(new BabelOpts().debug(DEV))).handlerInterceptor(exchange -> {
            String requestPath = exchange.getRequestPath();
            if (requestPath == null || !requestPath.startsWith(this.getRawRequestUrlPrefix())) {
                return false;
            }
            exchange.dispatch();
            myHttpApp.handleDirectRequest((HttpServerExchange)exchange);
            return true;
        }).build().httpAPI(this.getApiEndpointUrlPath(), (Actor)myHttpApp).coding(new Coding(SerializerType.JsonNoRef, msgClasses)).setSessionTimeout(cfg.getSessionTimeoutMS()).build().build();
    }

    protected String getApiEndpointUrlPath() {
        return "/ep";
    }

    protected String getRawRequestUrlPrefix() {
        return "/direct/";
    }

    protected BasicWebAppActor setupAppActor(Class<? extends BasicWebAppActor> myHttpAppClass, BasicWebAppConfig cfg) {
        BasicWebAppActor myHttpApp = (BasicWebAppActor)Actors.AsActor(myHttpAppClass);
        myHttpApp.init(cfg);
        return myHttpApp;
    }

    protected void checkWorkingDir(File root) {
        if (!new File(root, "index.html").exists()) {
            System.out.println("Please run with working dir: '[..]examples/react");
            System.exit(2);
        }
    }

    protected void checkBabelService() {
        if (!this.runNodify()) {
            System.out.println("failed to connect / start babel");
            System.exit(1);
        }
    }
}

