/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.weblication.model;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.kontraktor.weblication.ISessionStorage;
import org.nustaq.reallive.api.RLFunction;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.client.EmbeddedRealLive;
import org.nustaq.reallive.records.MapRecord;

public class DefaultSessionStorage
extends Actor<DefaultSessionStorage>
implements ISessionStorage {
    RealLiveTable sessionId2UserKey;
    RealLiveTable userData;

    public IPromise init(Config cfg) {
        try {
            String dataDir = cfg.getDataDir();
            new File(dataDir).mkdirs();
            this.sessionId2UserKey = EmbeddedRealLive.get().createTable(new TableDescription().keyLen(64).sizeMB(cfg.getSizeSessionIdsMB()).name("sessionid2userkey").type(TableDescription.StorageType.PERSIST), dataDir);
            this.userData = EmbeddedRealLive.get().createTable(new TableDescription().keyLen(64).sizeMB(cfg.getSizeSessionIdsMB()).name("userdata").type(TableDescription.StorageType.PERSIST), dataDir);
        }
        catch (Exception e) {
            Log.Warn((Object)this, (Throwable)e);
            return new Promise(null, (Object)e);
        }
        return new Promise((Object)true);
    }

    @Override
    public IPromise<String> createToken(ISessionStorage.Token t) {
        String key = UUID.randomUUID().toString();
        this.sessionId2UserKey.setRecord((Record)MapRecord.New((String)key).put("lifeTime", (Object)(System.currentTimeMillis() + t.getLifeTime())).put("userId", (Object)t.getUserId()).put("data", (Object)t.getData()));
        return DefaultSessionStorage.resolve((Object)key);
    }

    @Override
    public IPromise<ISessionStorage.Token> takeToken(String tokenId, boolean delete) {
        Promise p = new Promise();
        this.sessionId2UserKey.atomic(tokenId, (RLFunction & Serializable)r -> {
            if (r != null) {
                if (r.getLong("lifeTime") > System.currentTimeMillis()) {
                    if (delete) {
                        this.sessionId2UserKey.remove(tokenId);
                    }
                    return new ISessionStorage.Token(r.getString("userId"), r.getString("data"), r.getLong("lifeTime"));
                }
                this.sessionId2UserKey.remove(tokenId);
            }
            return null;
        }).then((Callback)p);
        return p;
    }

    @Override
    public IPromise<String> getUserFromSessionId(String sid) {
        Promise p = new Promise();
        this.sessionId2UserKey.get(sid).then((Callback & Serializable)(rec, err) -> {
            if (rec != null) {
                p.resolve((Object)rec.getString("user"));
            } else {
                p.complete(rec, err);
            }
        });
        return p;
    }

    @Override
    public void putUserAtSessionId(String sessionId, String userKey) {
        this.sessionId2UserKey.merge(sessionId, new Object[]{"user", userKey});
    }

    @Override
    public void putUser(Record userRecord) {
        this.userData.setRecord(userRecord);
    }

    @Override
    public void delUser(String userkey) {
        this.userData.remove(userkey);
    }

    @Override
    public IPromise<Boolean> putUserIfNotPresent(Record userRecord) {
        Promise p = DefaultSessionStorage.promise();
        this.userData.addRecord(userRecord).then((Callback)p);
        return p;
    }

    @Override
    public IPromise<Record> getUser(String userId) {
        return this.userData.get(userId);
    }

    @Override
    public void forEachUser(Callback<Record> cb) {
        this.userData.forEach((RLPredicate & Serializable)rec -> true, cb);
    }

    public static class Config
    implements Serializable {
        int sizeSessionIdsMB = 1024;
        int sizeUserDataMB = 1024;
        String dataDir = "./run/data/";

        public int getSizeSessionIdsMB() {
            return this.sizeSessionIdsMB;
        }

        public String getDataDir() {
            return this.dataDir;
        }

        public Config sizeSessionIdMB(int sizeGB) {
            this.sizeSessionIdsMB = sizeGB;
            return this;
        }

        public int getSizeUserDataMB() {
            return this.sizeUserDataMB;
        }

        public Config sizeSessionIdsMB(int sizeSessionIdsGB) {
            this.sizeSessionIdsMB = sizeSessionIdsGB;
            return this;
        }

        public Config sizeUserDataMB(int sizeUserDataGB) {
            this.sizeUserDataMB = sizeUserDataGB;
            return this;
        }

        public Config dataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }
    }
}

