/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor;

import de.ruedigermoeller.kontraktor.ActorProxy;
import de.ruedigermoeller.kontraktor.ActorRunnable;
import de.ruedigermoeller.kontraktor.Actors;
import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.annotations.CallerSideMethod;
import de.ruedigermoeller.kontraktor.impl.ActorProxyFactory;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class Actor {
    public Actor __self;
    DispatcherThread dispatcher;
    protected ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();

    public DispatcherThread getDispatcher() {
        if (this.__self == null) {
            return this.getActor().getDispatcher();
        }
        return this.dispatcher;
    }

    protected <T extends Actor> T self() {
        return (T)this.__self;
    }

    public ActorProxyFactory getFactory() {
        return Actors.instance.getFactory();
    }

    public Actor getActor() {
        return this;
    }

    @CallerSideMethod
    public void stop() {
        this.getDispatcher().actorStopped(this);
    }

    public <T> void executeInActorThread(ActorRunnable<T> toRun, Callback<T> cb) {
        toRun.run(this.getActorAccess(), this.getActor(), cb);
    }

    protected Object getActorAccess() {
        return null;
    }

    @CallerSideMethod
    public void __dispatcher(DispatcherThread d) {
        this.dispatcher = d;
    }

    @CallerSideMethod
    public void __dispatchCall(ActorProxy receiver, String methodName, Object[] args) {
        Method method = this.methodCache.get(methodName);
        Actor actor = receiver.getActor();
        if (method == null) {
            Method[] methods = actor.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodName)) continue;
                this.methodCache.put(methodName, m);
                method = m;
                break;
            }
        }
        int count = 0;
        while (actor.getDispatcher().dispatch(receiver, method, args)) {
            DispatcherThread.yield(count++);
        }
    }
}

