/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor;

import de.ruedigermoeller.kontraktor.Actor;
import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.impl.ActorProxyFactory;
import de.ruedigermoeller.kontraktor.impl.CallbackWrapper;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Actors {
    static Actors instance = new Actors();
    protected ExecutorService exec = Executors.newCachedThreadPool();
    protected ActorProxyFactory factory = new ActorProxyFactory();

    public static void SetDefaultQueueSize(int siz) {
        DispatcherThread.DEFAULT_QUEUE_SIZE = siz;
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz) {
        return (T)instance.newProxy(actorClazz, -1);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, int qSize) {
        return (T)instance.newProxy(actorClazz, qSize);
    }

    public static <T> T InThread(T callback) {
        Class<?>[] interfaces = callback.getClass().getInterfaces();
        InvocationHandler invoker = DispatcherThread.getThreadDispatcher().getInvoker(callback);
        if (invoker == null) {
            return callback;
        }
        return (T)Proxy.newProxyInstance(callback.getClass().getClassLoader(), interfaces, invoker);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, DispatcherThread disp) {
        return (T)instance.newProxy(actorClazz, disp);
    }

    public static <T extends Actor> T SpawnActor(Class<? extends Actor> actorClazz) {
        return (T)instance.newProxy(actorClazz, instance.newDispatcher(-1));
    }

    public static <T extends Actor> T SpawnActor(Class<? extends Actor> actorClazz, int qSiz) {
        return (T)instance.newProxy(actorClazz, instance.newDispatcher(qSiz));
    }

    public static <T> void Execute(Callable<T> toCall, Callback<T> resultHandler) {
        instance.runBlockingCall(toCall, resultHandler);
    }

    protected Actors() {
    }

    protected ActorProxyFactory getFactory() {
        return this.factory;
    }

    protected <T> void runBlockingCall(final Callable<T> toCall, Callback<T> resultHandler) {
        final CallbackWrapper<T> resultWrapper = new CallbackWrapper<T>(DispatcherThread.getThreadDispatcher(), resultHandler);
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    resultWrapper.receiveResult(toCall.call(), null);
                }
                catch (Throwable th) {
                    resultWrapper.receiveResult(null, th);
                }
            }
        });
    }

    protected Actor newProxy(Class<? extends Actor> clz, DispatcherThread disp) {
        try {
            Actor res = clz.newInstance();
            res.dispatcher = disp;
            Actor proxy = (Actor)this.getFactory().instantiateProxy(res);
            disp.actorAdded(res);
            return proxy;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected Actor newProxy(Class<? extends Actor> clz, int qsize) {
        if (DispatcherThread.getThreadDispatcher() != null) {
            return this.newProxy(clz, DispatcherThread.getThreadDispatcher());
        }
        try {
            return this.newProxy(clz, this.newDispatcher(qsize));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected DispatcherThread newDispatcher(int qSize) {
        return new DispatcherThread(qSize);
    }
}

