/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor;

import de.ruedigermoeller.kontraktor.Actor;
import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.Promise;
import de.ruedigermoeller.kontraktor.impl.ActorProxyFactory;
import de.ruedigermoeller.kontraktor.impl.CallbackWrapper;
import de.ruedigermoeller.kontraktor.impl.DispatcherThread;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Actors {
    static Actors instance = new Actors();
    protected ExecutorService exec = Executors.newCachedThreadPool();
    protected Timer delayedCalls = new Timer();
    protected ActorProxyFactory factory = new ActorProxyFactory();

    public static void SetDefaultQueueSize(int siz) {
        DispatcherThread.DEFAULT_QUEUE_SIZE = siz;
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz) {
        return (T)instance.newProxy(actorClazz, -1);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, int qSize) {
        return (T)instance.newProxy(actorClazz, qSize);
    }

    public static <T> T InThread(T callback) {
        Class<?>[] interfaces = callback.getClass().getInterfaces();
        InvocationHandler invoker = DispatcherThread.getThreadDispatcher().getInvoker(callback);
        if (invoker == null) {
            return callback;
        }
        return (T)Proxy.newProxyInstance(callback.getClass().getClassLoader(), interfaces, invoker);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, DispatcherThread disp) {
        return (T)instance.newProxy(actorClazz, disp);
    }

    public static <T extends Actor> T SpawnActor(Class<? extends Actor> actorClazz) {
        return (T)instance.newProxy(actorClazz, instance.newDispatcher(-1));
    }

    public static <T extends Actor> T $$(Class<T> clz) {
        try {
            Actor seqproxy = (Actor)instance.getFactory().instantiateProxy((Actor)clz.newInstance());
            seqproxy.__isSeq = true;
            return (T)seqproxy;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Actor> T SpawnActor(Class<? extends Actor> actorClazz, int qSiz) {
        return (T)instance.newProxy(actorClazz, instance.newDispatcher(qSiz));
    }

    public static <T> Future<T> Async(Callable<T> toCall) {
        Promise prom = new Promise();
        instance.runBlockingCall(toCall, prom);
        return prom;
    }

    public static <T> void Delayed(int millis, Runnable toRun) {
        instance.delayedCall(millis, toRun);
    }

    public static Future<Future[]> Yield(Future ... futures) {
        Promise<Future[]> res = new Promise<Future[]>();
        Actors.Yield(futures, 0, res);
        return res;
    }

    private static void Yield(final Future[] futures, final int index, final Future result) {
        if (index < futures.length) {
            futures[index].then(new Callback(){

                public void receiveResult(Object res, Object error) {
                    Actors.Yield(futures, index + 1, result);
                }
            });
        } else {
            result.receiveResult(futures, null);
        }
    }

    protected Actors() {
    }

    protected ActorProxyFactory getFactory() {
        return this.factory;
    }

    protected <T> void delayedCall(int millis, final Runnable toRun) {
        this.delayedCalls.schedule(new TimerTask(){

            @Override
            public void run() {
                toRun.run();
            }
        }, millis);
    }

    protected <T> void runBlockingCall(final Callable<T> toCall, Callback<T> resultHandler) {
        final CallbackWrapper<T> resultWrapper = new CallbackWrapper<T>(DispatcherThread.getThreadDispatcher(), resultHandler);
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    resultWrapper.receiveResult(toCall.call(), null);
                }
                catch (Throwable th) {
                    resultWrapper.receiveResult(null, th);
                }
            }
        });
    }

    protected Actor newProxy(Class<? extends Actor> clz, DispatcherThread disp) {
        try {
            Actor selfproxy;
            Actor realActor = clz.newInstance();
            realActor.__dispatcher = disp;
            realActor.__self = selfproxy = (Actor)this.getFactory().instantiateProxy(realActor);
            Actor seqproxy = (Actor)this.getFactory().instantiateProxy(realActor);
            seqproxy.__isSeq = true;
            realActor.__seq = seqproxy;
            selfproxy.__seq = seqproxy;
            disp.actorAdded(realActor);
            return selfproxy;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected Actor newProxy(Class<? extends Actor> clz, int qsize) {
        if (DispatcherThread.getThreadDispatcher() != null) {
            return this.newProxy(clz, DispatcherThread.getThreadDispatcher());
        }
        try {
            return this.newProxy(clz, this.newDispatcher(qsize));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected DispatcherThread newDispatcher(int qSize) {
        return new DispatcherThread(qSize);
    }
}

