/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.kontraktor.util;

import de.ruedigermoeller.kontraktor.Callback;
import de.ruedigermoeller.kontraktor.Future;
import de.ruedigermoeller.kontraktor.Promise;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class TicketMachine {
    HashMap<Object, List<Ticket>> tickets = new HashMap();

    public Future<Future> getTicket(final Object channelKey) {
        List<Ticket> futures = this.tickets.get(channelKey);
        if (futures == null) {
            futures = new LinkedList<Ticket>();
            this.tickets.put(channelKey, futures);
        }
        Promise signalFin = new Promise();
        Promise<Future> signalStart = new Promise<Future>();
        final Ticket ticket = new Ticket(signalStart, signalFin);
        futures.add(ticket);
        final List<Ticket> finalFutures = futures;
        signalFin.then(new Callback(){

            public void receiveResult(Object result, Object error) {
                boolean remove = finalFutures.remove(ticket);
                if (!remove) {
                    System.err.println("Error failed to remove " + channelKey);
                }
                TicketMachine.this.checkNext(channelKey, finalFutures, ticket);
            }
        });
        if (futures.size() == 1) {
            signalStart.receiveResult(signalFin, null);
        }
        return signalStart;
    }

    private void checkNext(Object channelKey, List<Ticket> futures, Ticket ticket) {
        if (futures.size() == 0) {
            this.tickets.remove(channelKey);
        } else {
            Ticket nextTicket = futures.get(0);
            nextTicket.signalProcessingStart.receiveResult(nextTicket.signalProcessingFinished, null);
        }
    }

    public HashMap<Object, List<Ticket>> getTickets() {
        return this.tickets;
    }

    static class Ticket {
        Future signalProcessingStart;
        Future signalProcessingFinished;

        Ticket(Future signalProcessingStart, Future signalProcessingFinished) {
            this.signalProcessingStart = signalProcessingStart;
            this.signalProcessingFinished = signalProcessingFinished;
        }
    }
}

