/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor;

import io.jaq.mpsc.MpscConcurrentQueue;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.Scheduler;
import org.nustaq.kontraktor.impl.ActorProxyFactory;
import org.nustaq.kontraktor.impl.DispatcherThread;
import org.nustaq.kontraktor.impl.ElasticScheduler;
import org.nustaq.kontraktor.util.Log;

public class Actors {
    public static Actors instance = new Actors();
    ConcurrentLinkedQueue deadLetters = new ConcurrentLinkedQueue();
    protected ActorProxyFactory factory = new ActorProxyFactory();

    public static void AddDeadLetter(String s) {
        Log.Lg.warn(null, s);
        Actors.DeadLetters().add(s);
    }

    public static ConcurrentLinkedQueue<String> DeadLetters() {
        return Actors.instance.deadLetters;
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz) {
        return (T)instance.newProxy(actorClazz, new ElasticScheduler(1), -1);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, int qSize) {
        return (T)instance.newProxy(actorClazz, new ElasticScheduler(1), qSize);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, Scheduler scheduler) {
        return (T)instance.newProxy(actorClazz, scheduler, -1);
    }

    public static <T extends Actor> T AsActor(Class<? extends Actor> actorClazz, Scheduler scheduler, int qsize) {
        return (T)instance.newProxy(actorClazz, scheduler, qsize);
    }

    public static Future<Future[]> yield(Future ... futures) {
        Promise<Future[]> res = new Promise<Future[]>();
        Actors.yield(futures, 0, res);
        return res;
    }

    public static Future<List<Future>> yield(List<Future> futures) {
        Promise<List<Future>> res = new Promise<List<Future>>();
        Actors.yield(futures, 0, res);
        return res;
    }

    public static Future<Future[]> async(Callable<Future> ... toexec) {
        return Actors.ordered(toexec, 0);
    }

    private static Future ordered(Callable<Future>[] callables, int index) {
        try {
            if (index == callables.length - 1) {
                return callables[index].call();
            }
            Future res = callables[index].call();
            if (res != null) {
                Promise p = new Promise();
                res.then(() -> Actors.ordered(callables, index + 1).then(p));
                return p;
            }
            return Actors.ordered(callables, index + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Promise<Object>(null, e);
        }
    }

    private static void yield(Future[] futures, int index, Future result) {
        if (index < futures.length) {
            futures[index].then((r, e) -> Actors.yield(futures, index + 1, result));
        } else {
            result.receive(futures, null);
        }
    }

    private static void yield(List<Future> futures, int index, Future result) {
        if (index < futures.size()) {
            futures.get(index).then((r, e) -> Actors.yield(futures, index + 1, result));
        } else {
            result.receive(futures, null);
        }
    }

    protected Actors() {
    }

    public ActorProxyFactory getFactory() {
        return this.factory;
    }

    protected Actor makeProxy(Class<? extends Actor> clz, DispatcherThread disp, int qs) {
        try {
            Actor selfproxy;
            if (qs <= 100) {
                qs = disp.getScheduler().getDefaultQSize();
            }
            Actor realActor = clz.newInstance();
            realActor.__mailbox = this.createQueue(qs);
            realActor.__mbCapacity = ((MpscConcurrentQueue)realActor.__mailbox).getCapacity();
            realActor.__cbQueue = this.createQueue(qs);
            realActor.__self = selfproxy = (Actor)this.getFactory().instantiateProxy(realActor);
            selfproxy.__self = selfproxy;
            selfproxy.__mailbox = realActor.__mailbox;
            selfproxy.__mbCapacity = realActor.__mbCapacity;
            selfproxy.__cbQueue = realActor.__cbQueue;
            realActor.__scheduler = disp.getScheduler();
            selfproxy.__scheduler = disp.getScheduler();
            realActor.__currentDispatcher = disp;
            selfproxy.__currentDispatcher = disp;
            disp.addActor(realActor);
            return selfproxy;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected Queue createQueue(int qSize) {
        return new MpscConcurrentQueue(qSize);
    }

    protected Actor newProxy(Class<? extends Actor> clz, Scheduler sched, int qsize) {
        if (sched == null && Thread.currentThread() instanceof DispatcherThread) {
            sched = ((DispatcherThread)Thread.currentThread()).getScheduler();
        }
        try {
            if (sched == null) {
                sched = new ElasticScheduler(1, qsize);
            }
            if (qsize < 1) {
                qsize = sched.getDefaultQSize();
            }
            return this.makeProxy(clz, sched.assignDispatcher(70), qsize);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Object[] toResults(Future[] futs) {
        Object[] o = new Object[futs.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = futs[i].getResult();
        }
        return o;
    }
}

