/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.impl;

import java.lang.reflect.Method;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Future;
import org.nustaq.kontraktor.Message;

public class CallEntry<T>
implements Message<T> {
    private final Method method;
    private final Object[] args;
    private Future futureCB;
    private final transient T target;
    private transient Actor sendingActor;
    private transient Actor targetActor;
    private transient boolean onCBQueue;

    public CallEntry(T target, Method method, Object[] args, Actor sender, Actor targetActor, boolean isCB) {
        this.target = target;
        this.method = method;
        this.args = args;
        this.sendingActor = sender;
        this.targetActor = targetActor;
        this.onCBQueue = isCB;
    }

    public Actor getTargetActor() {
        return this.targetActor;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public Actor getSendingActor() {
        return this.sendingActor;
    }

    public boolean hasFutureResult() {
        return this.method.getReturnType() == Future.class;
    }

    public void setFutureCB(Future futureCB) {
        this.futureCB = futureCB;
    }

    public Future getFutureCB() {
        return this.futureCB;
    }

    public String toString() {
        return "CallEntry{method=" + this.method.getName() + ", futureCB=" + this.futureCB + ", target=" + this.target + ", sendingActor=" + this.sendingActor + ", targetActor=" + this.targetActor + ", onCBQueue=" + this.onCBQueue + '}';
    }

    public boolean isCallback() {
        return this.onCBQueue;
    }
}

