/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kontraktor.remoting.minbingen;

import java.util.Collection;
import java.util.Map;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.remoting.minbingen.GenClazzInfo;
import org.nustaq.serialization.FSTClazzInfo;

public class GenContext {
    public GenClazzInfo[] clazzInfos;

    public String getJSTransform(FSTClazzInfo.FSTFieldInfo fi) {
        Class fieldType = fi.getType();
        return this.getJSTransform("this." + fi.getField().getName(), fieldType);
    }

    public String getJSTransform(String fieldName, Class fieldType) {
        boolean isIntegral;
        String res = "";
        boolean isArray = fieldType.isArray();
        boolean bl = isIntegral = fieldType.isPrimitive() || isArray && fieldType.getComponentType().isPrimitive();
        if (!isIntegral && isArray) {
            res = res + "MinBin.jarray(" + fieldName + ")";
        } else if (Map.class.isAssignableFrom(fieldType)) {
            res = res + "MinBin.jmap(" + fieldName + ")";
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            res = res + "MinBin.jlist(" + fieldName + ")";
        } else if (isArray && isIntegral) {
            int integralCode = FSTClazzInfo.FSTFieldInfo.getIntegralCode(fieldType.getComponentType());
            switch (integralCode) {
                case 1: {
                    res = res + fieldName + "?1:0";
                    break;
                }
                case 2: {
                    res = res + "MinBin.i8(" + fieldName + ")";
                    break;
                }
                case 3: {
                    res = res + "MinBin.ui16(" + fieldName + ")";
                    break;
                }
                case 4: {
                    res = res + "MinBin.i16(" + fieldName + ")";
                    break;
                }
                case 5: {
                    res = res + "MinBin.i32(" + fieldName + ")";
                    break;
                }
                case 6: {
                    res = res + "MinBin.i64(" + fieldName + ")";
                    break;
                }
                case 7: {
                    res = res + "MinBin.dbl(" + fieldName + ")";
                    break;
                }
                case 8: {
                    res = res + "MinBin.dbl(" + fieldName + ")";
                    break;
                }
                default: {
                    throw new RuntimeException("wat? " + integralCode);
                }
            }
        } else if (fieldType == String[].class) {
            res = res + "MinBin.strArr(" + fieldName + ")";
        } else if (isIntegral && !isArray) {
            int integralCode = FSTClazzInfo.FSTFieldInfo.getIntegralCode((Class)fieldType);
            switch (integralCode) {
                case 1: {
                    res = res + fieldName + "?1:0";
                    break;
                }
                case 2: {
                    res = res + "MinBin.parseIntOrNan(" + fieldName + ", 'byte' )";
                    break;
                }
                case 3: {
                    res = res + "MinBin.parseIntOrNan(" + fieldName + ", 'char' )";
                    break;
                }
                case 4: {
                    res = res + "MinBin.parseIntOrNan(" + fieldName + ", 'short' )";
                    break;
                }
                case 5: {
                    res = res + "MinBin.parseIntOrNan(" + fieldName + ", 'int' )";
                    break;
                }
                case 6: {
                    res = res + "MinBin.parseIntOrNan(" + fieldName + ", 'int' )";
                    break;
                }
                default: {
                    res = res + fieldName;
                    break;
                }
            }
        } else {
            res = !Number.class.isAssignableFrom(fieldType) && !String.class.isAssignableFrom(fieldType) && !Character.class.isAssignableFrom(fieldType) && !Callback.class.isAssignableFrom(fieldType) ? res + "MinBin.obj('" + fieldType.getSimpleName() + "'," + fieldName + ")" : res + fieldName;
        }
        res = res + "";
        return res;
    }
}

