/*
 * Decompiled with CFR 0.152.
 */
package com.lukehutch.fastclasspathscanner;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FastClasspathScanner {
    private String[] pathsToScan;
    private long lastModified = 0L;
    private ArrayList<ClassMatcher> classMatchers = new ArrayList();
    private ArrayList<FilePathMatcher> filePathMatchers = new ArrayList();
    private final HashMap<String, ClassInfo> classNameToClassInfo = new HashMap();
    private final HashMap<String, InterfaceInfo> interfaceNameToInterfaceInfo = new HashMap();
    private final HashMap<String, ArrayList<String>> annotationToClasses = new HashMap();
    private final HashMap<String, ArrayList<String>> interfaceToClasses = new HashMap();

    public FastClasspathScanner(String[] pacakagesToScan) {
        this.pathsToScan = (String[])Stream.of(pacakagesToScan).map(p -> p.replace('.', '/') + "/").toArray(String[]::new);
    }

    public <T> FastClasspathScanner matchSubclassesOf(Class<T> superclass, SubclassMatchProcessor<T> classMatchProcessor) {
        if (superclass.isInterface()) {
            throw new IllegalArgumentException(superclass.getName() + " is an interface, not a regular class");
        }
        if (superclass.isAnnotation()) {
            throw new IllegalArgumentException(superclass.getName() + " is an annotation, not a regular class");
        }
        this.classMatchers.add(() -> {
            ClassInfo superclassInfo = this.classNameToClassInfo.get(superclass.getName());
            boolean foundMatches = false;
            if (superclassInfo != null) {
                for (ClassInfo subclassInfo : superclassInfo.allSubclasses) {
                    try {
                        Class<?> klass = Class.forName(subclassInfo.name);
                        classMatchProcessor.processMatch(klass);
                        foundMatches = true;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (!foundMatches) {
                // empty if block
            }
        });
        return this;
    }

    public <T> FastClasspathScanner matchClassesImplementing(Class<T> iface, InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface.getName() + " is not an interface");
        }
        this.classMatchers.add(() -> {
            ArrayList<String> classesImplementingIface = this.interfaceToClasses.get(iface.getName());
            if (classesImplementingIface != null) {
                for (String implClass : classesImplementingIface) {
                    try {
                        Class<?> klass = Class.forName(implClass);
                        interfaceMatchProcessor.processMatch(klass);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchClassesWithAnnotation(Class<?> annotation, ClassAnnotationMatchProcessor classMatchProcessor) {
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotation.getName() + " is not an annotation");
        }
        this.classMatchers.add(() -> {
            ArrayList<String> classesWithAnnotation = this.annotationToClasses.get(annotation.getName());
            if (classesWithAnnotation != null) {
                for (String classWithAnnotation : classesWithAnnotation) {
                    try {
                        Class<?> klass = Class.forName(classWithAnnotation);
                        classMatchProcessor.processMatch(klass);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String filenameMatchPattern, FileMatchProcessor fileMatchProcessor) {
        this.filePathMatchers.add(new FilePathMatcher(Pattern.compile(filenameMatchPattern), fileMatchProcessor));
        return this;
    }

    private static void finalizeClassHierarchyRec(ClassInfo curr) {
        for (ClassInfo subclass : curr.directSubclasses) {
            FastClasspathScanner.finalizeClassHierarchyRec(subclass);
        }
        for (ClassInfo subclass : curr.directSubclasses) {
            curr.allSubclasses.addAll(subclass.allSubclasses);
        }
    }

    private void finalizeInterfaceHierarchyRec(InterfaceInfo interfaceInfo) {
        if (interfaceInfo.allSuperInterfaces.isEmpty() && !interfaceInfo.superInterfaces.isEmpty()) {
            interfaceInfo.allSuperInterfaces.addAll(interfaceInfo.superInterfaces);
            for (String iface : interfaceInfo.superInterfaces) {
                InterfaceInfo superinterfaceInfo = this.interfaceNameToInterfaceInfo.get(iface);
                if (superinterfaceInfo == null) continue;
                this.finalizeInterfaceHierarchyRec(superinterfaceInfo);
                interfaceInfo.allSuperInterfaces.addAll(superinterfaceInfo.allSuperInterfaces);
            }
        }
    }

    private void finalizeClassHierarchy() {
        if (this.classNameToClassInfo.isEmpty() && this.interfaceNameToInterfaceInfo.isEmpty()) {
            return;
        }
        ArrayList<ClassInfo> roots = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.directSuperclass != null) continue;
            roots.add(classInfo);
        }
        LinkedList<ClassInfo> nodes = new LinkedList<ClassInfo>();
        nodes.addAll(roots);
        while (!nodes.isEmpty()) {
            ClassInfo head = (ClassInfo)nodes.removeFirst();
            if (head.directSuperclass != null) {
                head.allSuperclasses.addAll(head.directSuperclass.allSuperclasses);
            }
            for (ClassInfo classInfo : head.directSubclasses) {
                nodes.add(classInfo);
            }
        }
        for (ClassInfo root : roots) {
            FastClasspathScanner.finalizeClassHierarchyRec(root);
        }
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            for (String string : classInfo.annotations) {
                ArrayList<String> classList = this.annotationToClasses.get(string);
                if (classList == null) {
                    classList = new ArrayList();
                    this.annotationToClasses.put(string, classList);
                }
                classList.add(classInfo.name);
            }
        }
        for (InterfaceInfo ii : this.interfaceNameToInterfaceInfo.values()) {
            this.finalizeInterfaceHierarchyRec(ii);
        }
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String iface : classInfo.interfaces) {
                hashSet.add(iface);
                InterfaceInfo ii = this.interfaceNameToInterfaceInfo.get(iface);
                if (ii == null) continue;
                hashSet.addAll(ii.allSuperInterfaces);
            }
            for (String iface : hashSet) {
                ArrayList<String> classList = this.interfaceToClasses.get(iface);
                if (classList == null) {
                    classList = new ArrayList();
                    this.interfaceToClasses.put(iface, classList);
                }
                classList.add(classInfo.name);
            }
        }
        for (String iface : this.interfaceToClasses.keySet()) {
            ArrayList<String> arrayList = this.interfaceToClasses.get(iface);
            HashSet<String> hashSet = new HashSet<String>(arrayList);
            for (String klass : arrayList) {
                ClassInfo ci = this.classNameToClassInfo.get(klass);
                if (ci == null) continue;
                for (ClassInfo subci : ci.allSubclasses) {
                    hashSet.add(subci.name);
                }
            }
            this.interfaceToClasses.put(iface, new ArrayList<String>(hashSet));
        }
    }

    private String readAnnotation(DataInputStream inp, Object[] constantPool) throws IOException {
        String annotationFieldDescriptor = FastClasspathScanner.readRefdString(inp, constantPool);
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        int numElementValuePairs = inp.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            inp.skipBytes(2);
            this.readAnnotationElementValue(inp, constantPool);
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue(DataInputStream inp, Object[] constantPool) throws IOException {
        int tag = inp.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                inp.skipBytes(2);
                break;
            }
            case 101: {
                inp.skipBytes(4);
                break;
            }
            case 99: {
                inp.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(inp, constantPool);
                break;
            }
            case 91: {
                int count = inp.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue(inp, constantPool);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Invalid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private static String readRefdString(DataInputStream inp, Object[] constantPool) throws IOException {
        int constantPoolIdx = inp.readUnsignedShort();
        Object constantPoolObj = constantPool[constantPoolIdx];
        return constantPoolObj instanceof Integer ? (String)constantPool[(Integer)constantPoolObj] : (String)constantPoolObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readClassInfoFromClassfileHeader(InputStream inputStream) throws IOException {
        int attributesCount;
        DataInputStream inp = new DataInputStream(new BufferedInputStream(inputStream, 1024));
        if (inp.readInt() != -889275714) {
            return;
        }
        inp.readUnsignedShort();
        inp.readUnsignedShort();
        int cpCount = inp.readUnsignedShort();
        Object[] constantPool = new Object[cpCount];
        block10: for (int i = 1; i < cpCount; ++i) {
            int tag = inp.readUnsignedByte();
            switch (tag) {
                case 1: {
                    constantPool[i] = inp.readUTF();
                    continue block10;
                }
                case 3: 
                case 4: {
                    inp.skipBytes(4);
                    continue block10;
                }
                case 5: 
                case 6: {
                    inp.skipBytes(8);
                    ++i;
                    continue block10;
                }
                case 7: 
                case 8: {
                    constantPool[i] = inp.readUnsignedShort();
                    continue block10;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    inp.skipBytes(4);
                    continue block10;
                }
                case 15: {
                    inp.skipBytes(3);
                    continue block10;
                }
                case 16: {
                    inp.skipBytes(2);
                    continue block10;
                }
                case 18: {
                    inp.skipBytes(4);
                    continue block10;
                }
                default: {
                    throw new ClassFormatError("Unkown tag value for constant pool entry: " + tag);
                }
            }
        }
        int flags = inp.readUnsignedShort();
        boolean isInterface = (flags & 0x200) != 0;
        String className = FastClasspathScanner.readRefdString(inp, constantPool).replace('/', '.');
        String superclassName = FastClasspathScanner.readRefdString(inp, constantPool).replace('/', '.');
        int interfaceCount = inp.readUnsignedShort();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (int i = 0; i < interfaceCount; ++i) {
            interfaces.add(FastClasspathScanner.readRefdString(inp, constantPool).replace('/', '.'));
        }
        int fieldCount = inp.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            inp.skipBytes(6);
            int attributesCount2 = inp.readUnsignedShort();
            for (int j = 0; j < attributesCount2; ++j) {
                inp.skipBytes(2);
                int attributeLength = inp.readInt();
                inp.skipBytes(attributeLength);
            }
        }
        int methodCount = inp.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            inp.skipBytes(6);
            attributesCount = inp.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                inp.skipBytes(2);
                int attributeLength = inp.readInt();
                inp.skipBytes(attributeLength);
            }
        }
        HashSet<String> annotations = new HashSet<String>();
        attributesCount = inp.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            String attributeName = FastClasspathScanner.readRefdString(inp, constantPool);
            int attributeLength = inp.readInt();
            if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                int annotationCount = inp.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    String annotationName = this.readAnnotation(inp, constantPool);
                    annotations.add(annotationName);
                }
                continue;
            }
            inp.skipBytes(attributeLength);
        }
        if (isInterface) {
            InterfaceInfo thisInterfaceInfo = this.interfaceNameToInterfaceInfo.get(className);
            if (thisInterfaceInfo != null) return;
            thisInterfaceInfo = new InterfaceInfo(interfaces);
            this.interfaceNameToInterfaceInfo.put(className, thisInterfaceInfo);
            return;
        } else {
            ClassInfo thisClassInfo = this.classNameToClassInfo.get(className);
            if (thisClassInfo == null) {
                thisClassInfo = new ClassInfo(className, interfaces, annotations);
                this.classNameToClassInfo.put(className, thisClassInfo);
            } else {
                if (thisClassInfo.encountered) {
                    return;
                }
                thisClassInfo.encounter(interfaces, annotations);
            }
            ClassInfo superclassInfo = this.classNameToClassInfo.get(superclassName);
            if (superclassInfo == null) {
                superclassInfo = new ClassInfo(superclassName, thisClassInfo);
                this.classNameToClassInfo.put(superclassName, superclassInfo);
                return;
            } else {
                superclassInfo.addSubclass(thisClassInfo);
            }
        }
    }

    private void scanFile(File file, String absolutePath, String relativePath, boolean scanTimestampsOnly) throws IOException {
        this.lastModified = Math.max(this.lastModified, file.lastModified());
        if (!scanTimestampsOnly) {
            if (relativePath.endsWith(".class")) {
                try (FileInputStream inputStream = new FileInputStream(file);){
                    this.readClassInfoFromClassfileHeader(inputStream);
                }
            }
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                if (!fileMatcher.pattern.matcher(relativePath).matches()) continue;
                FileInputStream inputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    fileMatcher.fileMatchProcessor.processMatch(absolutePath, relativePath, inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
        }
    }

    private void scanDir(File dir, int ignorePrefixLen, boolean scanTimestampsOnly) throws IOException {
        String absolutePath = dir.getPath();
        String relativePath = ignorePrefixLen > absolutePath.length() ? "" : absolutePath.substring(ignorePrefixLen);
        relativePath = relativePath.replace(File.separatorChar, '/');
        boolean scanDirs = false;
        boolean scanFiles = false;
        for (String pathToScan : this.pathsToScan) {
            if (relativePath.startsWith(pathToScan) || relativePath.length() == pathToScan.length() - 1 && pathToScan.startsWith(relativePath)) {
                scanFiles = true;
                scanDirs = true;
                break;
            }
            if (!pathToScan.startsWith(relativePath)) continue;
            scanDirs = true;
        }
        if (scanDirs || scanFiles) {
            File[] subFiles;
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            for (File subFile : subFiles = dir.listFiles()) {
                if (subFile.isDirectory()) {
                    this.scanDir(subFile, ignorePrefixLen, scanTimestampsOnly);
                    continue;
                }
                if (!scanFiles || !subFile.isFile()) continue;
                String leafSuffix = "/" + subFile.getName();
                this.scanFile(subFile, absolutePath + leafSuffix, relativePath + leafSuffix, scanTimestampsOnly);
            }
        }
    }

    private void scanZipfile(String zipfilePath, ZipFile zipFile, boolean scanTimestampsOnly) throws IOException {
        boolean timestampWarning = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            boolean scanFile = false;
            for (String string : this.pathsToScan) {
                if (!path.startsWith(string)) continue;
                scanFile = true;
                break;
            }
            if (!scanFile) continue;
            long entryTime = entry.getTime();
            this.lastModified = Math.max(this.lastModified, entryTime);
            if (entryTime > System.currentTimeMillis() && !timestampWarning) {
                String msg = zipfilePath + " contains modification timestamps after the current time";
                System.err.println(msg);
                timestampWarning = true;
            }
            if (scanTimestampsOnly) continue;
            if (path.endsWith(".class")) {
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    this.readClassInfoFromClassfileHeader(inputStream);
                    continue;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    inputStream.close();
                    continue;
                }
            }
            for (FilePathMatcher filePathMatcher : this.filePathMatchers) {
                if (!filePathMatcher.pattern.matcher(path).matches()) continue;
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    filePathMatcher.fileMatchProcessor.processMatch(path, path, inputStream);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    public static ArrayList<File> getUniqueClasspathElements() {
        String[] pathElements = System.getProperty("java.class.path").split(File.pathSeparator);
        HashSet<String> pathElementsSet = new HashSet<String>();
        ArrayList<File> pathFiles = new ArrayList<File>();
        for (String pathElement : pathElements) {
            File file;
            if (!pathElementsSet.add(pathElement) || !(file = new File(pathElement)).exists()) continue;
            pathFiles.add(file);
        }
        return pathFiles;
    }

    private void scan(boolean scanTimestampsOnly) {
        if (!scanTimestampsOnly) {
            this.classNameToClassInfo.clear();
            this.interfaceNameToInterfaceInfo.clear();
            this.annotationToClasses.clear();
            this.interfaceToClasses.clear();
        }
        try {
            for (File pathElt : FastClasspathScanner.getUniqueClasspathElements()) {
                String path = pathElt.getPath();
                if (pathElt.isDirectory()) {
                    this.scanDir(pathElt, path.length() + 1, scanTimestampsOnly);
                    continue;
                }
                if (!pathElt.isFile()) continue;
                String pathLower = path.toLowerCase();
                if (pathLower.endsWith(".jar") || pathLower.endsWith(".zip")) {
                    this.scanZipfile(path, new ZipFile(pathElt), scanTimestampsOnly);
                    continue;
                }
                this.scanFile(pathElt, path, pathElt.getName(), scanTimestampsOnly);
                for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                    if (!fileMatcher.pattern.matcher(path).matches()) continue;
                    FileInputStream inputStream = new FileInputStream(pathElt);
                    Throwable throwable = null;
                    try {
                        fileMatcher.fileMatchProcessor.processMatch(path, pathElt.getName(), inputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!scanTimestampsOnly) {
            this.finalizeClassHierarchy();
            for (ClassMatcher classMatcher : this.classMatchers) {
                classMatcher.lookForMatches();
            }
        }
    }

    public void scan() {
        this.scan(false);
    }

    public boolean classpathContentsModifiedSinceScan() {
        long lastModified = this.lastModified;
        this.scan(true);
        return this.lastModified > lastModified;
    }

    private static class InterfaceInfo {
        ArrayList<String> superInterfaces = new ArrayList();
        HashSet<String> allSuperInterfaces = new HashSet();

        public InterfaceInfo(ArrayList<String> superInterfaces) {
            this.superInterfaces.addAll(superInterfaces);
        }
    }

    private static class ClassInfo {
        String name;
        boolean encountered;
        ClassInfo directSuperclass;
        ArrayList<ClassInfo> directSubclasses = new ArrayList();
        HashSet<ClassInfo> allSuperclasses = new HashSet();
        HashSet<ClassInfo> allSubclasses = new HashSet();
        HashSet<String> interfaces = new HashSet();
        HashSet<String> annotations = new HashSet();

        public ClassInfo(String name, ArrayList<String> interfaces, HashSet<String> annotations) {
            this.name = name;
            this.encounter(interfaces, annotations);
        }

        public void encounter(ArrayList<String> interfaces, HashSet<String> annotations) {
            this.encountered = true;
            this.interfaces.addAll(interfaces);
            this.annotations.addAll(annotations);
        }

        public ClassInfo(String name, ClassInfo subclass) {
            this.name = name;
            this.encountered = false;
            this.addSubclass(subclass);
        }

        public void addSubclass(ClassInfo subclass) {
            if (subclass.directSuperclass != null && subclass.directSuperclass != this) {
                throw new RuntimeException(subclass.name + " has two superclasses: " + subclass.directSuperclass.name + ", " + this.name);
            }
            subclass.directSuperclass = this;
            subclass.allSuperclasses.add(this);
            this.directSubclasses.add(subclass);
            this.allSubclasses.add(subclass);
        }

        public String toString() {
            return this.name;
        }
    }

    @FunctionalInterface
    private static interface ClassMatcher {
        public void lookForMatches();
    }

    private static class FilePathMatcher {
        Pattern pattern;
        FileMatchProcessor fileMatchProcessor;

        public FilePathMatcher(Pattern pattern, FileMatchProcessor fileMatchProcessor) {
            this.pattern = pattern;
            this.fileMatchProcessor = fileMatchProcessor;
        }
    }

    @FunctionalInterface
    public static interface FileMatchProcessor {
        public void processMatch(String var1, String var2, InputStream var3);
    }

    @FunctionalInterface
    public static interface ClassAnnotationMatchProcessor {
        public void processMatch(Class<?> var1);
    }

    @FunctionalInterface
    public static interface InterfaceMatchProcessor<T> {
        public void processMatch(Class<? extends T> var1);
    }

    @FunctionalInterface
    public static interface SubclassMatchProcessor<T> {
        public void processMatch(Class<? extends T> var1);
    }
}

